/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.Action;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.DownloadNotesInViewAction;
import org.openstreetmap.josm.actions.UploadNotesAction;
import org.openstreetmap.josm.actions.mapmode.AddNoteAction;
import org.openstreetmap.josm.data.notes.Note;
import org.openstreetmap.josm.data.notes.NoteComment;
import org.openstreetmap.josm.data.osm.NoteData;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.NoteInputDialog;
import org.openstreetmap.josm.gui.NoteSortDialog;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.NoteLayer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.date.DateUtils;

public class NotesDialog
extends ToggleDialog
implements MapView.LayerChangeListener {
    public static final int ICON_SMALL_SIZE = 16;
    public static final ImageIcon ICON_OPEN = ImageProvider.get("dialogs/notes", "note_open");
    public static final ImageIcon ICON_OPEN_SMALL = new ImageIcon(ICON_OPEN.getImage().getScaledInstance(16, 16, 4));
    public static final ImageIcon ICON_CLOSED = ImageProvider.get("dialogs/notes", "note_closed");
    public static final ImageIcon ICON_CLOSED_SMALL = new ImageIcon(ICON_CLOSED.getImage().getScaledInstance(16, 16, 4));
    public static final ImageIcon ICON_NEW = ImageProvider.get("dialogs/notes", "note_new");
    public static final ImageIcon ICON_NEW_SMALL = new ImageIcon(ICON_NEW.getImage().getScaledInstance(16, 16, 4));
    public static final ImageIcon ICON_COMMENT = ImageProvider.get("dialogs/notes", "note_comment");
    private NoteTableModel model;
    private JList<Note> displayList;
    private final AddCommentAction addCommentAction = new AddCommentAction();
    private final CloseAction closeAction = new CloseAction();
    private final DownloadNotesInViewAction downloadNotesInViewAction = DownloadNotesInViewAction.newActionWithDownloadIcon();
    private final NewAction newAction = new NewAction();
    private final ReopenAction reopenAction = new ReopenAction();
    private final SortAction sortAction = new SortAction();
    private final UploadNotesAction uploadAction = new UploadNotesAction();
    private transient NoteData noteData;

    public NotesDialog() {
        super(I18n.tr("Notes", new Object[0]), "notes/note_open", I18n.tr("List of notes", new Object[0]), null, 150);
        this.buildDialog();
        MapView.addLayerChangeListener(this);
    }

    private void buildDialog() {
        this.model = new NoteTableModel();
        this.displayList = new JList<Note>(this.model);
        this.displayList.setCellRenderer(new NoteRenderer());
        this.displayList.setSelectionMode(0);
        this.displayList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (NotesDialog.this.noteData != null) {
                    NotesDialog.this.noteData.setSelectedNote((Note)NotesDialog.this.displayList.getSelectedValue());
                }
                NotesDialog.this.updateButtonStates();
            }
        });
        this.displayList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() == 2 && NotesDialog.this.noteData != null && NotesDialog.this.noteData.getSelectedNote() != null) {
                    Main.map.mapView.zoomTo(NotesDialog.this.noteData.getSelectedNote().getLatLon());
                }
            }
        });
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)new JScrollPane(this.displayList), "Center");
        this.createLayout(jPanel, false, Arrays.asList(new SideButton((Action)this.downloadNotesInViewAction, false), new SideButton((Action)this.newAction, false), new SideButton((Action)this.addCommentAction, false), new SideButton((Action)this.closeAction, false), new SideButton((Action)this.reopenAction, false), new SideButton((Action)this.sortAction, false), new SideButton((Action)this.uploadAction, false)));
        this.updateButtonStates();
    }

    private void updateButtonStates() {
        if (this.noteData == null || this.noteData.getSelectedNote() == null) {
            this.closeAction.setEnabled(false);
            this.addCommentAction.setEnabled(false);
            this.reopenAction.setEnabled(false);
        } else if (this.noteData.getSelectedNote().getState() == Note.State.OPEN) {
            this.closeAction.setEnabled(true);
            this.addCommentAction.setEnabled(true);
            this.reopenAction.setEnabled(false);
        } else {
            this.closeAction.setEnabled(false);
            this.addCommentAction.setEnabled(false);
            this.reopenAction.setEnabled(true);
        }
        if (this.noteData == null || !this.noteData.isModified()) {
            this.uploadAction.setEnabled(false);
        } else {
            this.uploadAction.setEnabled(true);
        }
        if (this.noteData == null || this.noteData.getNotes().isEmpty()) {
            this.sortAction.setEnabled(false);
        } else {
            this.sortAction.setEnabled(true);
        }
    }

    @Override
    public void activeLayerChange(Layer layer, Layer layer2) {
    }

    @Override
    public void layerAdded(Layer layer) {
        if (layer instanceof NoteLayer) {
            this.noteData = ((NoteLayer)layer).getNoteData();
            this.model.setData(this.noteData.getNotes());
            this.setNotes(this.noteData.getSortedNotes());
        }
    }

    @Override
    public void layerRemoved(Layer layer) {
        if (layer instanceof NoteLayer) {
            this.noteData = null;
            this.model.clearData();
            if (Main.map.mapMode instanceof AddNoteAction) {
                Main.map.selectMapMode(Main.map.mapModeSelect);
            }
        }
    }

    public void setNotes(Collection<Note> collection) {
        this.model.setData(collection);
        this.updateButtonStates();
        this.repaint();
    }

    public void selectionChanged() {
        if (this.noteData == null || this.noteData.getSelectedNote() == null) {
            this.displayList.clearSelection();
        } else {
            this.displayList.setSelectedValue(this.noteData.getSelectedNote(), true);
        }
        this.updateButtonStates();
        Main.main.menu.infoweb.noteSelectionChanged();
    }

    public Note getSelectedNote() {
        return this.noteData != null ? this.noteData.getSelectedNote() : null;
    }

    class SortAction
    extends AbstractAction {
        SortAction() {
            this.putValue("ShortDescription", I18n.tr("Sort notes", new Object[0]));
            this.putValue("Name", I18n.tr("Sort", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "sort"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            NoteSortDialog noteSortDialog = new NoteSortDialog(Main.parent, I18n.tr("Sort notes", new Object[0]), I18n.tr("Apply", new Object[0]));
            noteSortDialog.showSortDialog(NotesDialog.this.noteData.getCurrentSortMethod());
            if (noteSortDialog.getValue() == 1) {
                NotesDialog.this.noteData.setSortMethod(noteSortDialog.getSelectedComparator());
            }
        }
    }

    class ReopenAction
    extends AbstractAction {
        ReopenAction() {
            this.putValue("ShortDescription", I18n.tr("Reopen note", new Object[0]));
            this.putValue("Name", I18n.tr("Reopen", new Object[0]));
            this.putValue("SmallIcon", ICON_OPEN);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            NoteInputDialog noteInputDialog = new NoteInputDialog(Main.parent, I18n.tr("Reopen note", new Object[0]), I18n.tr("Reopen note", new Object[0]));
            noteInputDialog.showNoteDialog(I18n.tr("Reopen note with message:", new Object[0]), ICON_OPEN);
            if (noteInputDialog.getValue() != 1) {
                return;
            }
            Note note = (Note)NotesDialog.this.displayList.getSelectedValue();
            int n = NotesDialog.this.displayList.getSelectedIndex();
            NotesDialog.this.noteData.reOpenNote(note, noteInputDialog.getInputText());
            NotesDialog.this.noteData.setSelectedNote(NotesDialog.this.model.getElementAt(n));
        }
    }

    class NewAction
    extends AbstractAction {
        NewAction() {
            this.putValue("ShortDescription", I18n.tr("Create a new note", new Object[0]));
            this.putValue("Name", I18n.tr("Create", new Object[0]));
            this.putValue("SmallIcon", ICON_NEW);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (NotesDialog.this.noteData == null) {
                Main.map.mapView.addLayer(new NoteLayer());
            }
            Main.map.selectMapMode(new AddNoteAction(Main.map, NotesDialog.this.noteData));
        }
    }

    class CloseAction
    extends AbstractAction {
        CloseAction() {
            this.putValue("ShortDescription", I18n.tr("Close note", new Object[0]));
            this.putValue("Name", I18n.tr("Close", new Object[0]));
            this.putValue("SmallIcon", ICON_CLOSED);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            NoteInputDialog noteInputDialog = new NoteInputDialog(Main.parent, I18n.tr("Close note", new Object[0]), I18n.tr("Close note", new Object[0]));
            noteInputDialog.showNoteDialog(I18n.tr("Close note with message:", new Object[0]), ICON_CLOSED);
            if (noteInputDialog.getValue() != 1) {
                return;
            }
            Note note = (Note)NotesDialog.this.displayList.getSelectedValue();
            int n = NotesDialog.this.displayList.getSelectedIndex();
            NotesDialog.this.noteData.closeNote(note, noteInputDialog.getInputText());
            NotesDialog.this.noteData.setSelectedNote(NotesDialog.this.model.getElementAt(n));
        }
    }

    class AddCommentAction
    extends AbstractAction {
        AddCommentAction() {
            this.putValue("ShortDescription", I18n.tr("Add comment", new Object[0]));
            this.putValue("Name", I18n.tr("Comment", new Object[0]));
            this.putValue("SmallIcon", ICON_COMMENT);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Note note = (Note)NotesDialog.this.displayList.getSelectedValue();
            if (note == null) {
                JOptionPane.showMessageDialog(Main.map, "You must select a note first", "No note selected", 0);
                return;
            }
            NoteInputDialog noteInputDialog = new NoteInputDialog(Main.parent, I18n.tr("Comment on note", new Object[0]), I18n.tr("Add comment", new Object[0]));
            noteInputDialog.showNoteDialog(I18n.tr("Add comment to note:", new Object[0]), ICON_COMMENT);
            if (noteInputDialog.getValue() != 1) {
                return;
            }
            int n = NotesDialog.this.displayList.getSelectedIndex();
            NotesDialog.this.noteData.addCommentToNote(note, noteInputDialog.getInputText());
            NotesDialog.this.noteData.setSelectedNote(NotesDialog.this.model.getElementAt(n));
        }
    }

    class NoteTableModel
    extends AbstractListModel<Note> {
        private final transient List<Note> data = new ArrayList<Note>();

        NoteTableModel() {
        }

        @Override
        public int getSize() {
            if (this.data == null) {
                return 0;
            }
            return this.data.size();
        }

        @Override
        public Note getElementAt(int n) {
            return this.data.get(n);
        }

        public void setData(Collection<Note> collection) {
            this.data.clear();
            this.data.addAll(collection);
            this.fireContentsChanged(this, 0, collection.size());
        }

        public void clearData() {
            NotesDialog.this.displayList.clearSelection();
            this.data.clear();
            this.fireIntervalRemoved(this, 0, this.getSize());
        }
    }

    private static class NoteRenderer
    implements ListCellRenderer<Note> {
        private final DefaultListCellRenderer defaultListCellRenderer = new DefaultListCellRenderer();
        private final DateFormat dateFormat = DateUtils.getDateTimeFormat(2, 3);

        private NoteRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends Note> jList, Note note, int n, boolean bl, boolean bl2) {
            Component component = this.defaultListCellRenderer.getListCellRendererComponent(jList, note, n, bl, bl2);
            if (note != null && component instanceof JLabel) {
                Object object;
                NoteComment noteComment = note.getFirstComment();
                JLabel jLabel = (JLabel)component;
                if (noteComment != null) {
                    object = note.getFirstComment().getText();
                    String string = note.getFirstComment().getUser().getName();
                    if (string == null || string.isEmpty()) {
                        string = "<Anonymous>";
                    }
                    String string2 = string + " @ " + this.dateFormat.format(note.getCreatedAt());
                    jLabel.setToolTipText(string2);
                    jLabel.setText(note.getId() + ": " + (String)object);
                } else {
                    jLabel.setToolTipText(null);
                    jLabel.setText(Long.toString(note.getId()));
                }
                object = note.getId() < 0L ? ICON_NEW_SMALL : (note.getState() == Note.State.CLOSED ? ICON_CLOSED_SMALL : ICON_OPEN_SMALL);
                jLabel.setIcon((Icon)object);
            }
            return component;
        }
    }
}

