/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.changeset;

import java.awt.Component;
import javax.swing.JTable;
import javax.swing.UIManager;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.gui.dialogs.changeset.AbstractCellRenderer;
import org.openstreetmap.josm.tools.I18n;

public class ChangesetCacheTableCellRenderer
extends AbstractCellRenderer {
    protected void renderUploadComment(Changeset changeset) {
        String string = changeset.get("comment");
        if (string == null || string.trim().isEmpty()) {
            this.setText(I18n.trc("changeset.upload-comment", "empty"));
            this.setFont(UIManager.getFont("Table.font").deriveFont(2));
        } else {
            this.setText(string);
            this.setToolTipText(string);
            this.setFont(UIManager.getFont("Table.font"));
        }
    }

    protected void renderOpen(Changeset changeset) {
        if (changeset.isOpen()) {
            this.setText(I18n.trc("changeset.state", "Open"));
        } else {
            this.setText(I18n.trc("changeset.state", "Closed"));
        }
        this.setToolTipText(null);
    }

    protected void renderDiscussions(Changeset changeset) {
        this.setText(Integer.toString(changeset.getCommentsCount()));
        this.setToolTipText(null);
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        if (object == null) {
            return this;
        }
        this.reset();
        this.renderColors(bl);
        Changeset changeset = (Changeset)object;
        switch (n2) {
            case 0: {
                this.renderId(changeset.getId());
                break;
            }
            case 1: {
                this.renderUploadComment(changeset);
                break;
            }
            case 2: {
                this.renderOpen(changeset);
                break;
            }
            case 3: {
                this.renderUser(changeset.getUser());
                break;
            }
            case 4: {
                this.renderDate(changeset.getCreatedAt());
                break;
            }
            case 5: {
                this.renderDate(changeset.getClosedAt());
                break;
            }
            case 6: {
                this.renderDiscussions(changeset);
                break;
            }
        }
        return this;
    }
}

