/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.tagging.presets;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.search.SearchCompiler;
import org.openstreetmap.josm.command.ChangePropertyCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Tag;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.Notification;
import org.openstreetmap.josm.gui.dialogs.relation.RelationEditor;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.preferences.ToolbarPreferences;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPresetItem;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPresetMenu;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPresetReader;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPresetType;
import org.openstreetmap.josm.gui.tagging.presets.items.Key;
import org.openstreetmap.josm.gui.tagging.presets.items.Label;
import org.openstreetmap.josm.gui.tagging.presets.items.Link;
import org.openstreetmap.josm.gui.tagging.presets.items.Optional;
import org.openstreetmap.josm.gui.tagging.presets.items.PresetLink;
import org.openstreetmap.josm.gui.tagging.presets.items.Roles;
import org.openstreetmap.josm.gui.tagging.presets.items.Space;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.ImageResource;
import org.openstreetmap.josm.tools.Predicate;
import org.openstreetmap.josm.tools.Utils;
import org.openstreetmap.josm.tools.template_engine.ParseError;
import org.openstreetmap.josm.tools.template_engine.TemplateEntry;
import org.openstreetmap.josm.tools.template_engine.TemplateParser;
import org.xml.sax.SAXException;

public class TaggingPreset
extends AbstractAction
implements MapView.LayerChangeListener,
Predicate<OsmPrimitive> {
    public static final int DIALOG_ANSWER_APPLY = 1;
    public static final int DIALOG_ANSWER_NEW_RELATION = 2;
    public static final int DIALOG_ANSWER_CANCEL = 3;
    public static final String OPTIONAL_TOOLTIP_TEXT = "Optional tooltip text";
    public static final String PRESET_ICON_ERROR_MSG_PREFIX = "Could not get presets icon ";
    public TaggingPresetMenu group;
    public String name;
    public String iconName;
    public String name_context;
    public String locale_name;
    public boolean preset_name_label;
    public transient Set<TaggingPresetType> types;
    public final transient List<TaggingPresetItem> data = new LinkedList<TaggingPresetItem>();
    public transient Roles roles;
    public transient TemplateEntry nameTemplate;
    public transient SearchCompiler.Match nameTemplateFilter;
    private boolean originalSelectionEmpty;

    public TaggingPreset() {
        MapView.addLayerChangeListener(this);
        this.updateEnabledState();
    }

    public void setDisplayName() {
        this.putValue("Name", this.getName());
        this.putValue("toolbar", "tagging_" + this.getRawName());
        this.putValue(OPTIONAL_TOOLTIP_TEXT, this.group != null ? I18n.tr("Use preset ''{0}'' of group ''{1}''", this.getLocaleName(), this.group.getName()) : I18n.tr("Use preset ''{0}''", this.getLocaleName()));
    }

    public String getLocaleName() {
        if (this.locale_name == null) {
            this.locale_name = this.name_context != null ? I18n.trc(this.name_context, TaggingPresetItem.fixPresetString(this.name)) : I18n.tr(TaggingPresetItem.fixPresetString(this.name), new Object[0]);
        }
        return this.locale_name;
    }

    public String getName() {
        return this.group != null ? this.group.getName() + '/' + this.getLocaleName() : this.getLocaleName();
    }

    public String getRawName() {
        return this.group != null ? this.group.getRawName() + '/' + this.name : this.name;
    }

    public final ImageIcon getIcon() {
        Object object = this.getValue("SmallIcon");
        if (object instanceof ImageIcon) {
            return (ImageIcon)object;
        }
        return null;
    }

    public void setIcon(final String string) {
        this.iconName = string;
        if (!TaggingPresetReader.isLoadIcons()) {
            return;
        }
        File file = TaggingPresetReader.getZipIcons();
        Collection<String> collection = Main.pref.getCollection("taggingpreset.icon.sources", null);
        ImageProvider imageProvider = new ImageProvider(string);
        imageProvider.setDirs(collection);
        imageProvider.setId("presets");
        imageProvider.setArchive(file);
        imageProvider.setOptional(true);
        imageProvider.getInBackground(new ImageProvider.ImageResourceCallback(){

            @Override
            public void finished(final ImageResource imageResource) {
                if (imageResource != null) {
                    GuiHelper.runInEDT(new Runnable(){

                        @Override
                        public void run() {
                            imageResource.getImageIcon(TaggingPreset.this);
                        }
                    });
                } else {
                    Main.warn(TaggingPreset.this + ": " + TaggingPreset.PRESET_ICON_ERROR_MSG_PREFIX + string);
                }
            }
        });
    }

    public void setType(String string) throws SAXException {
        this.types = TaggingPresetItem.getType(string);
    }

    public void setName_template(String string) throws SAXException {
        try {
            this.nameTemplate = new TemplateParser(string).parse();
        }
        catch (ParseError parseError) {
            Main.error("Error while parsing " + string + ": " + parseError.getMessage());
            throw new SAXException(parseError);
        }
    }

    public void setName_template_filter(String string) throws SAXException {
        try {
            this.nameTemplateFilter = SearchCompiler.compile(string);
        }
        catch (SearchCompiler.ParseError parseError) {
            Main.error("Error while parsing" + string + ": " + parseError.getMessage());
            throw new SAXException(parseError);
        }
    }

    private List<Tag> getDirectlyAppliedTags() {
        ArrayList<Tag> arrayList = new ArrayList<Tag>();
        for (TaggingPresetItem taggingPresetItem : this.data) {
            if (!(taggingPresetItem instanceof Key)) continue;
            arrayList.add(((Key)taggingPresetItem).asTag());
        }
        return arrayList;
    }

    public PresetPanel createPanel(Collection<OsmPrimitive> collection) {
        JComponent jComponent;
        Object object;
        Object object2;
        PresetPanel presetPanel = new PresetPanel();
        LinkedList<Link> linkedList = new LinkedList<Link>();
        LinkedList<PresetLink> linkedList2 = new LinkedList<PresetLink>();
        JPanel jPanel = new JPanel();
        if (this.types != null) {
            object2 = this.types.iterator();
            while (object2.hasNext()) {
                object = (TaggingPresetType)((Object)object2.next());
                jComponent = new JLabel(ImageProvider.get(((TaggingPresetType)((Object)object)).getIconName()));
                jComponent.setToolTipText(I18n.tr("Elements of type {0} are supported.", I18n.tr(((TaggingPresetType)((Object)object)).getName(), new Object[0])));
                jPanel.add(jComponent);
            }
        }
        if (!(object2 = this.getDirectlyAppliedTags()).isEmpty()) {
            object = new JLabel(ImageProvider.get("pastetags"));
            ((JComponent)object).setToolTipText("<html>" + I18n.tr("This preset also sets: {0}", Utils.joinAsHtmlUnorderedList(object2)));
            jPanel.add((Component)object);
        }
        if (jPanel.getComponentCount() > 0) {
            presetPanel.add((Component)jPanel, GBC.eol());
        }
        if (this.preset_name_label) {
            Label.addLabel(presetPanel, this.getIcon(), this.getName());
        }
        boolean bl = !collection.isEmpty() && Utils.forAll(collection, this);
        jComponent = new JPanel(new GridBagLayout());
        for (TaggingPresetItem taggingPresetItem : this.data) {
            if (taggingPresetItem instanceof Link) {
                linkedList.add((Link)taggingPresetItem);
                presetPanel.hasElements = true;
                continue;
            }
            if (taggingPresetItem instanceof PresetLink) {
                linkedList2.add((PresetLink)taggingPresetItem);
                continue;
            }
            if (!taggingPresetItem.addToPanel((JPanel)jComponent, collection, bl)) continue;
            presetPanel.hasElements = true;
        }
        presetPanel.add((Component)jComponent, GBC.eol().fill());
        if (collection.isEmpty() && !this.supportsRelation()) {
            GuiHelper.setEnabledRec(jComponent, false);
        }
        if (!linkedList2.isEmpty()) {
            presetPanel.add((Component)new JLabel(I18n.tr("Edit also \u2026", new Object[0])), GBC.eol().insets(0, 8, 0, 0));
            for (PresetLink presetLink : linkedList2) {
                presetLink.addToPanel(presetPanel, collection, bl);
            }
        }
        for (Link link : linkedList) {
            link.addToPanel(presetPanel, collection, bl);
        }
        Iterator iterator = new JToggleButton(new ToolbarButtonAction());
        ((Component)((Object)iterator)).setFocusable(false);
        presetPanel.add((Component)((Object)iterator), GBC.std(0, 0).anchor(22));
        return presetPanel;
    }

    public boolean isShowable() {
        for (TaggingPresetItem taggingPresetItem : this.data) {
            if (taggingPresetItem instanceof Optional || taggingPresetItem instanceof Space || taggingPresetItem instanceof Key) continue;
            return true;
        }
        return false;
    }

    public String suggestRoleForOsmPrimitive(OsmPrimitive osmPrimitive) {
        if (this.roles != null && osmPrimitive != null) {
            for (Roles.Role role : this.roles.roles) {
                if (role.memberExpression == null || !role.memberExpression.match(osmPrimitive) || role.types != null && !role.types.isEmpty() && !role.types.contains((Object)TaggingPresetType.forPrimitive(osmPrimitive))) continue;
                return role.key;
            }
        }
        return null;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (Main.main == null) {
            return;
        }
        DataSet dataSet = Main.main.getCurrentDataSet();
        Collection<OsmPrimitive> collection = Collections.emptyList();
        if (Main.main != null && dataSet != null) {
            collection = dataSet.getSelected();
        }
        Collection<OsmPrimitive> collection2 = this.createSelection(collection);
        int n = this.showDialog(collection2, this.supportsRelation());
        if (dataSet == null) {
            return;
        }
        if (!collection2.isEmpty() && n == 1) {
            Command command = TaggingPreset.createCommand(collection2, this.getChangedTags());
            if (command != null) {
                Main.main.undoRedo.add(command);
            }
        } else if (n == 2) {
            final Relation relation = new Relation();
            final HashSet<RelationMember> hashSet = new HashSet<RelationMember>();
            for (Tag tagged : this.getChangedTags()) {
                relation.put(tagged.getKey(), tagged.getValue());
            }
            for (OsmPrimitive osmPrimitive : dataSet.getSelected()) {
                String string = this.suggestRoleForOsmPrimitive(osmPrimitive);
                RelationMember relationMember = new RelationMember(string == null ? "" : string, osmPrimitive);
                relation.addMember(relationMember);
                hashSet.add(relationMember);
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    RelationEditor.getEditor(Main.main.getEditLayer(), relation, hashSet).setVisible(true);
                }
            });
        }
        dataSet.setSelected(dataSet.getSelected());
    }

    public int showDialog(Collection<OsmPrimitive> collection, boolean bl) {
        boolean bl2;
        PresetPanel presetPanel = this.createPanel(collection);
        if (presetPanel == null) {
            return 3;
        }
        int n = 1;
        boolean bl3 = bl2 = this.types == null || this.types.contains((Object)TaggingPresetType.RELATION);
        if (this.originalSelectionEmpty && !bl2) {
            new Notification(I18n.tr("The preset <i>{0}</i> cannot be applied since nothing has been selected!", this.getLocaleName())).setIcon(2).show();
            return 3;
        }
        if (collection.isEmpty() && !bl2) {
            new Notification(I18n.tr("The preset <i>{0}</i> cannot be applied since the selection is unsuitable!", this.getLocaleName())).setIcon(2).show();
            return 3;
        }
        if (presetPanel.getComponentCount() != 0 && (collection.isEmpty() || presetPanel.hasElements)) {
            String string = I18n.trn("Change {0} object", "Change {0} objects", collection.size(), collection.size());
            if (collection.isEmpty()) {
                string = this.originalSelectionEmpty ? I18n.tr("Nothing selected!", new Object[0]) : I18n.tr("Selection unsuitable!", new Object[0]);
            }
            n = new PresetDialog((Component)presetPanel, string, this.preset_name_label ? null : (ImageIcon)this.getValue("SmallIcon"), collection.isEmpty(), bl).getValue();
        }
        if (!bl && n == 2) {
            return 3;
        }
        return n;
    }

    public Collection<OsmPrimitive> createSelection(Collection<OsmPrimitive> collection) {
        this.originalSelectionEmpty = collection.isEmpty();
        LinkedList<OsmPrimitive> linkedList = new LinkedList<OsmPrimitive>();
        for (OsmPrimitive osmPrimitive : collection) {
            if (!this.typeMatches(EnumSet.of(TaggingPresetType.forPrimitive(osmPrimitive)))) continue;
            linkedList.add(osmPrimitive);
        }
        return linkedList;
    }

    public List<Tag> getChangedTags() {
        ArrayList<Tag> arrayList = new ArrayList<Tag>();
        for (TaggingPresetItem taggingPresetItem : this.data) {
            taggingPresetItem.addCommands(arrayList);
        }
        return arrayList;
    }

    public static Command createCommand(Collection<OsmPrimitive> collection, List<Tag> list) {
        ArrayList<Command> arrayList = new ArrayList<Command>();
        for (Tag tag : list) {
            ChangePropertyCommand changePropertyCommand = new ChangePropertyCommand(collection, tag.getKey(), tag.getValue());
            if (changePropertyCommand.getObjectsNumber() <= 0) continue;
            arrayList.add(changePropertyCommand);
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        if (arrayList.size() == 1) {
            return (Command)arrayList.get(0);
        }
        return new SequenceCommand(I18n.tr("Change Tags", new Object[0]), arrayList);
    }

    private boolean supportsRelation() {
        return this.types == null || this.types.contains((Object)TaggingPresetType.RELATION);
    }

    protected final void updateEnabledState() {
        this.setEnabled(Main.main != null && Main.main.getCurrentDataSet() != null);
    }

    @Override
    public void activeLayerChange(Layer layer, Layer layer2) {
        this.updateEnabledState();
    }

    @Override
    public void layerAdded(Layer layer) {
        this.updateEnabledState();
    }

    @Override
    public void layerRemoved(Layer layer) {
        this.updateEnabledState();
    }

    public String toString() {
        return (this.types == null ? "" : this.types.toString()) + ' ' + this.name;
    }

    public boolean typeMatches(Collection<TaggingPresetType> collection) {
        return collection == null || this.types == null || this.types.containsAll(collection);
    }

    @Override
    public boolean evaluate(OsmPrimitive osmPrimitive) {
        return this.matches(EnumSet.of(TaggingPresetType.forPrimitive(osmPrimitive)), osmPrimitive.getKeys(), false);
    }

    public boolean matches(Collection<TaggingPresetType> collection, Map<String, String> map, boolean bl) {
        if (bl && !this.isShowable()) {
            return false;
        }
        if (!this.typeMatches(collection)) {
            return false;
        }
        return TaggingPresetItem.matches(this.data, map);
    }

    public String getToolbarString() {
        ToolbarPreferences.ActionParser actionParser = new ToolbarPreferences.ActionParser(null);
        return actionParser.saveAction(new ToolbarPreferences.ActionDefinition(this));
    }

    public class ToolbarButtonAction
    extends AbstractAction {
        private final int toolbarIndex;

        public ToolbarButtonAction() {
            super("", ImageProvider.get("dialogs", "pin"));
            this.putValue("ShortDescription", I18n.tr("Add or remove toolbar button", new Object[0]));
            LinkedList<String> linkedList = new LinkedList<String>(ToolbarPreferences.getToolString());
            this.toolbarIndex = linkedList.indexOf(TaggingPreset.this.getToolbarString());
            this.putValue("SwingSelectedKey", this.toolbarIndex >= 0);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = TaggingPreset.this.getToolbarString();
            Main.toolbar.addCustomButton(string, this.toolbarIndex, true);
        }
    }

    private static class PresetDialog
    extends ExtendedDialog {
        PresetDialog(Component component, String string, ImageIcon imageIcon, boolean bl, boolean bl2) {
            String[] stringArray;
            if (bl2) {
                String[] stringArray2 = new String[3];
                stringArray2[0] = I18n.tr("Apply Preset", new Object[0]);
                stringArray2[1] = I18n.tr("New relation", new Object[0]);
                stringArray = stringArray2;
                stringArray2[2] = I18n.tr("Cancel", new Object[0]);
            } else {
                String[] stringArray3 = new String[2];
                stringArray3[0] = I18n.tr("Apply Preset", new Object[0]);
                stringArray = stringArray3;
                stringArray3[1] = I18n.tr("Cancel", new Object[0]);
            }
            super(Main.parent, string, stringArray, true);
            if (imageIcon != null) {
                this.setIconImage(imageIcon.getImage());
            }
            this.contentInsets = new Insets(10, 5, 0, 5);
            if (bl2) {
                this.setButtonIcons(new String[]{"ok", "dialogs/addrelation", "cancel"});
            } else {
                this.setButtonIcons(new String[]{"ok", "cancel"});
            }
            this.setContent(component);
            this.setDefaultButton(1);
            this.setupDialog();
            ((JButton)this.buttons.get(0)).setEnabled(!bl);
            ((JButton)this.buttons.get(0)).setToolTipText(string);
            Dimension dimension = this.getSize();
            if (dimension.width < 350) {
                dimension.width = 350;
                this.setSize(dimension);
            }
            this.showDialog();
        }
    }

    private static class PresetPanel
    extends JPanel {
        private boolean hasElements;

        PresetPanel() {
            super(new GridBagLayout());
        }
    }
}

