/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools.bugreport;

import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagLayout;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.ReportBugAction;
import org.openstreetmap.josm.actions.ShowStatusReportAction;
import org.openstreetmap.josm.data.Version;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.preferences.plugin.PluginPreference;
import org.openstreetmap.josm.gui.widgets.JMultilineLabel;
import org.openstreetmap.josm.gui.widgets.UrlLabel;
import org.openstreetmap.josm.plugins.PluginDownloadTask;
import org.openstreetmap.josm.plugins.PluginHandler;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.WikiReader;
import org.openstreetmap.josm.tools.bugreport.DebugTextDisplay;
import org.openstreetmap.josm.tools.bugreport.ReportedException;

public final class BugReportExceptionHandler
implements Thread.UncaughtExceptionHandler {
    private static boolean handlingInProgress;
    private static volatile BugReporterThread bugReporterThread;
    private static int exceptionCounter;
    private static boolean suppressExceptionDialogs;

    @Override
    public void uncaughtException(Thread thread, Throwable throwable) {
        BugReportExceptionHandler.handleException(throwable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void handleException(Throwable throwable) {
        if (handlingInProgress || suppressExceptionDialogs) {
            return;
        }
        if (bugReporterThread != null && bugReporterThread.isAlive()) {
            return;
        }
        handlingInProgress = true;
        ++exceptionCounter;
        try {
            Main.error(throwable);
            if (Main.parent != null) {
                if (throwable instanceof OutOfMemoryError) {
                    JOptionPane.showMessageDialog(Main.parent, "JOSM is out of memory. Strange things may happen.\nPlease restart JOSM with the -Xmx###M option,\nwhere ### is the number of MB assigned to JOSM (e.g. 256).\nCurrently, " + Runtime.getRuntime().maxMemory() / 1024L / 1024L + " MB are available to JOSM.", "Error", 0);
                    return;
                }
                bugReporterThread = new BugReporterThread(throwable);
                bugReporterThread.start();
            }
        }
        finally {
            handlingInProgress = false;
        }
    }

    static JPanel buildPanel(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        if (throwable instanceof ReportedException) {
            ((ReportedException)throwable).printReportDataTo(printWriter);
            ((ReportedException)throwable).printReportStackTo(printWriter);
        } else {
            throwable.printStackTrace(printWriter);
        }
        String string = ShowStatusReportAction.getReportHeader() + stringWriter.getBuffer().toString();
        string = string.replaceAll("\r", "");
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add((Component)new JMultilineLabel(I18n.tr("You have encountered an error in JOSM. Before you file a bug report make sure you have updated to the latest version of JOSM here:", new Object[0])), GBC.eol().fill(2));
        jPanel.add((Component)new UrlLabel(Main.getJOSMWebsite(), 2), GBC.eop().insets(8, 0, 0, 0));
        jPanel.add((Component)new JMultilineLabel(I18n.tr("You should also update your plugins. If neither of those help please file a bug report in our bugtracker using this link:", new Object[0])), GBC.eol().fill(2));
        jPanel.add((Component)new JButton(new ReportBugAction(string)), GBC.eop().insets(8, 0, 0, 0));
        jPanel.add((Component)new JMultilineLabel(I18n.tr("There the error information provided below should already be filled in for you. Please include information on how to reproduce the error and try to supply as much detail as possible.", new Object[0])), GBC.eop().fill(2));
        jPanel.add((Component)new JMultilineLabel(I18n.tr("Alternatively, if that does not work you can manually fill in the information below at this URL:", new Object[0])), GBC.eol().fill(2));
        jPanel.add((Component)new UrlLabel(Main.getJOSMWebsite() + "/newticket", 2), GBC.eop().insets(8, 0, 0, 0));
        DebugTextDisplay debugTextDisplay = new DebugTextDisplay(string);
        if (debugTextDisplay.copyToClippboard()) {
            jPanel.add((Component)new JLabel(I18n.tr("(The text has already been copied to your clipboard.)", new Object[0])), GBC.eop().fill(2));
        }
        jPanel.add((Component)debugTextDisplay, GBC.eop().fill());
        for (Component component : jPanel.getComponents()) {
            if (!(component instanceof JMultilineLabel)) continue;
            ((JMultilineLabel)component).setMaxWidth(400);
        }
        return jPanel;
    }

    public static boolean exceptionHandlingInProgress() {
        return handlingInProgress;
    }

    static final class BugReporterThread
    extends Thread {
        private final Throwable e;

        private BugReporterThread(Throwable throwable) {
            super("Bug Reporter");
            this.e = throwable;
        }

        static void askForBugReport(Throwable throwable) {
            String[] stringArray = new String[]{I18n.tr("Do nothing", new Object[0]), I18n.tr("Report Bug", new Object[0])};
            String[] stringArray2 = new String[]{"cancel", "bug"};
            int n = 1;
            String string = I18n.tr("An unexpected exception occurred.<br>This is always a coding error. If you are running the latest<br>version of JOSM, please consider being kind and file a bug report.", new Object[0]);
            int n2 = Version.getInstance().getVersion();
            if (n2 != 0) {
                try {
                    int n3 = Integer.parseInt(new WikiReader().read(Main.getJOSMWebsite() + "/wiki/TestedVersion?format=txt").trim());
                    if (n3 > n2) {
                        stringArray = new String[]{I18n.tr("Do nothing", new Object[0]), I18n.tr("Update JOSM", new Object[0]), I18n.tr("Report Bug", new Object[0])};
                        stringArray2 = new String[]{"cancel", "download", "bug"};
                        n = 2;
                        string = I18n.tr("An unexpected exception occurred. This is always a coding error.<br><br>However, you are running an old version of JOSM ({0}),<br>instead of using the current tested version (<b>{1}</b>).<br><br><b>Please update JOSM</b> before considering to file a bug report.", String.valueOf(n2), String.valueOf(n3));
                    }
                }
                catch (IOException | NumberFormatException exception) {
                    Main.warn("Unable to detect latest version of JOSM: " + exception.getMessage());
                }
            }
            JPanel jPanel = new JPanel(new GridBagLayout());
            jPanel.add((Component)new JLabel("<html>" + string + "</html>"), GBC.eol());
            JCheckBox jCheckBox = null;
            if (exceptionCounter > 1) {
                jCheckBox = new JCheckBox(I18n.tr("Suppress further error dialogs for this session.", new Object[0]));
                jPanel.add((Component)jCheckBox, GBC.eol());
            }
            if (GraphicsEnvironment.isHeadless()) {
                return;
            }
            ExtendedDialog extendedDialog = new ExtendedDialog(Main.parent, I18n.tr("Unexpected Exception", new Object[0]), stringArray);
            extendedDialog.setButtonIcons(stringArray2);
            extendedDialog.setIcon(0);
            extendedDialog.setCancelButton(1);
            extendedDialog.setDefaultButton(n);
            extendedDialog.setContent(jPanel);
            extendedDialog.setFocusOnDefaultButton(true);
            extendedDialog.showDialog();
            if (jCheckBox != null && jCheckBox.isSelected()) {
                suppressExceptionDialogs = true;
            }
            if (extendedDialog.getValue() <= 1) {
                return;
            }
            if (extendedDialog.getValue() < stringArray.length) {
                try {
                    Main.platform.openUrl(Main.getJOSMWebsite());
                }
                catch (IOException iOException) {
                    Main.warn("Unable to access JOSM website: " + iOException.getMessage());
                }
            } else {
                try {
                    JPanel jPanel2 = BugReportExceptionHandler.buildPanel(throwable);
                    JOptionPane.showMessageDialog(Main.parent, jPanel2, I18n.tr("You have encountered a bug in JOSM", new Object[0]), 0);
                }
                catch (RuntimeException runtimeException) {
                    Main.error(runtimeException);
                }
            }
        }

        @Override
        public void run() {
            SwingUtilities.invokeLater(new BugReporterWorker(PluginHandler.updateOrdisablePluginAfterException(this.e)));
        }

        private final class BugReporterWorker
        implements Runnable {
            private final PluginDownloadTask pluginDownloadTask;

            private BugReporterWorker(PluginDownloadTask pluginDownloadTask) {
                this.pluginDownloadTask = pluginDownloadTask;
            }

            @Override
            public void run() {
                if (this.pluginDownloadTask == null) {
                    BugReporterThread.askForBugReport(BugReporterThread.this.e);
                } else {
                    PluginPreference.notifyDownloadResults(Main.parent, this.pluginDownloadTask, !this.pluginDownloadTask.getDownloadedPlugins().isEmpty());
                }
            }
        }
    }
}

