/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import jnr.posix.FileStat;
import jnr.posix.util.Platform;
import org.jcodings.Encoding;
import org.jcodings.specific.UTF8Encoding;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyEncoding;
import org.jruby.RubyEnumerator;
import org.jruby.RubyFile;
import org.jruby.RubyFixnum;
import org.jruby.RubyHash;
import org.jruby.RubyInteger;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.RaiseException;
import org.jruby.javasupport.JavaUtil;
import org.jruby.runtime.Block;
import org.jruby.runtime.ClassIndex;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.Dir;
import org.jruby.util.FileResource;
import org.jruby.util.JRubyFile;
import org.jruby.util.StringSupport;

@JRubyClass(name={"Dir"}, include={"Enumerable"})
public class RubyDir
extends RubyObject {
    private RubyString path;
    protected FileResource dir;
    private long lastModified = Long.MIN_VALUE;
    private String[] snapshot;
    private int pos;
    private boolean isOpen = true;
    private static final Encoding UTF8 = UTF8Encoding.INSTANCE;
    private static Pattern PROTOCOL_PATTERN = Pattern.compile("^(uri|jar|file|classpath):([^:]*:)?//?.*");
    private static final ObjectAllocator DIR_ALLOCATOR = new ObjectAllocator(){

        @Override
        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return new RubyDir(runtime, klass);
        }
    };
    private static final String[] NO_FILES = StringSupport.EMPTY_STRING_ARRAY;
    static final ByteList HOME = new ByteList(new byte[]{72, 79, 77, 69}, false);

    public RubyDir(Ruby runtime, RubyClass type2) {
        super(runtime, type2);
    }

    public static RubyClass createDirClass(Ruby runtime) {
        RubyClass dirClass = runtime.defineClass("Dir", runtime.getObject(), DIR_ALLOCATOR);
        runtime.setDir(dirClass);
        dirClass.setClassIndex(ClassIndex.DIR);
        dirClass.setReifiedClass(RubyDir.class);
        dirClass.includeModule(runtime.getEnumerable());
        dirClass.defineAnnotatedMethods(RubyDir.class);
        return dirClass;
    }

    private final void checkDir() {
        this.checkDirIgnoreClosed();
        if (!this.isOpen) {
            throw this.getRuntime().newIOError("closed directory");
        }
    }

    private final void checkDirIgnoreClosed() {
        this.testFrozen("Dir");
        if (this.snapshot == null || this.dir.exists() && this.dir.lastModified() > this.lastModified) {
            this.lastModified = this.dir.lastModified();
            List<String> contents = RubyDir.getContents(this.dir);
            this.snapshot = contents.toArray(new String[contents.size()]);
        }
    }

    public IRubyObject initialize(ThreadContext context, IRubyObject arg2) {
        return this.initialize19(context, arg2);
    }

    @JRubyMethod(name={"initialize"})
    public IRubyObject initialize19(ThreadContext context, IRubyObject arg2) {
        RubyString newPath;
        Ruby runtime = context.runtime;
        this.path = newPath = StringSupport.checkEmbeddedNulls(runtime, RubyFile.get_path(context, arg2));
        this.pos = 0;
        String adjustedPath = RubyFile.adjustRootPathOnWindows(runtime, newPath.toString(), null);
        RubyDir.checkDirIsTwoSlashesOnWindows(this.getRuntime(), adjustedPath);
        this.dir = JRubyFile.createResource(context, adjustedPath);
        this.snapshot = RubyDir.getEntries(context, this.dir, adjustedPath);
        return this;
    }

    private static ArrayList<ByteList> dirGlobs(ThreadContext context, String cwd, IRubyObject[] args2, int flags2) {
        ArrayList<ByteList> dirs = new ArrayList<ByteList>();
        for (int i2 = 0; i2 < args2.length; ++i2) {
            dirs.addAll(Dir.push_glob(context.runtime, cwd, RubyDir.globArgumentAsByteList(context, args2[i2]), flags2));
        }
        return dirs;
    }

    private static RubyArray asRubyStringList(Ruby runtime, List<ByteList> dirs) {
        int size2 = dirs.size();
        if (size2 == 0) {
            return RubyArray.newEmptyArray(runtime);
        }
        Encoding enc = runtime.getDefaultExternalEncoding();
        if (enc == null) {
            enc = UTF8;
        }
        IRubyObject[] dirStrings = new IRubyObject[size2];
        for (int i2 = 0; i2 < size2; ++i2) {
            dirStrings[i2] = RubyString.newString(runtime, dirs.get(i2), enc);
        }
        return RubyArray.newArrayNoCopy(runtime, dirStrings);
    }

    private static String getCWD(Ruby runtime) {
        if (runtime.getCurrentDirectory().startsWith("uri:")) {
            return runtime.getCurrentDirectory();
        }
        try {
            return new JRubyFile(runtime.getCurrentDirectory()).getCanonicalPath();
        }
        catch (Exception e) {
            return runtime.getCurrentDirectory();
        }
    }

    @JRubyMethod(name={"[]"}, rest=true, meta=true)
    public static IRubyObject aref(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        Ruby runtime = context.runtime;
        List<ByteList> dirs = args2.length == 1 ? Dir.push_glob(runtime, RubyDir.getCWD(runtime), RubyDir.globArgumentAsByteList(context, args2[0]), 0) : RubyDir.dirGlobs(context, RubyDir.getCWD(runtime), args2, 0);
        return RubyDir.asRubyStringList(runtime, dirs);
    }

    private static ByteList globArgumentAsByteList(ThreadContext context, IRubyObject arg2) {
        return RubyFile.get_path(context, arg2).getByteList();
    }

    @JRubyMethod(required=1, optional=1, meta=true)
    public static IRubyObject glob(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        Ruby runtime = context.runtime;
        int flags2 = args2.length == 2 ? RubyNumeric.num2int(args2[1]) : 0;
        IRubyObject tmp = args2[0].checkArrayType();
        List<ByteList> dirs = tmp.isNil() ? Dir.push_glob(runtime, runtime.getCurrentDirectory(), RubyDir.globArgumentAsByteList(context, args2[0]), flags2) : RubyDir.dirGlobs(context, RubyDir.getCWD(runtime), ((RubyArray)tmp).toJavaArray(), flags2);
        if (block.isGiven()) {
            for (int i2 = 0; i2 < dirs.size(); ++i2) {
                Encoding enc = runtime.getDefaultExternalEncoding();
                if (enc == null) {
                    enc = UTF8;
                }
                block.yield(context, RubyString.newString(runtime, dirs.get(i2), enc));
            }
            return runtime.getNil();
        }
        return RubyDir.asRubyStringList(runtime, dirs);
    }

    @JRubyMethod(name={"entries"})
    public RubyArray entries() {
        return this.getRuntime().newArrayNoCopy(JavaUtil.convertJavaArrayToRuby(this.getRuntime(), this.snapshot));
    }

    public static RubyArray entries(IRubyObject recv2, IRubyObject path2) {
        return RubyDir.entries19(recv2.getRuntime().getCurrentContext(), recv2, path2);
    }

    @JRubyMethod(name={"entries"}, meta=true)
    public static RubyArray entries19(ThreadContext context, IRubyObject recv2, IRubyObject arg2) {
        RubyString path2 = StringSupport.checkEmbeddedNulls(context.runtime, RubyFile.get_path(context, arg2));
        return RubyDir.entriesCommon(context, path2.asJavaString());
    }

    @JRubyMethod(name={"entries"}, meta=true)
    public static RubyArray entries19(ThreadContext context, IRubyObject recv2, IRubyObject arg2, IRubyObject opts) {
        RubyString path2 = StringSupport.checkEmbeddedNulls(context.runtime, RubyFile.get_path(context, arg2));
        return RubyDir.entriesCommon(context, path2.asJavaString());
    }

    private static RubyArray entriesCommon(ThreadContext context, String path2) {
        Ruby runtime = context.runtime;
        String adjustedPath = RubyFile.adjustRootPathOnWindows(runtime, path2, null);
        RubyDir.checkDirIsTwoSlashesOnWindows(runtime, adjustedPath);
        FileResource directory = JRubyFile.createResource(context, path2);
        Object[] files = RubyDir.getEntries(context, directory, adjustedPath);
        return runtime.newArrayNoCopy(JavaUtil.convertJavaArrayToRuby(runtime, files));
    }

    private static String[] getEntries(ThreadContext context, FileResource dir, String path2) {
        if (!dir.isDirectory()) {
            throw context.runtime.newErrnoENOENTError("No such directory: " + path2);
        }
        if (!dir.canRead()) {
            throw context.runtime.newErrnoEACCESError(path2);
        }
        String[] list2 = dir.list();
        return list2 == null ? NO_FILES : list2;
    }

    private static void checkDirIsTwoSlashesOnWindows(Ruby runtime, String path2) {
        if (Platform.IS_WINDOWS && ("//".equals(path2) || "\\\\".equals(path2))) {
            throw runtime.newErrnoEINVALError("Invalid argument - " + path2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(optional=1, meta=true)
    public static IRubyObject chdir(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        String realPath;
        Ruby runtime = context.runtime;
        RubyString path2 = args2.length == 1 ? StringSupport.checkEmbeddedNulls(runtime, RubyFile.get_path(context, args2[0])) : RubyDir.getHomeDirectoryPath(context);
        String adjustedPath = RubyFile.adjustRootPathOnWindows(runtime, path2.asJavaString(), null);
        RubyDir.checkDirIsTwoSlashesOnWindows(runtime, adjustedPath);
        String oldCwd = runtime.getCurrentDirectory();
        if (PROTOCOL_PATTERN.matcher(adjustedPath).matches()) {
            realPath = adjustedPath;
        } else {
            FileResource dir = RubyDir.getDir(runtime, adjustedPath, true);
            realPath = dir.canonicalPath();
        }
        IRubyObject result2 = null;
        if (block.isGiven()) {
            runtime.setCurrentDirectory(realPath);
            try {
                result2 = block.yield(context, path2);
            }
            finally {
                RubyDir.getDir(runtime, oldCwd, true);
                runtime.setCurrentDirectory(oldCwd);
            }
        } else {
            runtime.setCurrentDirectory(realPath);
            result2 = runtime.newFixnum(0);
        }
        return result2;
    }

    @JRubyMethod(name={"chroot"}, required=1, meta=true)
    public static IRubyObject chroot(IRubyObject recv2, IRubyObject path2) {
        throw recv2.getRuntime().newNotImplementedError("chroot not implemented: chroot is non-portable and is not supported.");
    }

    public static IRubyObject rmdir(IRubyObject recv2, IRubyObject path2) {
        return RubyDir.rmdir19(recv2.getRuntime().getCurrentContext(), recv2, path2);
    }

    @JRubyMethod(name={"rmdir", "unlink", "delete"}, required=1, meta=true)
    public static IRubyObject rmdir19(ThreadContext context, IRubyObject recv2, IRubyObject path2) {
        Ruby runtime = context.runtime;
        RubyString cleanPath = StringSupport.checkEmbeddedNulls(runtime, RubyFile.get_path(context, path2));
        return RubyDir.rmdirCommon(runtime, cleanPath.asJavaString());
    }

    private static IRubyObject rmdirCommon(Ruby runtime, String path2) {
        JRubyFile directory = RubyDir.getDirForRmdir(runtime, path2);
        if (runtime.getPosix().rmdir(directory.toString()) < 0) {
            throw runtime.newErrnoENOTEMPTYError(path2);
        }
        return runtime.newFixnum(0);
    }

    public static IRubyObject foreach(ThreadContext context, IRubyObject recv2, IRubyObject _path, Block block) {
        return RubyDir.foreach19(context, recv2, _path, block);
    }

    @JRubyMethod(name={"foreach"}, meta=true)
    public static IRubyObject foreach19(ThreadContext context, IRubyObject recv2, IRubyObject arg2, Block block) {
        RubyString pathString = RubyFile.get_path(context, arg2);
        return RubyDir.foreachCommon(context, recv2, context.runtime, pathString, null, block);
    }

    @JRubyMethod(name={"foreach"}, meta=true)
    public static IRubyObject foreach19(ThreadContext context, IRubyObject recv2, IRubyObject path2, IRubyObject enc, Block block) {
        RubyString pathString = RubyFile.get_path(context, path2);
        if (!(enc instanceof RubyEncoding)) {
            throw context.runtime.newTypeError(enc, context.runtime.getEncoding());
        }
        RubyEncoding encoding2 = (RubyEncoding)enc;
        return RubyDir.foreachCommon(context, recv2, context.runtime, pathString, encoding2, block);
    }

    private static IRubyObject foreachCommon(ThreadContext context, IRubyObject recv2, Ruby runtime, RubyString _path, RubyEncoding encoding2, Block block) {
        if (block.isGiven()) {
            RubyClass dirClass = runtime.getDir();
            RubyDir dir = (RubyDir)dirClass.newInstance(context, new IRubyObject[]{_path}, block);
            dir.each(context, block);
            return runtime.getNil();
        }
        if (encoding2 == null) {
            return RubyEnumerator.enumeratorize(runtime, recv2, "foreach", _path);
        }
        return RubyEnumerator.enumeratorize(runtime, recv2, "foreach", new IRubyObject[]{_path, encoding2});
    }

    @JRubyMethod(name={"getwd", "pwd"}, meta=true)
    public static RubyString getwd(IRubyObject recv2) {
        Ruby ruby2 = recv2.getRuntime();
        RubyString pwd = RubyString.newUnicodeString(ruby2, RubyDir.getCWD(ruby2));
        pwd.setTaint(true);
        return pwd;
    }

    @JRubyMethod(name={"home"}, optional=1, meta=true)
    public static IRubyObject home(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        if (args2.length > 0 && !args2[0].isNil()) {
            return RubyDir.getHomeDirectoryPath(context, args2[0].toString());
        }
        return RubyDir.getHomeDirectoryPath(context);
    }

    public static IRubyObject mkdir(IRubyObject recv2, IRubyObject[] args2) {
        return RubyDir.mkdir19(recv2.getRuntime().getCurrentContext(), recv2, args2);
    }

    @JRubyMethod(name={"mkdir"}, required=1, optional=1, meta=true)
    public static IRubyObject mkdir19(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        Ruby runtime = context.runtime;
        RubyString path2 = StringSupport.checkEmbeddedNulls(runtime, RubyFile.get_path(context, args2[0]));
        return RubyDir.mkdirCommon(runtime, path2.asJavaString(), args2);
    }

    private static IRubyObject mkdirCommon(Ruby runtime, String path2, IRubyObject[] args2) {
        int mode2;
        if (path2.startsWith("uri:")) {
            throw runtime.newErrnoEACCESError(path2);
        }
        File newDir = RubyDir.getDir(runtime, path2, false).hackyGetJRubyFile();
        String name2 = path2.replace('\\', '/');
        boolean startsWithDriveLetterOnWindows = RubyFile.startsWithDriveLetterOnWindows(name2);
        if (startsWithDriveLetterOnWindows) {
            if (path2.length() == 2) {
                return RubyFixnum.zero(runtime);
            }
            if (path2.length() == 3 && (path2.charAt(0) == '/' || path2.charAt(2) == '/')) {
                return RubyFixnum.zero(runtime);
            }
            if (path2.length() == 4 && path2.charAt(0) == '/' && path2.charAt(3) == '/') {
                return RubyFixnum.zero(runtime);
            }
        }
        if (File.separatorChar == '\\') {
            newDir = new File(newDir.getPath());
        }
        int n = mode2 = args2.length == 2 ? (int)args2[1].convertToInteger().getLongValue() : 511;
        if (runtime.getPosix().mkdir(newDir.getAbsolutePath(), mode2) < 0) {
            throw runtime.newSystemCallError("mkdir failed");
        }
        return RubyFixnum.zero(runtime);
    }

    public static IRubyObject open(ThreadContext context, IRubyObject recv2, IRubyObject path2, Block block) {
        return RubyDir.open19(context, recv2, path2, block);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"open"}, meta=true)
    public static IRubyObject open19(ThreadContext context, IRubyObject recv2, IRubyObject path2, Block block) {
        RubyDir directory = (RubyDir)context.runtime.getDir().newInstance(context, new IRubyObject[]{RubyFile.get_path(context, path2)}, Block.NULL_BLOCK);
        if (!block.isGiven()) {
            return directory;
        }
        try {
            IRubyObject iRubyObject = block.yield(context, directory);
            return iRubyObject;
        }
        finally {
            directory.close();
        }
    }

    @JRubyMethod(name={"close"})
    public IRubyObject close() {
        this.checkDirIgnoreClosed();
        this.isOpen = false;
        return this.getRuntime().getNil();
    }

    public IRubyObject each(ThreadContext context, Encoding enc, Block block) {
        this.checkDir();
        String[] contents = this.snapshot;
        this.pos = 0;
        while (this.pos < contents.length) {
            block.yield(context, RubyString.newString(context.runtime, contents[this.pos], enc));
            ++this.pos;
        }
        return this;
    }

    public IRubyObject each(ThreadContext context, Block block) {
        return this.each(context, context.runtime.getDefaultInternalEncoding(), block);
    }

    @JRubyMethod(name={"each"})
    public IRubyObject each19(ThreadContext context, Block block) {
        return block.isGiven() ? this.each(context, block) : RubyEnumerator.enumeratorize(context.runtime, this, "each");
    }

    @JRubyMethod(name={"each"})
    public IRubyObject each19(ThreadContext context, IRubyObject encoding2, Block block) {
        if (!(encoding2 instanceof RubyEncoding)) {
            throw context.runtime.newTypeError(encoding2, context.runtime.getEncoding());
        }
        return block.isGiven() ? this.each(context, ((RubyEncoding)encoding2).getEncoding(), block) : RubyEnumerator.enumeratorize(context.runtime, (IRubyObject)this, "each", encoding2);
    }

    @Override
    @JRubyMethod
    public IRubyObject inspect() {
        Ruby runtime = this.getRuntime();
        StringBuilder part = new StringBuilder();
        String cname = this.getMetaClass().getRealClass().getName();
        part.append("#<").append(cname).append(':');
        if (this.path != null) {
            part.append(this.path.asJavaString());
        }
        part.append('>');
        return runtime.newString(part.toString());
    }

    @JRubyMethod(name={"tell", "pos"})
    public RubyInteger tell() {
        this.checkDir();
        return this.getRuntime().newFixnum(this.pos);
    }

    @JRubyMethod(name={"seek"}, required=1)
    public IRubyObject seek(IRubyObject newPos) {
        this.checkDir();
        this.set_pos(newPos);
        return this;
    }

    @JRubyMethod(name={"pos="}, required=1)
    public IRubyObject set_pos(IRubyObject newPos) {
        int pos2 = RubyNumeric.fix2int(newPos);
        if (pos2 >= 0) {
            this.pos = pos2;
        }
        return newPos;
    }

    @JRubyMethod(name={"path", "to_path"})
    public IRubyObject path(ThreadContext context) {
        return this.path == null ? context.runtime.getNil() : this.path.strDup(context.runtime);
    }

    @JRubyMethod
    public IRubyObject to_path(ThreadContext context) {
        return this.path(context);
    }

    @JRubyMethod(name={"read"})
    public IRubyObject read() {
        this.checkDir();
        if (this.pos >= this.snapshot.length) {
            return this.getRuntime().getNil();
        }
        RubyString result2 = this.getRuntime().newString(this.snapshot[this.pos]);
        ++this.pos;
        return result2;
    }

    @JRubyMethod(name={"rewind"})
    public IRubyObject rewind() {
        this.checkDir();
        this.pos = 0;
        return this;
    }

    @JRubyMethod(name={"exist?"}, meta=true)
    public static IRubyObject exist(ThreadContext context, IRubyObject recv2, IRubyObject arg2) {
        Ruby runtime = context.runtime;
        IRubyObject exception2 = runtime.getGlobalVariables().get("$!");
        RubyString path2 = StringSupport.checkEmbeddedNulls(runtime, RubyFile.get_path(context, arg2));
        try {
            return runtime.newFileStat(path2.asJavaString(), false).directory_p();
        }
        catch (Exception e) {
            runtime.getGlobalVariables().set("$!", exception2);
            return runtime.newBoolean(false);
        }
    }

    @JRubyMethod(name={"exists?"}, meta=true)
    public static IRubyObject exists_p(ThreadContext context, IRubyObject recv2, IRubyObject arg2) {
        if (context.runtime.warningsEnabled()) {
            context.runtime.getWarnings().warn("Dir.exists? is a deprecated name, use Dir.exist? instead");
        }
        return RubyDir.exist(context, recv2, arg2);
    }

    @JRubyMethod(name={"fileno"}, notImplemented=true)
    public IRubyObject fileno(ThreadContext context) {
        throw context.runtime.newNotImplementedError("Dir#fileno");
    }

    protected static FileResource getDir(Ruby runtime, String path2, boolean mustExist) {
        String dir = RubyDir.dirFromPath(path2, runtime);
        FileResource result2 = JRubyFile.createResource(runtime, dir);
        if (mustExist && !result2.exists()) {
            throw runtime.newErrnoENOENTError(dir);
        }
        boolean isDirectory = result2.isDirectory();
        if (mustExist && !isDirectory) {
            throw runtime.newErrnoENOTDIRError(path2);
        }
        if (!mustExist && isDirectory) {
            throw runtime.newErrnoEEXISTError(dir);
        }
        return result2;
    }

    protected static JRubyFile getDirForRmdir(Ruby runtime, String path2) {
        String dir = RubyDir.dirFromPath(path2, runtime);
        JRubyFile directory = JRubyFile.create(runtime.getCurrentDirectory(), dir);
        File parentFile = directory.getParentFile();
        if (parentFile.exists() && !parentFile.canWrite()) {
            throw runtime.newErrnoEACCESError(path2);
        }
        FileStat stat2 = runtime.getPosix().stat(directory.toString());
        if (!stat2.isDirectory()) {
            throw runtime.newErrnoENOTDIRError(path2);
        }
        return directory;
    }

    private static String dirFromPath(String path2, Ruby runtime) throws RaiseException {
        String dir = path2;
        String[] pathParts = RubyFile.splitURI(path2);
        if (pathParts != null) {
            if (pathParts[0].startsWith("file:") && pathParts[1].length() > 0 && pathParts[1].indexOf(".jar!/") == -1) {
                dir = pathParts[1];
            } else {
                throw runtime.newErrnoENOTDIRError(dir);
            }
        }
        return dir;
    }

    protected static List<String> getContents(FileResource directory) {
        List<String> result2;
        String[] contents = directory.list();
        if (contents != null) {
            result2 = new ArrayList<String>(contents.length);
            Collections.addAll(result2, contents);
        } else {
            result2 = Collections.emptyList();
        }
        return result2;
    }

    protected static List<RubyString> getContents(FileResource directory, Ruby runtime) {
        List<RubyString> result2;
        String[] contents = directory.list();
        if (contents != null) {
            result2 = new ArrayList<RubyString>(contents.length);
            for (int i2 = 0; i2 < contents.length; ++i2) {
                result2.add(runtime.newString(contents[i2]));
            }
        } else {
            result2 = Collections.emptyList();
        }
        return result2;
    }

    public static IRubyObject getHomeDirectoryPath(ThreadContext context, String user) {
        Ruby runtime = context.runtime;
        try {
            return runtime.newString(runtime.getPosix().getpwnam(user).getHome());
        }
        catch (Exception e) {
            String passwd2;
            try {
                FileInputStream stream = new FileInputStream("/etc/passwd");
                int totalBytes = stream.available();
                byte[] bytes2 = new byte[totalBytes];
                stream.read(bytes2);
                stream.close();
                passwd2 = new String(bytes2);
            }
            catch (IOException ioe) {
                return runtime.getNil();
            }
            List<String> rows = StringSupport.split(passwd2, '\n');
            for (int i2 = 0; i2 < rows.size(); ++i2) {
                List<String> fields2 = StringSupport.split(rows.get(i2), ':');
                if (!fields2.get(0).equals(user)) continue;
                return runtime.newString(fields2.get(5));
            }
            throw runtime.newArgumentError("user " + user + " doesn't exist");
        }
    }

    public static RubyString getHomeDirectoryPath(ThreadContext context) {
        RubyString homeKey = RubyString.newStringShared(context.runtime, HOME);
        return RubyDir.getHomeDirectoryPath(context, context.runtime.getENV().op_aref(context, homeKey));
    }

    static RubyString getHomeDirectoryPath(ThreadContext context, IRubyObject home2) {
        Ruby runtime = context.runtime;
        if (home2 == null || home2 == context.nil) {
            IRubyObject ENV_JAVA = runtime.getObject().getConstant("ENV_JAVA");
            home2 = ENV_JAVA.callMethod(context, "[]", runtime.newString("user.home"));
        }
        if (home2 == null || home2 == context.nil) {
            RubyHash ENV = (RubyHash)runtime.getObject().getConstant("ENV");
            home2 = ENV.op_aref(context, runtime.newString("LOGDIR"));
        }
        if (home2 == null || home2 == context.nil) {
            throw runtime.newArgumentError("user.home/LOGDIR not set");
        }
        return (RubyString)home2;
    }
}

