/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.operands;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.OperandType;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.persistence.IRReaderDecoder;
import org.jruby.ir.persistence.IRWriterEncoder;
import org.jruby.ir.transformations.inlining.CloneInfo;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class Array
extends Operand
implements Iterable<Operand> {
    private final Operand[] elts;

    public Array() {
        this(EMPTY_ARRAY);
    }

    public Array(Operand[] elts) {
        this.elts = elts == null ? EMPTY_ARRAY : elts;
    }

    @Override
    public OperandType getOperandType() {
        return OperandType.ARRAY;
    }

    public boolean isBlank() {
        return this.elts.length == 0;
    }

    public int size() {
        return this.elts.length;
    }

    public Operand get(int i2) {
        return this.elts[i2];
    }

    public String toString() {
        return "Array:" + (this.isBlank() ? "[]" : Arrays.toString(this.elts));
    }

    @Override
    public boolean hasKnownValue() {
        for (Operand o : this.elts) {
            if (o.hasKnownValue()) continue;
            return false;
        }
        return true;
    }

    @Override
    public Operand getSimplifiedOperand(Map<Operand, Operand> valueMap, boolean force) {
        Operand[] newElts = new Operand[this.elts.length];
        for (int i2 = 0; i2 < this.elts.length; ++i2) {
            newElts[i2] = this.elts[i2].getSimplifiedOperand(valueMap, force);
        }
        return new Array(newElts);
    }

    public Operand toArray() {
        return this;
    }

    @Override
    public void addUsedVariables(List<Variable> l) {
        for (Operand o : this.elts) {
            o.addUsedVariables(l);
        }
    }

    @Override
    public Operand cloneForInlining(CloneInfo ii) {
        if (this.hasKnownValue()) {
            return this;
        }
        Operand[] newElts = new Operand[this.elts.length];
        for (int i2 = 0; i2 < this.elts.length; ++i2) {
            newElts[i2] = this.elts[i2].cloneForInlining(ii);
        }
        return new Array(newElts);
    }

    @Override
    public void encode(IRWriterEncoder e) {
        super.encode(e);
        e.encode(this.getElts());
    }

    public static Array decode(IRReaderDecoder d) {
        return new Array(d.decodeOperandArray());
    }

    public IRubyObject[] retrieveArrayElts(ThreadContext context, IRubyObject self2, StaticScope currScope, DynamicScope currDynScope, Object[] temp) {
        IRubyObject[] elements = new IRubyObject[this.elts.length];
        for (int i2 = 0; i2 < elements.length; ++i2) {
            elements[i2] = (IRubyObject)this.elts[i2].retrieve(context, self2, currScope, currDynScope, temp);
        }
        return elements;
    }

    @Override
    public Object retrieve(ThreadContext context, IRubyObject self2, StaticScope currScope, DynamicScope currDynScope, Object[] temp) {
        return context.runtime.newArray(this.retrieveArrayElts(context, self2, currScope, currDynScope, temp));
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.Array(this);
    }

    public Operand[] getElts() {
        return this.elts;
    }

    @Override
    public Iterator<Operand> iterator() {
        return Arrays.asList(this.elts).iterator();
    }
}

