/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.instrumentation;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.instrumentation.InstrumentableFactory;
import com.oracle.truffle.api.instrumentation.InstrumentationHandler;
import com.oracle.truffle.api.instrumentation.ProbeNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import java.io.IOException;

public final class EventContext {
    private final ProbeNode probeNode;
    private final SourceSection sourceSection;

    EventContext(ProbeNode probeNode, SourceSection sourceSection) {
        this.sourceSection = sourceSection;
        this.probeNode = probeNode;
    }

    public SourceSection getInstrumentedSourceSection() {
        return this.sourceSection;
    }

    public Node getInstrumentedNode() {
        InstrumentableFactory.WrapperNode wrapper = this.probeNode.findWrapper();
        return wrapper != null ? wrapper.getDelegateNode() : null;
    }

    public CallTarget parseInContext(Source source, String ... argumentNames) throws IOException {
        return InstrumentationHandler.ACCESSOR.parse(null, source, this.getInstrumentedNode(), argumentNames);
    }

    public String toString() {
        return "EventContext[source=" + this.getInstrumentedSourceSection() + "]";
    }
}

