/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.array;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.Layouts;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.array.ArrayEnsureCapacityNodeGen;
import org.jruby.truffle.core.array.ArrayGuards;
import org.jruby.truffle.core.array.ArrayMirror;
import org.jruby.truffle.core.array.ArrayStrategy;
import org.jruby.truffle.core.array.ArrayUtils;
import org.jruby.truffle.language.RubyNode;

@ImportStatic(value={ArrayGuards.class})
@NodeChildren(value={@NodeChild(value="array", type=RubyNode.class), @NodeChild(value="requiredCapacity", type=RubyNode.class)})
public abstract class ArrayEnsureCapacityNode
extends RubyNode {
    public ArrayEnsureCapacityNode(RubyContext context, SourceSection sourceSection) {
        super(context, sourceSection);
    }

    public static ArrayEnsureCapacityNode create(RubyContext context) {
        return ArrayEnsureCapacityNodeGen.create(context, null, null, null);
    }

    public abstract Object executeEnsureCapacity(DynamicObject var1, int var2);

    @Specialization(guards={"strategy.matches(array)"}, limit="ARRAY_STRATEGIES")
    public boolean ensureCapacity(DynamicObject array, int requiredCapacity, @Cached(value="of(array)") ArrayStrategy strategy, @Cached(value="createCountingProfile()") ConditionProfile extendProfile) {
        ArrayMirror mirror = strategy.newMirror(array);
        if (extendProfile.profile(mirror.getLength() < requiredCapacity)) {
            int capacity = ArrayUtils.capacity(this.getContext(), mirror.getLength(), requiredCapacity);
            Layouts.ARRAY.setStore(array, mirror.copyArrayAndMirror(capacity).getArray());
            return true;
        }
        return false;
    }
}

