/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.format.convert;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import java.math.BigInteger;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.format.FormatNode;
import org.jruby.truffle.core.format.MissingValue;
import org.jruby.truffle.core.numeric.FixnumOrBignumNode;

@NodeChildren(value={@NodeChild(value="value", type=FormatNode.class)})
public abstract class ReinterpretAsUnsignedNode
extends FormatNode {
    @Node.Child
    private FixnumOrBignumNode fixnumOrBignumNode;
    private static final long UNSIGNED_LONG_MASK = Long.MAX_VALUE;

    public ReinterpretAsUnsignedNode(RubyContext context) {
        super(context);
    }

    @Specialization
    public MissingValue asUnsigned(MissingValue missingValue) {
        return missingValue;
    }

    @Specialization(guards={"isNil(nil)"})
    public DynamicObject asUnsigned(DynamicObject nil) {
        return nil;
    }

    @Specialization
    public int asUnsigned(short value) {
        return value & 0xFFFF;
    }

    @Specialization
    public long asUnsigned(int value) {
        return (long)value & 0xFFFFFFFFL;
    }

    @Specialization
    public Object asUnsigned(long value) {
        if (this.fixnumOrBignumNode == null) {
            CompilerDirectives.transferToInterpreter();
            this.fixnumOrBignumNode = this.insert(FixnumOrBignumNode.create(this.getContext(), this.getSourceSection()));
        }
        return this.fixnumOrBignumNode.fixnumOrBignum(this.asUnsignedBigInteger(value));
    }

    @CompilerDirectives.TruffleBoundary
    private BigInteger asUnsignedBigInteger(long value) {
        BigInteger bigIntegerValue = BigInteger.valueOf(value & Long.MAX_VALUE);
        if (value < 0L) {
            bigIntegerValue = bigIntegerValue.setBit(63);
        }
        return bigIntegerValue;
    }
}

