/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.interop;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.object.DynamicObject;
import org.jruby.truffle.Layouts;
import org.jruby.truffle.core.rope.Rope;
import org.jruby.truffle.core.string.StringCachingGuards;
import org.jruby.truffle.interop.ToJavaStringNodeGen;
import org.jruby.truffle.language.RubyNode;

@ImportStatic(value={StringCachingGuards.class})
@NodeChild(value="value", type=RubyNode.class)
public abstract class ToJavaStringNode
extends RubyNode {
    public static ToJavaStringNode create() {
        return ToJavaStringNodeGen.create(null);
    }

    public abstract String executeToJavaString(Object var1);

    @Specialization(guards={"isRubyString(value)", "ropesEqual(value, cachedRope)"}, limit="getLimit()")
    String stringCached(DynamicObject value, @Cached(value="privatizeRope(value)") Rope cachedRope, @Cached(value="value.toString()") String convertedString) {
        return convertedString;
    }

    @CompilerDirectives.TruffleBoundary
    @Specialization(guards={"isRubyString(value)"}, contains={"stringCached"})
    public String stringUncached(DynamicObject value) {
        return value.toString();
    }

    @Specialization(guards={"symbol == cachedSymbol", "isRubySymbol(cachedSymbol)"}, limit="getLimit()")
    public String symbolCached(DynamicObject symbol, @Cached(value="symbol") DynamicObject cachedSymbol, @Cached(value="symbolToString(symbol)") String convertedString) {
        return convertedString;
    }

    @Specialization(guards={"isRubySymbol(symbol)"}, contains={"symbolCached"})
    public String symbolUncached(DynamicObject symbol) {
        return this.symbolToString(symbol);
    }

    @Specialization(guards={"string == cachedString"}, limit="getLimit()")
    public String javaStringCached(String string, @Cached(value="string") String cachedString) {
        return cachedString;
    }

    @Specialization(contains={"javaStringCached"})
    public String javaStringUncached(String value) {
        return value;
    }

    protected String symbolToString(DynamicObject symbol) {
        return Layouts.SYMBOL.getString(symbol);
    }

    protected int getLimit() {
        return this.getContext().getOptions().INTEROP_CONVERT_CACHE;
    }
}

