/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.nodes.InvalidAssumptionException;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Phaser;
import java.util.concurrent.locks.ReentrantLock;
import org.jruby.RubyThread;
import org.jruby.truffle.Layouts;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.InterruptMode;
import org.jruby.truffle.language.SafepointAction;

public class SafepointManager {
    private final RubyContext context;
    private final Set<Thread> runningThreads = Collections.newSetFromMap(new ConcurrentHashMap());
    private final ReentrantLock lock = new ReentrantLock();
    private final Phaser phaser = new Phaser();
    @CompilerDirectives.CompilationFinal
    private Assumption assumption = Truffle.getRuntime().createAssumption("SafepointManager");
    private volatile SafepointAction action;
    private volatile boolean deferred;

    public SafepointManager(RubyContext context) {
        this.context = context;
    }

    public void enterThread() {
        CompilerAsserts.neverPartOfCompilation();
        this.lock.lock();
        try {
            this.phaser.register();
            this.runningThreads.add(Thread.currentThread());
        }
        finally {
            this.lock.unlock();
        }
    }

    public void leaveThread() {
        CompilerAsserts.neverPartOfCompilation();
        this.phaser.arriveAndDeregister();
        this.runningThreads.remove(Thread.currentThread());
    }

    public void poll(Node currentNode) {
        this.poll(currentNode, false);
    }

    public void pollFromBlockingCall(Node currentNode) {
        this.poll(currentNode, true);
    }

    private void poll(Node currentNode, boolean fromBlockingCall) {
        try {
            this.assumption.check();
        }
        catch (InvalidAssumptionException e) {
            this.assumptionInvalidated(currentNode, fromBlockingCall);
        }
    }

    @CompilerDirectives.TruffleBoundary
    private void assumptionInvalidated(Node currentNode, boolean fromBlockingCall) {
        boolean interruptible;
        DynamicObject thread = this.context.getThreadManager().getCurrentThread();
        InterruptMode interruptMode = Layouts.THREAD.getInterruptMode(thread);
        boolean bl = interruptible = interruptMode == InterruptMode.IMMEDIATE || fromBlockingCall && interruptMode == InterruptMode.ON_BLOCKING;
        if (!interruptible) {
            Thread.currentThread().interrupt();
            return;
        }
        SafepointAction deferredAction = this.step(currentNode, false);
        if (deferredAction != null) {
            deferredAction.run(thread, currentNode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    private SafepointAction step(Node currentNode, boolean isDrivingThread) {
        DynamicObject thread = this.context.getThreadManager().getCurrentThread();
        this.phaser.arriveAndAwaitAdvance();
        if (isDrivingThread) {
            this.assumption = Truffle.getRuntime().createAssumption(this.getClass().getCanonicalName());
        }
        this.phaser.arriveAndAwaitAdvance();
        SafepointAction deferredAction = this.deferred ? this.action : null;
        try {
            if (!this.deferred && thread != null && Layouts.THREAD.getStatus(thread) != RubyThread.Status.ABORTING) {
                this.action.run(thread, currentNode);
            }
        }
        finally {
            this.phaser.arriveAndAwaitAdvance();
        }
        return deferredAction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    public void pauseAllThreadsAndExecute(Node currentNode, boolean deferred, SafepointAction action) {
        if (this.lock.isHeldByCurrentThread()) {
            throw new IllegalStateException("Re-entered SafepointManager");
        }
        while (!this.lock.tryLock()) {
            this.poll(currentNode);
        }
        try {
            this.pauseAllThreadsAndExecute(currentNode, action, deferred);
        }
        finally {
            this.lock.unlock();
        }
        if (deferred) {
            action.run(this.context.getThreadManager().getCurrentThread(), currentNode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    public void pauseAllThreadsAndExecuteFromNonRubyThread(boolean deferred, SafepointAction action) {
        if (this.lock.isHeldByCurrentThread()) {
            throw new IllegalStateException("Re-entered SafepointManager");
        }
        assert (!this.runningThreads.contains(Thread.currentThread()));
        this.lock.lock();
        try {
            this.enterThread();
            try {
                this.pauseAllThreadsAndExecute(null, action, deferred);
            }
            finally {
                this.leaveThread();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @CompilerDirectives.TruffleBoundary
    public void pauseThreadAndExecute(final Thread thread, Node currentNode, final SafepointAction action) {
        if (Thread.currentThread() == thread) {
            DynamicObject rubyThread = this.context.getThreadManager().getCurrentThread();
            action.run(rubyThread, currentNode);
        } else {
            this.pauseAllThreadsAndExecute(currentNode, false, new SafepointAction(){

                @Override
                public void run(DynamicObject rubyThread, Node currentNode) {
                    if (Thread.currentThread() == thread) {
                        action.run(rubyThread, currentNode);
                    }
                }
            });
        }
    }

    @CompilerDirectives.TruffleBoundary
    public void pauseThreadAndExecuteLater(final Thread thread, Node currentNode, final SafepointAction action) {
        if (Thread.currentThread() == thread) {
            DynamicObject rubyThread = this.context.getThreadManager().getCurrentThread();
            action.run(rubyThread, currentNode);
        } else {
            this.pauseAllThreadsAndExecute(currentNode, true, new SafepointAction(){

                @Override
                public void run(DynamicObject rubyThread, Node currentNode) {
                    if (Thread.currentThread() == thread) {
                        action.run(rubyThread, currentNode);
                    }
                }
            });
        }
    }

    @CompilerDirectives.TruffleBoundary
    public void pauseThreadAndExecuteLaterFromNonRubyThread(final Thread thread, final SafepointAction action) {
        this.pauseAllThreadsAndExecuteFromNonRubyThread(true, new SafepointAction(){

            @Override
            public void run(DynamicObject rubyThread, Node currentNode) {
                if (Thread.currentThread() == thread) {
                    action.run(rubyThread, currentNode);
                }
            }
        });
    }

    private void pauseAllThreadsAndExecute(Node currentNode, SafepointAction action, boolean deferred) {
        this.action = action;
        this.deferred = deferred;
        this.assumption.invalidate();
        this.interruptOtherThreads();
        this.step(currentNode, true);
    }

    private void interruptOtherThreads() {
        Thread current = Thread.currentThread();
        for (Thread thread : this.runningThreads) {
            if (thread == current) continue;
            thread.interrupt();
        }
    }
}

