/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language.globals;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.object.DynamicObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jruby.truffle.language.globals.GlobalVariableStorage;

public class GlobalVariables {
    private final DynamicObject defaultValue;
    ConcurrentMap<String, GlobalVariableStorage> variables;

    public GlobalVariables(DynamicObject defaultValue) {
        this.defaultValue = defaultValue;
        this.variables = new ConcurrentHashMap<String, GlobalVariableStorage>();
    }

    public Object getOrDefault(String key, Object defaultValue) {
        Object v = this.get(key);
        return v != null ? v : defaultValue;
    }

    public Object get(String key) {
        return this.getStorage((String)key).value;
    }

    @CompilerDirectives.TruffleBoundary
    public GlobalVariableStorage getStorage(String key) {
        GlobalVariableStorage currentStorage = (GlobalVariableStorage)this.variables.get(key);
        if (currentStorage == null) {
            GlobalVariableStorage newStorage = new GlobalVariableStorage(this.defaultValue);
            GlobalVariableStorage racyNewStorage = this.variables.putIfAbsent(key, newStorage);
            return racyNewStorage == null ? newStorage : racyNewStorage;
        }
        return currentStorage;
    }

    public void put(String key, Object value) {
        this.getStorage((String)key).value = value;
    }

    public Collection<DynamicObject> dynamicObjectValues() {
        Collection storages = this.variables.values();
        ArrayList<DynamicObject> values = new ArrayList<DynamicObject>(storages.size());
        for (GlobalVariableStorage storage : storages) {
            Object value = storage.value;
            if (!(value instanceof DynamicObject)) continue;
            values.add((DynamicObject)value);
        }
        return values;
    }
}

