/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language.methods;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.array.ArrayUtils;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.arguments.RubyArguments;
import org.jruby.truffle.language.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.language.dispatch.DispatchHeadNodeFactory;

public class SymbolProcNode
extends RubyNode {
    private final String symbol;
    @Node.Child
    private CallDispatchHeadNode callNode;

    public SymbolProcNode(RubyContext context, SourceSection sourceSection, String symbol) {
        super(context, sourceSection);
        this.symbol = symbol;
    }

    @Override
    public Object execute(VirtualFrame frame) {
        Object receiver = RubyArguments.getArgument(frame, 0);
        DynamicObject block = RubyArguments.getBlock(frame);
        Object[] arguments = ArrayUtils.extractRange(RubyArguments.getArguments(frame), 1, RubyArguments.getArgumentsCount(frame));
        return this.getCallNode().call(frame, receiver, this.symbol, block, arguments);
    }

    private CallDispatchHeadNode getCallNode() {
        if (this.callNode == null) {
            CompilerDirectives.transferToInterpreter();
            this.callNode = this.insert(DispatchHeadNodeFactory.createMethodCall(this.getContext()));
        }
        return this.callNode;
    }
}

