/*
 * Decompiled with CFR 0.152.
 */
package org.encog.engine.network.activation;

import org.encog.engine.network.activation.ActivationFunction;
import org.encog.engine.network.activation.ActivationLinear;

public class ActivationBipolarSteepenedSigmoid
implements ActivationFunction {
    private static final long serialVersionUID = 1L;

    @Override
    public void activationFunction(double[] d, int start, int size) {
        for (int i = start; i < start + size; ++i) {
            d[i] = 2.0 / (1.0 + Math.exp(-4.9 * d[i])) - 1.0;
        }
    }

    @Override
    public double derivativeFunction(double b, double a) {
        return 1.0;
    }

    @Override
    public boolean hasDerivative() {
        return true;
    }

    @Override
    public double[] getParams() {
        return ActivationLinear.P;
    }

    @Override
    public void setParam(int index, double value) {
    }

    @Override
    public String[] getParamNames() {
        return ActivationLinear.N;
    }

    @Override
    public final ActivationFunction clone() {
        return new ActivationBipolarSteepenedSigmoid();
    }

    @Override
    public String getFactoryCode() {
        return null;
    }
}

