/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.da.comp.w2lcommon.helper;

import com.sun.star.beans.PropertyVetoException;
import com.sun.star.beans.UnknownPropertyException;
import com.sun.star.beans.XPropertySet;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.WrappedTargetException;

public class XPropertySetHelper {
    public static Object getPropertyValue(XPropertySet xProps, String sName) {
        try {
            return xProps.getPropertyValue(sName);
        }
        catch (UnknownPropertyException e) {
            return null;
        }
        catch (WrappedTargetException e) {
            return null;
        }
    }

    public static void setPropertyValue(XPropertySet xProps, String sName, Object value) {
        try {
            xProps.setPropertyValue(sName, value);
        }
        catch (UnknownPropertyException e) {
        }
        catch (PropertyVetoException e) {
        }
        catch (IllegalArgumentException e) {
        }
        catch (WrappedTargetException wrappedTargetException) {
            // empty catch block
        }
    }

    public static String getPropertyValueAsString(XPropertySet xProps, String sName) {
        Object value = XPropertySetHelper.getPropertyValue(xProps, sName);
        return value instanceof String ? (String)value : "";
    }

    public static int getPropertyValueAsInteger(XPropertySet xProps, String sName) {
        Object value = XPropertySetHelper.getPropertyValue(xProps, sName);
        return value instanceof Integer ? (Integer)value : 0;
    }

    public static void setPropertyValue(XPropertySet xProps, String sName, int nValue) {
        XPropertySetHelper.setPropertyValue(xProps, sName, new Integer(nValue));
    }

    public static short getPropertyValueAsShort(XPropertySet xProps, String sName) {
        Object value = XPropertySetHelper.getPropertyValue(xProps, sName);
        return value instanceof Short ? (Short)value : (short)0;
    }

    public static void setPropertyValue(XPropertySet xProps, String sName, short nValue) {
        XPropertySetHelper.setPropertyValue(xProps, sName, new Short(nValue));
    }

    public static boolean getPropertyValueAsBoolean(XPropertySet xProps, String sName) {
        Object value = XPropertySetHelper.getPropertyValue(xProps, sName);
        return value instanceof Boolean ? (Boolean)value : false;
    }

    public static void setPropertyValue(XPropertySet xProps, String sName, boolean bValue) {
        XPropertySetHelper.setPropertyValue(xProps, sName, new Boolean(bValue));
    }
}

