/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.control.basics;

public class Line1D {
    private final Double low;
    private final Double high;

    public Line1D(double low, double high) {
        this.low = low;
        this.high = high;
    }

    public double getLow() {
        return this.low;
    }

    public double getHigh() {
        return this.high;
    }

    public double getSpace() {
        return this.high - this.low;
    }

    public double getCenter() {
        return (this.high + this.low) / 2.0;
    }

    public boolean contains(double value) {
        return this.low <= value && value <= this.high;
    }

    public boolean isIntersecting(Line1D other) {
        boolean isIntersecting = this.contains(other.getLow()) || this.contains(other.getHigh()) || other.contains(this.getLow());
        return isIntersecting;
    }

    public Line1D intersect(Line1D other, boolean nanPriority) {
        Double maxLeft = this.low;
        Double minRight = this.high;
        if (nanPriority) {
            if (other.low.equals(Double.NaN) || other.low > this.low) {
                maxLeft = other.low;
            }
            if (other.high.equals(Double.NaN) || other.high < this.high) {
                minRight = other.high;
            }
        } else {
            if (this.low.equals(Double.NaN) || other.low > this.low) {
                maxLeft = other.low;
            }
            if (this.high.equals(Double.NaN) || other.high < this.high) {
                minRight = other.high;
            }
        }
        return new Line1D(maxLeft, minRight);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.high == null ? 0 : this.high.hashCode());
        result = 31 * result + (this.low == null ? 0 : this.low.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Line1D other = (Line1D)obj;
        if (this.high == null ? other.high != null : !this.high.equals(other.high)) {
            return false;
        }
        return !(this.low == null ? other.low != null : !this.low.equals(other.low));
    }

    public String toString() {
        return "Line1D [low=" + this.low + ", high=" + this.high + "]";
    }
}

