/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.history;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.core.scanner.Alert;
import org.parosproxy.paros.extension.AbstractDialog;
import org.parosproxy.paros.extension.history.HistoryFilter;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.network.HttpRequestHeader;
import org.parosproxy.paros.network.HttpStatusCode;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.view.LayoutHelper;

public class HistoryFilterPlusDialog
extends AbstractDialog {
    private static final long serialVersionUID = 1L;
    private static final String MSG = Constant.messages.getString("history.filter.label.desc");
    private JPanel jPanel = null;
    private JButton btnApply = null;
    private JButton btnCancel = null;
    private JPanel jPanel1 = null;
    private int exitResult = 2;
    private HistoryFilter filter = new HistoryFilter();
    private JButton btnReset = null;
    private JPanel jPanel2 = null;
    private JList<String> methodList = null;
    private JList<Integer> codeList = null;
    private JList<String> riskList = null;
    private JList<String> confidenceList = null;
    private JList<String> tagList = null;
    private JTextArea regexInc = null;
    private JTextArea regexExc = null;
    private DefaultListModel<String> tagModel = null;
    private JScrollPane methodScroller = null;
    private JScrollPane codeScroller = null;
    private JScrollPane tagScroller = null;
    private JScrollPane riskScroller = null;
    private JScrollPane confidenceScroller = null;
    private JComboBox<String> notesComboBox = null;
    private JScrollPane urlRegxIncScroller = null;
    private JScrollPane urlRegxExcScroller = null;

    public HistoryFilterPlusDialog() throws HeadlessException {
        this.initialize();
    }

    public HistoryFilterPlusDialog(Frame frame, boolean bl) throws HeadlessException {
        super(frame, bl);
        this.initialize();
    }

    private void initialize() {
        this.setContentPane(this.getJPanel());
        this.setVisible(false);
        this.setResizable(false);
        this.setTitle(Constant.messages.getString("history.filter.title"));
        if (Model.getSingleton().getOptionsParam().getViewParam().getWmUiHandlingOption() == 0) {
            this.setSize(600, 300);
        }
        this.centreDialog();
        this.getRootPane().setDefaultButton(this.btnApply);
        this.pack();
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            JLabel jLabel = new JLabel();
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            this.jPanel = new JPanel();
            this.jPanel.setLayout(new GridBagLayout());
            gridBagConstraints4.gridx = 0;
            gridBagConstraints4.gridy = 1;
            gridBagConstraints4.insets = new Insets(5, 10, 5, 10);
            gridBagConstraints4.anchor = 17;
            gridBagConstraints3.gridwidth = 3;
            gridBagConstraints3.gridx = 0;
            gridBagConstraints3.gridy = 3;
            gridBagConstraints3.insets = new Insets(5, 2, 5, 2);
            gridBagConstraints3.ipadx = 3;
            gridBagConstraints3.ipady = 3;
            jLabel.setText(MSG);
            jLabel.setMaximumSize(new Dimension(Integer.MAX_VALUE, 80));
            jLabel.setMinimumSize(new Dimension(350, 24));
            jLabel.setPreferredSize(new Dimension(350, 50));
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.gridy = 0;
            gridBagConstraints2.insets = new Insets(5, 10, 5, 10);
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.gridwidth = 3;
            gridBagConstraints2.anchor = 17;
            gridBagConstraints2.fill = 2;
            gridBagConstraints2.ipadx = 3;
            gridBagConstraints2.ipady = 3;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridwidth = 3;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(2, 10, 2, 10);
            gridBagConstraints.ipadx = 0;
            gridBagConstraints.ipady = 1;
            this.jPanel.add((Component)jLabel, gridBagConstraints2);
            this.jPanel.add((Component)this.getJPanel2(), gridBagConstraints);
            this.jPanel.add((Component)this.getJPanel1(), gridBagConstraints3);
        }
        return this.jPanel;
    }

    private JButton getBtnApply() {
        if (this.btnApply == null) {
            this.btnApply = new JButton();
            this.btnApply.setText(Constant.messages.getString("history.filter.button.apply"));
            this.btnApply.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        HistoryFilterPlusDialog.this.filter.setMethods(HistoryFilterPlusDialog.this.methodList.getSelectedValuesList());
                        HistoryFilterPlusDialog.this.filter.setCodes(HistoryFilterPlusDialog.this.codeList.getSelectedValuesList());
                        HistoryFilterPlusDialog.this.filter.setTags(HistoryFilterPlusDialog.this.tagList.getSelectedValuesList());
                        HistoryFilterPlusDialog.this.filter.setRisks(HistoryFilterPlusDialog.this.riskList.getSelectedValuesList());
                        HistoryFilterPlusDialog.this.filter.setReliabilities(HistoryFilterPlusDialog.this.confidenceList.getSelectedValuesList());
                        HistoryFilterPlusDialog.this.filter.setNote(HistoryFilterPlusDialog.this.notesComboBox.getSelectedItem());
                        HistoryFilterPlusDialog.this.filter.setUrlIncPatternList(HistoryFilterPlusDialog.this.strToRegexList(HistoryFilterPlusDialog.this.regexInc.getText()));
                        HistoryFilterPlusDialog.this.filter.setUrlExcPatternList(HistoryFilterPlusDialog.this.strToRegexList(HistoryFilterPlusDialog.this.regexExc.getText()));
                        HistoryFilterPlusDialog.this.exitResult = 0;
                        HistoryFilterPlusDialog.this.dispose();
                    }
                    catch (PatternSyntaxException patternSyntaxException) {
                        View.getSingleton().showWarningDialog(MessageFormat.format(Constant.messages.getString("history.filter.badregex.warning"), patternSyntaxException.getMessage()));
                    }
                }
            });
        }
        return this.btnApply;
    }

    private List<Pattern> strToRegexList(String string) throws PatternSyntaxException {
        ArrayList<Pattern> arrayList = new ArrayList<Pattern>();
        for (String string2 : string.split("\n")) {
            if (string2.length() <= 0) continue;
            arrayList.add(Pattern.compile(string2));
        }
        return arrayList;
    }

    private JButton getBtnCancel() {
        if (this.btnCancel == null) {
            this.btnCancel = new JButton();
            this.btnCancel.setText(Constant.messages.getString("all.button.cancel"));
            this.btnCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    HistoryFilterPlusDialog.this.exitResult = 2;
                    HistoryFilterPlusDialog.this.dispose();
                }
            });
        }
        return this.btnCancel;
    }

    private JPanel getJPanel1() {
        if (this.jPanel1 == null) {
            this.jPanel1 = new JPanel();
            this.jPanel1.add((Component)this.getBtnCancel(), null);
            this.jPanel1.add((Component)this.getBtnReset(), null);
            this.jPanel1.add((Component)this.getBtnApply(), null);
        }
        return this.jPanel1;
    }

    public int showDialog() {
        this.setVisible(true);
        return this.exitResult;
    }

    private JButton getBtnReset() {
        if (this.btnReset == null) {
            this.btnReset = new JButton();
            this.btnReset.setText(Constant.messages.getString("history.filter.button.clear"));
            this.btnReset.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    HistoryFilterPlusDialog.this.exitResult = 1;
                    HistoryFilterPlusDialog.this.methodList.setSelectedIndices(new int[0]);
                    HistoryFilterPlusDialog.this.codeList.setSelectedIndices(new int[0]);
                    HistoryFilterPlusDialog.this.tagList.setSelectedIndices(new int[0]);
                    HistoryFilterPlusDialog.this.riskList.setSelectedIndices(new int[0]);
                    HistoryFilterPlusDialog.this.confidenceList.setSelectedIndices(new int[0]);
                    HistoryFilterPlusDialog.this.notesComboBox.setSelectedItem(HistoryFilter.NOTES_IGNORE);
                    HistoryFilterPlusDialog.this.regexInc.setText("");
                    HistoryFilterPlusDialog.this.regexExc.setText("");
                    HistoryFilterPlusDialog.this.filter.reset();
                }
            });
        }
        return this.btnReset;
    }

    private Insets stdInset() {
        return new Insets(5, 5, 1, 5);
    }

    private JPanel getJPanel2() {
        if (this.jPanel2 == null) {
            this.jPanel2 = new JPanel();
            this.jPanel2.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = LayoutHelper.getGBC(0, 0, 1, 1.0, this.stdInset());
            GridBagConstraints gridBagConstraints2 = LayoutHelper.getGBC(1, 0, 1, 1.0, this.stdInset());
            GridBagConstraints gridBagConstraints3 = LayoutHelper.getGBC(2, 0, 1, 1.0, this.stdInset());
            GridBagConstraints gridBagConstraints4 = LayoutHelper.getGBC(3, 0, 1, 1.0, this.stdInset());
            GridBagConstraints gridBagConstraints5 = LayoutHelper.getGBC(4, 0, 1, 1.0, this.stdInset());
            GridBagConstraints gridBagConstraints6 = LayoutHelper.getGBC(0, 1, 1, 3, 1.0, 1.0, 1, 18, this.stdInset());
            GridBagConstraints gridBagConstraints7 = LayoutHelper.getGBC(1, 1, 1, 3, 1.0, 1.0, 1, 18, this.stdInset());
            GridBagConstraints gridBagConstraints8 = LayoutHelper.getGBC(2, 1, 1, 3, 1.0, 1.0, 1, 18, this.stdInset());
            GridBagConstraints gridBagConstraints9 = LayoutHelper.getGBC(3, 1, 1, 2, 1.0, 1.0, 1, 18, this.stdInset());
            GridBagConstraints gridBagConstraints10 = LayoutHelper.getGBC(4, 1, 1, 1, 0.0, 0.0, 1, 18, this.stdInset());
            GridBagConstraints gridBagConstraints11 = LayoutHelper.getGBC(4, 2, 1, 1, 1.0, 1.0, 1, 18, null);
            GridBagConstraints gridBagConstraints12 = LayoutHelper.getGBC(3, 3, 1, 1, 1.0, 1.0, 1, 18, this.stdInset());
            GridBagConstraints gridBagConstraints13 = LayoutHelper.getGBC(4, 3, 1, 1, 0.0, 0.0, 1, 18, this.stdInset());
            GridBagConstraints gridBagConstraints14 = LayoutHelper.getGBC(0, 4, 2, 1.0, this.stdInset());
            this.jPanel2.add((Component)new JLabel(Constant.messages.getString("history.filter.label.methods")), gridBagConstraints);
            this.jPanel2.add((Component)new JLabel(Constant.messages.getString("history.filter.label.codes")), gridBagConstraints2);
            this.jPanel2.add((Component)new JLabel(Constant.messages.getString("history.filter.label.tags")), gridBagConstraints3);
            this.jPanel2.add((Component)new JLabel(Constant.messages.getString("history.filter.label.alerts")), gridBagConstraints4);
            this.jPanel2.add((Component)new JLabel(Constant.messages.getString("history.filter.label.urlincregex")), gridBagConstraints5);
            this.jPanel2.add((Component)this.getMethodScroller(), gridBagConstraints6);
            this.jPanel2.add((Component)this.getCodeScroller(), gridBagConstraints7);
            this.jPanel2.add((Component)this.getTagScroller(), gridBagConstraints8);
            this.jPanel2.add((Component)this.getRiskScroller(), gridBagConstraints9);
            this.jPanel2.add((Component)this.getUrlRegxIncScroller(), gridBagConstraints10);
            this.jPanel2.add((Component)new JLabel(Constant.messages.getString("history.filter.label.urlexcregex")), gridBagConstraints11);
            this.jPanel2.add((Component)this.getConfidenceScroller(), gridBagConstraints12);
            this.jPanel2.add((Component)this.getUrlRegxExcScroller(), gridBagConstraints13);
            this.getUrlRegxExcScroller();
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BoxLayout(jPanel, 0));
            jPanel.add(new JLabel(Constant.messages.getString("history.filter.label.notes")));
            jPanel.add(this.getNotesComboBox());
            this.jPanel2.add((Component)jPanel, gridBagConstraints14);
        }
        return this.jPanel2;
    }

    private JScrollPane getMethodScroller() {
        if (this.methodScroller == null) {
            this.methodList = new JList<String>(HttpRequestHeader.METHODS);
            this.methodList.setSelectionMode(2);
            this.methodList.setLayoutOrientation(0);
            this.methodList.setVisibleRowCount(HttpRequestHeader.METHODS.length);
            this.methodScroller = new JScrollPane(this.methodList);
        }
        return this.methodScroller;
    }

    private JScrollPane getCodeScroller() {
        if (this.codeScroller == null) {
            Vector<Integer> vector = new Vector<Integer>(HttpStatusCode.CODES.length);
            for (int n : HttpStatusCode.CODES) {
                vector.add(n);
            }
            this.codeList = new JList(vector);
            this.codeList.setSelectionMode(2);
            this.codeList.setLayoutOrientation(0);
            this.codeScroller = new JScrollPane(this.codeList);
        }
        return this.codeScroller;
    }

    private JScrollPane getRiskScroller() {
        if (this.riskScroller == null) {
            this.riskList = new JList<String>(Alert.MSG_RISK);
            this.riskList.setSelectionMode(2);
            this.riskList.setLayoutOrientation(0);
            this.riskList.setVisibleRowCount(Alert.MSG_RISK.length);
            this.riskScroller = new JScrollPane(this.riskList);
        }
        return this.riskScroller;
    }

    private JScrollPane getConfidenceScroller() {
        if (this.confidenceScroller == null) {
            this.confidenceList = new JList<String>(Alert.MSG_CONFIDENCE);
            this.confidenceList.setSelectionMode(2);
            this.confidenceList.setLayoutOrientation(0);
            this.confidenceList.setVisibleRowCount(Alert.MSG_CONFIDENCE.length);
            this.confidenceScroller = new JScrollPane(this.confidenceList);
        }
        return this.confidenceScroller;
    }

    private JScrollPane getUrlRegxIncScroller() {
        if (this.urlRegxIncScroller == null) {
            this.regexInc = new JTextArea();
            this.urlRegxIncScroller = new JScrollPane(this.regexInc);
            this.urlRegxIncScroller.setPreferredSize(new Dimension(65, 80));
            this.urlRegxIncScroller.setMinimumSize(new Dimension(65, 80));
            this.urlRegxIncScroller.setMaximumSize(new Dimension(65, 80));
        }
        return this.urlRegxIncScroller;
    }

    private JScrollPane getUrlRegxExcScroller() {
        if (this.urlRegxExcScroller == null) {
            this.regexExc = new JTextArea();
            this.urlRegxExcScroller = new JScrollPane(this.regexExc);
            this.urlRegxExcScroller.setPreferredSize(new Dimension(65, 80));
            this.urlRegxExcScroller.setMinimumSize(new Dimension(65, 80));
            this.urlRegxExcScroller.setMaximumSize(new Dimension(65, 80));
        }
        return this.urlRegxExcScroller;
    }

    private DefaultListModel<String> getTagModel() {
        if (this.tagModel == null) {
            this.tagModel = new DefaultListModel();
        }
        return this.tagModel;
    }

    private JScrollPane getTagScroller() {
        if (this.tagScroller == null) {
            this.tagList = new JList<String>(this.getTagModel());
            this.tagScroller = new JScrollPane(this.tagList);
            this.tagScroller.setPreferredSize(new Dimension(120, 160));
            this.tagScroller.setHorizontalScrollBarPolicy(30);
            this.tagScroller.setVerticalScrollBarPolicy(20);
        }
        return this.tagScroller;
    }

    private JComboBox<String> getNotesComboBox() {
        if (this.notesComboBox == null) {
            this.notesComboBox = new JComboBox<String>(HistoryFilter.NOTES_OPTIONS);
        }
        return this.notesComboBox;
    }

    public void setAllTags(List<String> list) {
        List<String> list2 = this.tagList.getSelectedValuesList();
        int[] nArray = new int[list.size()];
        Arrays.fill(nArray, -1);
        this.getTagModel().clear();
        int n = 0;
        for (String string : list) {
            this.getTagModel().addElement(string);
        }
        for (String string : list2) {
            if (this.getTagModel().contains(string)) {
                nArray[n] = this.getTagModel().indexOf(string);
            }
            ++n;
        }
        this.tagList.setSelectedIndices(nArray);
    }

    public HistoryFilter getFilter() {
        return this.filter;
    }
}

