/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.script;

import org.apache.log4j.Logger;
import org.parosproxy.paros.network.HttpMessage;
import org.parosproxy.paros.network.HttpSender;
import org.zaproxy.zap.extension.script.ExtensionScript;
import org.zaproxy.zap.extension.script.ScriptWrapper;
import org.zaproxy.zap.network.HttpSenderListener;

class HttpSenderScriptListener
implements HttpSenderListener {
    private static final Logger logger = Logger.getLogger(HttpSenderScriptListener.class);
    private final ExtensionScript extension;

    public HttpSenderScriptListener(ExtensionScript extensionScript) {
        this.extension = extensionScript;
    }

    @Override
    public int getListenerOrder() {
        return Integer.MAX_VALUE;
    }

    @Override
    public void onHttpRequestSend(HttpMessage httpMessage, int n, HttpSender httpSender) {
        for (ScriptWrapper scriptWrapper : this.extension.getScripts("httpsender")) {
            if (!scriptWrapper.isEnabled()) continue;
            try {
                this.extension.invokeSenderScript(scriptWrapper, httpMessage, n, httpSender, true);
            }
            catch (Exception exception) {
                logger.error((Object)exception.getMessage(), (Throwable)exception);
            }
        }
    }

    @Override
    public void onHttpResponseReceive(HttpMessage httpMessage, int n, HttpSender httpSender) {
        for (ScriptWrapper scriptWrapper : this.extension.getScripts("httpsender")) {
            if (!scriptWrapper.isEnabled()) continue;
            try {
                this.extension.invokeSenderScript(scriptWrapper, httpMessage, n, httpSender, false);
            }
            catch (Exception exception) {
                logger.error((Object)exception.getMessage(), (Throwable)exception);
            }
        }
    }
}

