/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.view;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.parosproxy.paros.Constant;
import org.zaproxy.zap.utils.ZapTextField;
import org.zaproxy.zap.view.LayoutHelper;

public class DynamicFieldsPanel
extends JPanel {
    private static final long serialVersionUID = -1129326656062554952L;
    private String[] requiredFields;
    private String[] optionalFields;
    private Map<String, ZapTextField> textFields;

    public DynamicFieldsPanel(String[] stringArray) {
        this(stringArray, new String[0]);
    }

    public DynamicFieldsPanel(String[] stringArray, String[] stringArray2) {
        this.requiredFields = stringArray;
        this.optionalFields = stringArray2;
        this.textFields = new HashMap<String, ZapTextField>(stringArray.length + stringArray2.length);
        this.initialize();
    }

    private void initialize() {
        ZapTextField zapTextField;
        this.setLayout(new GridBagLayout());
        int n = 0;
        for (String string : this.requiredFields) {
            this.add((Component)new JLabel("* " + string + ": "), LayoutHelper.getGBC(0, n, 1, 0.0, 0.0));
            zapTextField = new ZapTextField();
            this.add((Component)zapTextField, LayoutHelper.getGBC(1, n, 1, 1.0, 0.0));
            this.textFields.put(string, zapTextField);
            ++n;
        }
        for (String string : this.optionalFields) {
            this.add((Component)new JLabel(string + ": "), LayoutHelper.getGBC(0, n, 1, 0.0, 0.0));
            zapTextField = new ZapTextField();
            this.add((Component)zapTextField, LayoutHelper.getGBC(1, n, 1, 1.0, 0.0));
            this.textFields.put(string, zapTextField);
            ++n;
        }
    }

    public Map<String, String> getFieldValues() {
        HashMap<String, String> hashMap = new HashMap<String, String>(this.requiredFields.length + this.optionalFields.length);
        for (Map.Entry<String, ZapTextField> entry : this.textFields.entrySet()) {
            hashMap.put(entry.getKey(), entry.getValue().getText());
        }
        return hashMap;
    }

    public void bindFieldValues(Map<String, String> map) {
        for (Map.Entry<String, ZapTextField> entry : this.textFields.entrySet()) {
            if (map.containsKey(entry.getKey())) {
                entry.getValue().setText(map.get(entry.getKey()));
                continue;
            }
            entry.getValue().setText("");
        }
    }

    public void validateFields() throws IllegalStateException {
        for (String string : this.requiredFields) {
            if (!this.textFields.get(string).getText().trim().isEmpty()) continue;
            this.textFields.get(string).requestFocusInWindow();
            throw new IllegalStateException(Constant.messages.getString("authentication.method.script.dialog.error.text.required", string));
        }
    }
}

