/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.jbrofuzz.graph;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.text.BadLocationException;
import org.owasp.jbrofuzz.graph.FileSystemTree;
import org.owasp.jbrofuzz.graph.FileSystemTreeModel;
import org.owasp.jbrofuzz.graph.FileSystemTreeNode;
import org.owasp.jbrofuzz.graph.TabbedPlotter;
import org.owasp.jbrofuzz.io.StorageHandler;
import org.owasp.jbrofuzz.system.Logger;
import org.owasp.jbrofuzz.ui.AbstractPanel;
import org.owasp.jbrofuzz.ui.JBroFuzzWindow;
import org.owasp.jbrofuzz.version.JBroFuzzFormat;

public class GraphingPanel
extends AbstractPanel {
    private static final long serialVersionUID = -3962672183042644437L;
    private final FileSystemTree tree;
    private final JProgressBar progressBar;
    private boolean stopped;
    private final JTextArea console;
    private final TabbedPlotter rightPanel;

    public GraphingPanel(JBroFuzzWindow mWindow) {
        super(" Graphing ", mWindow);
        this.setLayout(new BorderLayout());
        this.stopped = true;
        this.setOptionsAvailable(true, false, true, false, false);
        this.console = new JTextArea();
        JScrollPane consoleSclPanel = new JScrollPane(this.console);
        consoleSclPanel.setVerticalScrollBarPolicy(20);
        consoleSclPanel.setHorizontalScrollBarPolicy(30);
        JPanel consolePanel = new JPanel(new BorderLayout());
        consolePanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(" Console "), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        consolePanel.add(consoleSclPanel);
        this.tree = new FileSystemTree(this, new FileSystemTreeModel(new FileSystemTreeNode("...")));
        JScrollPane treeScrollPanel = new JScrollPane(this.tree);
        treeScrollPanel.setVerticalScrollBarPolicy(20);
        treeScrollPanel.setHorizontalScrollBarPolicy(30);
        JPanel treePanel = new JPanel(new BorderLayout());
        treePanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(" Tree View "), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        treePanel.add(treeScrollPanel);
        JTabbedPane leftPanel = new JTabbedPane(1);
        leftPanel.add(" Tree ", treePanel);
        leftPanel.add(" Console ", consolePanel);
        this.rightPanel = new TabbedPlotter(this);
        JSplitPane mainSplitPanel = new JSplitPane(1);
        mainSplitPanel.setOneTouchExpandable(false);
        mainSplitPanel.setDividerLocation(300);
        mainSplitPanel.setLeftComponent(leftPanel);
        mainSplitPanel.setRightComponent(this.rightPanel);
        leftPanel.setMinimumSize(JBroFuzzFormat.ZERO_DIM);
        this.rightPanel.setMinimumSize(JBroFuzzFormat.ZERO_DIM);
        this.progressBar = new JProgressBar();
        this.progressBar.setString("   ");
        this.progressBar.setStringPainted(true);
        this.progressBar.setBounds(410, 465, 120, 20);
        JPanel bottomPanel = new JPanel(new FlowLayout(2));
        bottomPanel.add(this.progressBar);
        this.add((Component)mainSplitPanel, "Center");
        this.add((Component)bottomPanel, "South");
    }

    @Override
    public void add() {
    }

    public TabbedPlotter getTabbedPlotter() {
        return this.rightPanel;
    }

    @Override
    public void pause() {
    }

    @Override
    public boolean isStoppedEnabled() {
        return this.stopped;
    }

    @Override
    public void remove() {
    }

    protected void setProgressBarStart() {
        this.progressBar.setIndeterminate(true);
    }

    protected void setProgressBarStop() {
        this.progressBar.setIndeterminate(false);
    }

    @Override
    public void start() {
        if (!this.stopped) {
            return;
        }
        this.stopped = false;
        this.setOptionsAvailable(false, true, true, false, false);
        this.setProgressBarStart();
        StorageHandler sh = (StorageHandler)this.getFrame().getJBroFuzz().getStorageHandler();
        this.tree.setModel(new FileSystemTreeModel(sh.getSystemTreeNodeFromWalker(this)));
    }

    @Override
    public void stop() {
        if (this.stopped) {
            return;
        }
        this.stopped = true;
        this.setOptionsAvailable(true, false, true, false, false);
        this.setProgressBarStop();
    }

    public void toConsole(String input) {
        if (this.console.getLineCount() > 500) {
            try {
                this.console.select(this.console.getLineStartOffset(0), this.console.getLineEndOffset(this.console.getLineCount() - 500));
                this.console.replaceSelection("...\n");
            }
            catch (BadLocationException e) {
                Logger.log("Could not clear the console", 3);
            }
        }
        this.console.append("> " + input + "\n");
        this.console.setCaretPosition(this.console.getText().length());
    }
}

