/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.bootstrap;

import com.google.common.collect.ImmutableList;
import com.google.common.io.Files;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.internal.classpath.DefaultClassPath;
import org.gradle.internal.logging.LoggingManagerInternal;
import org.gradle.internal.logging.services.LoggingServiceRegistry;
import org.gradle.internal.nativeintegration.services.NativeServices;
import org.gradle.internal.remote.Address;
import org.gradle.internal.serialize.kryo.KryoBackedDecoder;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.launcher.bootstrap.EntryPoint;
import org.gradle.launcher.bootstrap.ExecutionListener;
import org.gradle.launcher.daemon.bootstrap.DaemonStartupCommunication;
import org.gradle.launcher.daemon.configuration.DaemonServerConfiguration;
import org.gradle.launcher.daemon.configuration.DefaultDaemonServerConfiguration;
import org.gradle.launcher.daemon.context.DaemonContext;
import org.gradle.launcher.daemon.server.AllDaemonExpirationStrategy;
import org.gradle.launcher.daemon.server.AnyDaemonExpirationStrategy;
import org.gradle.launcher.daemon.server.Daemon;
import org.gradle.launcher.daemon.server.DaemonExpirationStrategy;
import org.gradle.launcher.daemon.server.DaemonIdleTimeoutExpirationStrategy;
import org.gradle.launcher.daemon.server.DaemonRegistryUnavailableExpirationStrategy;
import org.gradle.launcher.daemon.server.DaemonServices;
import org.gradle.launcher.daemon.server.LowMemoryDaemonExpirationStrategy;
import org.gradle.launcher.daemon.server.LowTenuredSpaceDaemonExpirationStrategy;
import org.gradle.launcher.daemon.server.health.DaemonHealthServices;
import org.gradle.process.internal.streams.EncodedStream;

public class DaemonMain
extends EntryPoint {
    private static final Logger LOGGER = Logging.getLogger(DaemonMain.class);
    private PrintStream originalOut;
    private PrintStream originalErr;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doAction(String[] args, ExecutionListener listener) {
        ArrayList<File> additionalClassPath;
        ArrayList<String> startupOpts;
        String daemonUid;
        int periodicCheckIntervalMs;
        int idleTimeoutMs;
        File daemonBaseDir;
        File gradleHomeDir;
        if (args.length != 1) {
            DaemonMain.invalidArgs("Following arguments are required: <gradle-version>");
        }
        KryoBackedDecoder decoder = new KryoBackedDecoder((InputStream)new EncodedStream.EncodedInput(System.in));
        try {
            gradleHomeDir = new File(decoder.readString());
            daemonBaseDir = new File(decoder.readString());
            idleTimeoutMs = decoder.readSmallInt();
            periodicCheckIntervalMs = decoder.readSmallInt();
            daemonUid = decoder.readString();
            int argCount = decoder.readSmallInt();
            startupOpts = new ArrayList<String>(argCount);
            for (int i = 0; i < argCount; ++i) {
                startupOpts.add(decoder.readString());
            }
            int additionalClassPathLength = decoder.readSmallInt();
            additionalClassPath = new ArrayList<File>(additionalClassPathLength);
            for (int i = 0; i < additionalClassPathLength; ++i) {
                additionalClassPath.add(new File(decoder.readString()));
            }
        }
        catch (EOFException e) {
            throw new UncheckedIOException(e);
        }
        LOGGER.debug("Assuming the daemon was started with following jvm opts: {}", startupOpts);
        NativeServices.initialize((File)gradleHomeDir);
        DefaultDaemonServerConfiguration parameters = new DefaultDaemonServerConfiguration(daemonUid, daemonBaseDir, idleTimeoutMs, periodicCheckIntervalMs, startupOpts);
        LoggingServiceRegistry loggingRegistry = LoggingServiceRegistry.newCommandLineProcessLogging();
        LoggingManagerInternal loggingManager = (LoggingManagerInternal)loggingRegistry.newInstance(LoggingManagerInternal.class);
        DaemonServices daemonServices = new DaemonServices(parameters, (ServiceRegistry)loggingRegistry, loggingManager, new DefaultClassPath(additionalClassPath));
        File daemonLog = daemonServices.getDaemonLogFile();
        this.initialiseLogging(loggingManager, daemonLog);
        Daemon daemon = daemonServices.get(Daemon.class);
        daemon.start();
        try {
            DaemonContext daemonContext = daemonServices.get(DaemonContext.class);
            Long pid = daemonContext.getPid();
            this.daemonStarted(pid, daemon.getUid(), daemon.getAddress(), daemonLog);
            daemon.stopOnExpiration(this.initializeExpirationStrategy(daemonServices, parameters), parameters.getPeriodicCheckIntervalMs());
        }
        finally {
            daemon.stop();
        }
    }

    private static void invalidArgs(String message) {
        System.out.println("USAGE: <gradle version> <path to registry base dir> <idle timeout in milliseconds>");
        System.out.println(message);
        System.exit(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void daemonStarted(Long pid, String uid, Address address, File daemonLog) {
        new DaemonStartupCommunication().printDaemonStarted(this.originalOut, pid, uid, address, daemonLog);
        try {
            this.originalOut.close();
            this.originalErr.close();
        }
        finally {
            this.originalOut = null;
            this.originalErr = null;
        }
    }

    protected void initialiseLogging(LoggingManagerInternal loggingManager, File daemonLog) {
        PrintStream result;
        try {
            Files.createParentDirs((File)daemonLog);
            result = new PrintStream(new FileOutputStream(daemonLog), true);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to create daemon log file", e);
        }
        final PrintStream log = result;
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                log.println("Daemon vm is shutting down... The daemon has exited normally or was terminated in response to a user interrupt.");
            }
        });
        this.redirectOutputsAndInput(log);
        loggingManager.attachSystemOutAndErr();
        loggingManager.setLevelInternal(LogLevel.DEBUG);
        loggingManager.start();
    }

    private DaemonExpirationStrategy initializeExpirationStrategy(DaemonServices daemonServices, DaemonServerConfiguration params) {
        ImmutableList.Builder strategies = ImmutableList.builder();
        strategies.add((Object)new DaemonIdleTimeoutExpirationStrategy(params.getIdleTimeout(), TimeUnit.MILLISECONDS));
        strategies.add((Object)new LowTenuredSpaceDaemonExpirationStrategy(daemonServices.get(DaemonHealthServices.class)));
        try {
            strategies.add((Object)new AllDaemonExpirationStrategy((List<DaemonExpirationStrategy>)ImmutableList.of((Object)new DaemonIdleTimeoutExpirationStrategy(params.getIdleTimeout() / 4, TimeUnit.MILLISECONDS), (Object)LowMemoryDaemonExpirationStrategy.belowFreePercentage(0.2))));
        }
        catch (UnsupportedOperationException e) {
            LOGGER.info("This JVM does not support getting free system memory, so daemons will not check for it");
        }
        strategies.add((Object)new DaemonRegistryUnavailableExpirationStrategy());
        return new AnyDaemonExpirationStrategy((List<DaemonExpirationStrategy>)strategies.build());
    }

    private void redirectOutputsAndInput(PrintStream printStream) {
        this.originalOut = System.out;
        this.originalErr = System.err;
        System.setOut(printStream);
        System.setErr(printStream);
        System.setIn(new ByteArrayInputStream(new byte[0]));
    }
}

