/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.ActionMap;
import org.netbeans.modules.search.FindInFilesAction;
import org.netbeans.modules.search.ReplaceInFilesAction;
import org.openide.actions.FindAction;
import org.openide.actions.ReplaceAction;
import org.openide.text.CloneableEditorSupport;
import org.openide.util.Mutex;
import org.openide.util.SharedClassObject;
import org.openide.util.WeakSet;
import org.openide.util.actions.CallbackSystemAction;
import org.openide.util.actions.SystemAction;
import org.openide.windows.TopComponent;

public abstract class ActionManager<A extends SystemAction, S extends CallbackSystemAction>
implements PropertyChangeListener,
Runnable {
    protected static final Logger LOG = Logger.getLogger(ActionManager.class.getName());
    protected final A action;
    private final Set<TopComponent> activatedOnWindows = new WeakSet(8);
    private Object actionMapKey;
    private Class<S> origSysActionCls;

    protected ActionManager(Class<A> clazz, Class<S> clazz2) {
        this.origSysActionCls = clazz2;
        this.action = (SystemAction)SharedClassObject.findObject(clazz, (boolean)true);
    }

    void init() {
        TopComponent.getRegistry().addPropertyChangeListener((PropertyChangeListener)this);
        Mutex.EVENT.writeAccess((Runnable)this);
    }

    @Override
    public void run() {
        this.someoneActivated();
    }

    private void someoneActivated() {
        Object object;
        Object object2;
        TopComponent topComponent = TopComponent.getRegistry().getActivated();
        if (LOG.isLoggable(Level.FINER)) {
            if (topComponent == null) {
                object2 = "<null>";
            } else {
                object = topComponent.getDisplayName();
                if (object == null) {
                    object = topComponent.getHtmlDisplayName();
                }
                if (object == null) {
                    object = topComponent.getName();
                }
                object = object != null ? '\"' + (String)object + '\"' : "<noname>";
                object2 = (String)object + '(' + topComponent.getClass().getName() + ')';
            }
            LOG.log(Level.FINER, "someoneActivated ({0})", object2);
        }
        if (topComponent == null || topComponent instanceof CloneableEditorSupport.Pane) {
            return;
        }
        object2 = this.getActionMapKey();
        object = topComponent.getActionMap();
        if (((ActionMap)object).get(object2) == null && this.activatedOnWindows.add(topComponent)) {
            Action action = this.getAction();
            ((ActionMap)object).put(object2, action);
            topComponent.putClientProperty((Object)this.getMappedActionKey(), new WeakReference<Action>(action));
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if ("activated".equals(string)) {
            this.someoneActivated();
        }
    }

    private Object getActionMapKey() {
        if (this.actionMapKey == null) {
            CallbackSystemAction callbackSystemAction = (CallbackSystemAction)SharedClassObject.findObject(this.origSysActionCls, (boolean)true);
            assert (callbackSystemAction != null);
            this.actionMapKey = callbackSystemAction.getActionMapKey();
        }
        return this.actionMapKey;
    }

    public abstract String getMappedActionKey();

    protected abstract Action getAction();

    static final class ReplaceActionManager
    extends ActionManager<ReplaceInFilesAction.Selection, ReplaceAction> {
        private static final String MAPPED_FIND_ACTION = ReplaceActionManager.class.getName() + " - ReplActionImpl";
        private static ReplaceActionManager instance = null;

        private ReplaceActionManager() {
            super(ReplaceInFilesAction.Selection.class, ReplaceAction.class);
        }

        @Override
        public String getMappedActionKey() {
            return MAPPED_FIND_ACTION;
        }

        @Override
        protected Action getAction() {
            return this.action;
        }

        static ReplaceActionManager getInstance() {
            LOG.finer("getInstance()");
            if (instance == null) {
                instance = new ReplaceActionManager();
            }
            return instance;
        }
    }

    static final class FindActionManager
    extends ActionManager<FindInFilesAction.Selection, FindAction> {
        private static final String MAPPED_FIND_ACTION = FindActionManager.class.getName() + " - FindActionImpl";
        private static FindActionManager instance = null;

        private FindActionManager() {
            super(FindInFilesAction.Selection.class, FindAction.class);
        }

        @Override
        public String getMappedActionKey() {
            return MAPPED_FIND_ACTION;
        }

        @Override
        protected Action getAction() {
            return this.action;
        }

        static FindActionManager getInstance() {
            LOG.finer("getInstance()");
            if (instance == null) {
                instance = new FindActionManager();
            }
            return instance;
        }
    }
}

