/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.core.module.id;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.ivy.core.module.id.MatcherLookup;
import org.apache.ivy.core.module.id.ModuleId;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.plugins.matcher.MapMatcher;
import org.apache.ivy.util.Checks;
import org.apache.ivy.util.Message;
import org.apache.ivy.util.filter.Filter;
import org.apache.ivy.util.filter.NoFilter;

public class ModuleRules {
    private Map rules = new LinkedHashMap();
    private MatcherLookup matcher_lookup = new MatcherLookup();

    public ModuleRules() {
    }

    private ModuleRules(Map rules) {
        this.rules = new LinkedHashMap(rules);
        Iterator iter = rules.keySet().iterator();
        while (iter.hasNext()) {
            this.matcher_lookup.add((MapMatcher)iter.next());
        }
    }

    public void defineRule(MapMatcher condition, Object rule) {
        Checks.checkNotNull(condition, "condition");
        Checks.checkNotNull(rule, "rule");
        this.rules.put(condition, rule);
        this.matcher_lookup.add(condition);
    }

    public Object getRule(ModuleId mid) {
        return this.getRule(mid, NoFilter.INSTANCE);
    }

    public Object[] getRules(ModuleId mid) {
        return this.getRules(mid.getAttributes(), NoFilter.INSTANCE);
    }

    public Object getRule(ModuleRevisionId mrid) {
        return this.getRule(mrid, NoFilter.INSTANCE);
    }

    public Object getRule(ModuleId mid, Filter filter) {
        Checks.checkNotNull(mid, "mid");
        return this.getRule(mid.getAttributes(), filter);
    }

    public Object getRule(ModuleRevisionId mrid, Filter filter) {
        Checks.checkNotNull(mrid, "mrid");
        Checks.checkNotNull(filter, "filter");
        Map moduleAttributes = mrid.getAttributes();
        return this.getRule(moduleAttributes, filter);
    }

    private Object getRule(Map moduleAttributes, Filter filter) {
        List matchers = this.matcher_lookup.get(moduleAttributes);
        for (MapMatcher midm : matchers) {
            Object rule = this.rules.get(midm);
            if (!filter.accept(rule)) continue;
            return rule;
        }
        return null;
    }

    public Object[] getRules(ModuleRevisionId mrid, Filter filter) {
        Checks.checkNotNull(mrid, "mrid");
        Checks.checkNotNull(filter, "filter");
        Map moduleAttributes = mrid.getAttributes();
        return this.getRules(moduleAttributes, filter);
    }

    private Object[] getRules(Map moduleAttributes, Filter filter) {
        List matchers = this.matcher_lookup.get(moduleAttributes);
        ArrayList matchingRules = new ArrayList();
        for (MapMatcher midm : matchers) {
            Object rule = this.rules.get(midm);
            if (!filter.accept(rule)) continue;
            matchingRules.add(rule);
        }
        return matchingRules.toArray();
    }

    public void dump(String prefix) {
        if (this.rules.isEmpty()) {
            Message.debug(prefix + "NONE");
        } else {
            for (MapMatcher midm : this.rules.keySet()) {
                Object rule = this.rules.get(midm);
                Message.debug(prefix + midm + " -> " + rule);
            }
        }
    }

    public Map getAllRules() {
        return Collections.unmodifiableMap(this.rules);
    }

    public Object clone() {
        return new ModuleRules(this.rules);
    }
}

