/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.ast.stmt;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.codehaus.groovy.ast.GroovyCodeVisitor;
import org.codehaus.groovy.ast.VariableScope;
import org.codehaus.groovy.ast.stmt.Statement;

public class BlockStatement
extends Statement {
    private List statements = new ArrayList();
    private VariableScope scope;

    public BlockStatement() {
        this(new ArrayList(), new VariableScope());
    }

    public BlockStatement(List statements, VariableScope scope) {
        this.statements = statements;
        this.scope = scope;
    }

    public BlockStatement(Statement[] statements, VariableScope scope) {
        this.statements.addAll(Arrays.asList(statements));
        this.scope = scope;
    }

    public void visit(GroovyCodeVisitor visitor) {
        visitor.visitBlockStatement(this);
    }

    public List getStatements() {
        return this.statements;
    }

    public void addStatement(Statement statement) {
        this.statements.add(statement);
    }

    public void addStatements(List listOfStatements) {
        this.statements.addAll(listOfStatements);
    }

    public String toString() {
        return super.toString() + this.statements;
    }

    public String getText() {
        StringBuffer buffer = new StringBuffer("{ ");
        boolean first = true;
        Iterator iter = this.statements.iterator();
        while (iter.hasNext()) {
            if (first) {
                first = false;
            } else {
                buffer.append("; ");
            }
            Statement statement = (Statement)iter.next();
            buffer.append(statement.getText());
        }
        buffer.append(" }");
        return buffer.toString();
    }

    public boolean isEmpty() {
        return this.statements.isEmpty();
    }

    public void setVariableScope(VariableScope scope) {
        this.scope = scope;
    }

    public VariableScope getVariableScope() {
        return this.scope;
    }
}

