/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.j3d;

import com.eteks.sweethome3d.j3d.ModelManager;
import com.eteks.sweethome3d.j3d.Object3DBranch;
import com.eteks.sweethome3d.j3d.TextureManager;
import com.eteks.sweethome3d.model.Home;
import com.eteks.sweethome3d.model.HomeFurnitureGroup;
import com.eteks.sweethome3d.model.HomePieceOfFurniture;
import com.eteks.sweethome3d.model.HomeTexture;
import com.eteks.sweethome3d.model.Level;
import com.eteks.sweethome3d.model.Room;
import com.eteks.sweethome3d.model.Wall;
import com.sun.j3d.utils.geometry.GeometryInfo;
import com.sun.j3d.utils.geometry.NormalGenerator;
import java.awt.geom.Area;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.media.j3d.Appearance;
import javax.media.j3d.Geometry;
import javax.media.j3d.Node;
import javax.media.j3d.RenderingAttributes;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Texture;
import javax.media.j3d.TextureAttributes;
import javax.media.j3d.TransparencyAttributes;
import javax.vecmath.Point3f;
import javax.vecmath.TexCoord2f;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Room3D
extends Object3DBranch {
    private static final TextureAttributes MODULATE_TEXTURE_ATTRIBUTES = new TextureAttributes();
    private static final int FLOOR_PART = 0;
    private static final int CEILING_PART = 1;
    private final Home home;

    public Room3D(Room room, Home home) {
        this(room, home, false, false);
    }

    public Room3D(Room room, Home home, boolean bl, boolean bl2) {
        this.setUserData(room);
        this.home = home;
        this.setCapability(17);
        this.setCapability(12);
        this.addChild(this.createRoomPartShape());
        this.addChild(this.createRoomPartShape());
        this.updateRoomGeometry();
        this.updateRoomAppearance(bl2);
        if (bl) {
            this.removeChild(1);
        }
    }

    private Node createRoomPartShape() {
        Shape3D shape3D = new Shape3D();
        shape3D.setCapability(13);
        shape3D.setCapability(12);
        shape3D.setCapability(14);
        Appearance appearance = new Appearance();
        shape3D.setAppearance(appearance);
        appearance.setCapability(10);
        TransparencyAttributes transparencyAttributes = new TransparencyAttributes();
        transparencyAttributes.setCapability(3);
        transparencyAttributes.setCapability(1);
        appearance.setTransparencyAttributes(transparencyAttributes);
        appearance.setCapability(12);
        RenderingAttributes renderingAttributes = new RenderingAttributes();
        renderingAttributes.setCapability(6);
        appearance.setRenderingAttributes(renderingAttributes);
        appearance.setCapability(1);
        appearance.setMaterial(DEFAULT_MATERIAL);
        appearance.setCapability(3);
        appearance.setCapability(2);
        appearance.setTextureAttributes(MODULATE_TEXTURE_ATTRIBUTES);
        return shape3D;
    }

    @Override
    public void update() {
        this.updateRoomGeometry();
        this.updateRoomAppearance(false);
    }

    private void updateRoomGeometry() {
        this.updateRoomPartGeometry(0, ((Room)this.getUserData()).getFloorTexture());
        this.updateRoomPartGeometry(1, ((Room)this.getUserData()).getCeilingTexture());
    }

    private void updateRoomPartGeometry(int n, HomeTexture homeTexture) {
        Shape3D shape3D = (Shape3D)this.getChild(n);
        int n2 = shape3D.numGeometries();
        Room room = (Room)this.getUserData();
        if (room.getLevel() == null || room.getLevel().isViewableAndVisible()) {
            for (Geometry geometry : this.createRoomGeometries(n, homeTexture)) {
                shape3D.addGeometry(geometry);
            }
        }
        for (int i = n2 - 1; i >= 0; --i) {
            shape3D.removeGeometry(i);
        }
    }

    /*
     * WARNING - void declaration
     */
    private Geometry[] createRoomGeometries(int n, HomeTexture homeTexture) {
        Room room = (Room)this.getUserData();
        float[][] fArray = room.getPoints();
        if ((n == 0 && room.isFloorVisible() || n == 1 && room.isCeilingVisible()) && fArray.length > 2) {
            float f;
            Object object2;
            List<Object> list;
            List<float[][]> list2;
            List<float[][]> list3;
            List<float[][]> list4;
            int n2;
            Area area;
            float f2;
            float f3;
            Level level = room.getLevel();
            List<Level> list5 = this.home.getLevels();
            boolean bl = this.isLastLevel(level, list5);
            if (level != null) {
                f3 = level.getElevation();
                f2 = f3 - level.getFloorThickness();
            } else {
                f3 = 0.0f;
                f2 = 0.0f;
            }
            float f4 = list5.size() == 0 ? 0.0f : list5.get(0).getElevation();
            boolean bl2 = n == 0 && level != null && f3 != f4;
            ArrayList<Room> arrayList = new ArrayList<Room>();
            ArrayList<Room> arrayList2 = new ArrayList<Room>();
            for (Room room2 : this.home.getRooms()) {
                Level level2 = room2.getLevel();
                if (level2 != null && !level2.isViewableAndVisible()) continue;
                if (room == room2 || level == level2 && (n == 0 && room2.isFloorVisible() || n == 1 && room2.isCeilingVisible()) || level != null && level2 != null && (n == 0 && room2.isFloorVisible() && (double)Math.abs(f3 - level2.getElevation()) < 1.0E-4 || n == 1 && room2.isCeilingVisible() && !bl && !this.isLastLevel(level2, list5) && (double)Math.abs(f3 + level.getHeight() - (level2.getElevation() + level2.getHeight())) < 1.0E-4)) {
                    arrayList.add(room2);
                    continue;
                }
                if (!bl2 || level2 == null || !room2.isCeilingVisible() || this.isLastLevel(level2, list5) || !((double)Math.abs(f2 - (level2.getElevation() + level2.getHeight())) < 1.0E-4)) continue;
                arrayList2.add(room2);
            }
            if (level != null) {
                Collections.sort(arrayList, new Comparator<Room>(){

                    @Override
                    public int compare(Room room, Room room2) {
                        int n = Float.compare(room.getLevel().getElevation(), room2.getLevel().getElevation());
                        if (n != 0) {
                            return n;
                        }
                        return room.getLevel().getElevationIndex() - room2.getLevel().getElevationIndex();
                    }
                });
            }
            List<HomePieceOfFurniture> list6 = level == null || n == 1 && bl ? Collections.emptyList() : this.getVisibleStaircases(this.home.getFurniture(), n, level, level.getElevation() == f4);
            boolean bl3 = true;
            if (n == 1 && (level == null || bl)) {
                float f5 = this.getRoomHeightAt(fArray[0][0], fArray[0][1]);
                for (int i = 1; i < fArray.length && bl3; ++i) {
                    bl3 = this.getRoomHeightAt(fArray[i][0], fArray[i][1]) == f5;
                }
            }
            if (!room.isSingular() || bl3 && (arrayList.get(arrayList.size() - 1) != room || list6.size() > 0)) {
                area = new Area(this.getShape(fArray));
                if (arrayList.contains(room)) {
                    for (n2 = arrayList.size() - 1; n2 > 0 && arrayList.get(n2) != room; --n2) {
                        Room room3 = (Room)arrayList.get(n2);
                        area.subtract(new Area(this.getShape(room3.getPoints())));
                    }
                }
                this.removeStaircasesFromArea(list6, area);
                list4 = new ArrayList();
                list3 = new ArrayList();
                list2 = this.getAreaPoints(area, list4, list3, 1.0f, n == 1);
            } else {
                n2 = room.isClockwise();
                if (n2 != 0 && n == 0 || n2 == 0 && n == 1) {
                    fArray = this.getReversedArray(fArray);
                }
                list2 = list4 = Arrays.asList(new float[][][]{fArray});
                list3 = Collections.emptyList();
                area = null;
            }
            ArrayList<Geometry> arrayList3 = new ArrayList<Geometry>(3);
            float f6 = this.home.getEnvironment().getSubpartSizeUnderLight();
            if (!list2.isEmpty()) {
                int n3;
                list = new ArrayList();
                boolean bl4 = true;
                for (n3 = 0; n3 < list2.size(); ++n3) {
                    object2 = list2.get(n3);
                    float[] fArray2 = new float[((float[][])object2).length];
                    for (int i = 0; i < ((Object)object2).length; ++i) {
                        float f5 = fArray2[i] = n == 0 ? f3 : this.getRoomHeightAt(object2[i][0], object2[i][1]);
                        if (!bl4 || i <= 0) continue;
                        bl4 = fArray2[i] == fArray2[i - 1];
                    }
                    list.add(fArray2);
                }
                if (bl4 && f6 > 0.0f) {
                    for (n3 = 0; n3 < list2.size(); ++n3) {
                        void object5;
                        object2 = list2.get(n3);
                        float f8 = Float.MAX_VALUE;
                        float f9 = Float.MIN_VALUE;
                        f = Float.MAX_VALUE;
                        float f10 = Float.MIN_VALUE;
                        Object object = object2;
                        int n4 = ((float[][])object).length;
                        boolean f12 = false;
                        while (object5 < n4) {
                            float[] fArray2 = object[object5];
                            f8 = Math.min(f8, fArray2[0]);
                            f9 = Math.max(f9, fArray2[0]);
                            f = Math.min(f, fArray2[1]);
                            f10 = Math.max(f10, fArray2[1]);
                            ++object5;
                        }
                        Area area2 = new Area(this.getShape((float[][])object2));
                        for (float f7 = f8; f7 < f9; f7 += f6) {
                            for (float f11 = f; f11 < f10; f11 += f6) {
                                List<float[][]> list7;
                                Area area3 = new Area(new Rectangle2D.Float(f7, f11, f6, f6));
                                area3.intersect(area2);
                                if (area3.isEmpty() || (list7 = this.getAreaPoints(area3, 1.0f, n == 1)).isEmpty()) continue;
                                arrayList3.add(this.computeRoomPartGeometry(list7, null, level, ((float[])list.get(n3))[0], f2, n == 0, false, homeTexture));
                            }
                        }
                    }
                } else {
                    arrayList3.add(this.computeRoomPartGeometry(list2, list, level, f3, f2, n == 0, false, homeTexture));
                }
                if (level != null && n == 0 && level.getElevation() != f4) {
                    arrayList3.add(this.computeRoomBorderGeometry(list4, list3, level, f3, homeTexture));
                }
            }
            if (bl2) {
                if (area != null || arrayList2.size() > 0) {
                    Area area2 = area != null ? area : new Area(this.getShape(fArray));
                    Iterator iterator = arrayList2.iterator();
                    while (iterator.hasNext()) {
                        object2 = (Room)iterator.next();
                        area2.subtract(new Area(this.getShape(object2.getPoints())));
                    }
                    list = this.getAreaPoints(area2, 1.0f, true);
                } else {
                    list = Arrays.asList(new float[][][]{this.getReversedArray(fArray)});
                }
                if (!list.isEmpty()) {
                    if (f6 > 0.0f) {
                        for (int i = 0; i < list.size(); ++i) {
                            float[][] fArray3 = (float[][])list.get(i);
                            float f13 = Float.MAX_VALUE;
                            float f14 = Float.MIN_VALUE;
                            float f15 = Float.MAX_VALUE;
                            f = Float.MIN_VALUE;
                            for (float[] fArray4 : fArray3) {
                                f13 = Math.min(f13, fArray4[0]);
                                f14 = Math.max(f14, fArray4[0]);
                                f15 = Math.min(f15, fArray4[1]);
                                f = Math.max(f, fArray4[1]);
                            }
                            Area area4 = new Area(this.getShape(fArray3));
                            for (float f12 = f13; f12 < f14; f12 += f6) {
                                for (float f16 = f15; f16 < f; f16 += f6) {
                                    List<float[][]> list8;
                                    Area area5 = new Area(new Rectangle2D.Float(f12, f16, f6, f6));
                                    area5.intersect(area4);
                                    if (area5.isEmpty() || (list8 = this.getAreaPoints(area5, 1.0f, true)).isEmpty()) continue;
                                    arrayList3.add(this.computeRoomPartGeometry(list8, null, level, f3, f2, true, true, homeTexture));
                                }
                            }
                        }
                    } else {
                        arrayList3.add(this.computeRoomPartGeometry(list, null, level, f3, f2, true, true, homeTexture));
                    }
                }
            }
            return arrayList3.toArray(new Geometry[arrayList3.size()]);
        }
        return new Geometry[0];
    }

    private Geometry computeRoomPartGeometry(List<float[][]> list, List<float[]> list2, Level level, float f, float f2, boolean bl, boolean bl2, HomeTexture homeTexture) {
        int[] nArray = new int[list.size()];
        int n = 0;
        for (int i = 0; i < list.size(); ++i) {
            float[][] fArray = list.get(i);
            nArray[i] = fArray.length;
            n += nArray[i];
        }
        Point3f[] point3fArray = new Point3f[n];
        int n2 = 0;
        for (int i = 0; i < list.size(); ++i) {
            float[][] fArray = list.get(i);
            float[] fArray2 = list2 != null ? list2.get(i) : null;
            for (int j = 0; j < fArray.length; ++j) {
                float f3 = bl2 ? f2 : (fArray2 != null ? fArray2[j] : f);
                point3fArray[n2++] = new Point3f(fArray[j][0], f3, fArray[j][1]);
            }
        }
        GeometryInfo geometryInfo = new GeometryInfo(5);
        geometryInfo.setCoordinates(point3fArray);
        geometryInfo.setStripCounts(nArray);
        if (homeTexture != null) {
            float f4 = TextureManager.getInstance().getRotatedTextureWidth(homeTexture);
            float f5 = TextureManager.getInstance().getRotatedTextureHeight(homeTexture);
            TexCoord2f[] texCoord2fArray = new TexCoord2f[n];
            n2 = 0;
            for (float[][] fArray : list) {
                for (int i = 0; i < fArray.length; ++i) {
                    texCoord2fArray[n2++] = new TexCoord2f(fArray[i][0] / f4, bl ? -fArray[i][1] / f5 : fArray[i][1] / f5);
                }
            }
            geometryInfo.setTextureCoordinateParams(1, 2);
            geometryInfo.setTextureCoordinates(0, texCoord2fArray);
        }
        new NormalGenerator().generateNormals(geometryInfo);
        return geometryInfo.getIndexedGeometryArray();
    }

    private Geometry computeRoomBorderGeometry(List<float[][]> list, List<float[][]> list2, Level level, float f, HomeTexture homeTexture) {
        int n;
        int n2;
        Object object2;
        int n3 = 0;
        for (Object object2 : list) {
            n3 += ((float[][])object2).length;
        }
        for (Object object2 : list2) {
            n3 += ((float[][])object2).length;
        }
        int n4 = 0;
        object2 = new Point3f[n3 *= 4];
        float f2 = f - level.getFloorThickness();
        for (float[][] fArray : list) {
            for (n2 = 0; n2 < fArray.length; ++n2) {
                object2[n4++] = (float[])new Point3f(fArray[n2][0], f, fArray[n2][1]);
                object2[n4++] = (float[])new Point3f(fArray[n2][0], f2, fArray[n2][1]);
                n = n2 < fArray.length - 1 ? n2 + 1 : 0;
                object2[n4++] = (float[])new Point3f(fArray[n][0], f2, fArray[n][1]);
                object2[n4++] = (float[])new Point3f(fArray[n][0], f, fArray[n][1]);
            }
        }
        for (float[][] fArray : list2) {
            for (n2 = 0; n2 < fArray.length; ++n2) {
                object2[n4++] = (float[])new Point3f(fArray[n2][0], f, fArray[n2][1]);
                n = n2 < fArray.length - 1 ? n2 + 1 : 0;
                object2[n4++] = (float[])new Point3f(fArray[n][0], f, fArray[n][1]);
                object2[n4++] = (float[])new Point3f(fArray[n][0], f2, fArray[n][1]);
                object2[n4++] = (float[])new Point3f(fArray[n2][0], f2, fArray[n2][1]);
            }
        }
        GeometryInfo geometryInfo = new GeometryInfo(2);
        geometryInfo.setCoordinates((Point3f[])object2);
        if (homeTexture != null) {
            int n5;
            int n6;
            float f3 = TextureManager.getInstance().getRotatedTextureWidth(homeTexture);
            float f4 = TextureManager.getInstance().getRotatedTextureHeight(homeTexture);
            TexCoord2f[] texCoord2fArray = new TexCoord2f[n3];
            n4 = 0;
            for (float[][] fArray : list) {
                for (n6 = 0; n6 < fArray.length; ++n6) {
                    texCoord2fArray[n4++] = new TexCoord2f(fArray[n6][0] / f3, -fArray[n6][1] / f4);
                    texCoord2fArray[n4++] = new TexCoord2f(fArray[n6][0] / f3, -(fArray[n6][1] - level.getFloorThickness()) / f4);
                    n5 = n6 < fArray.length - 1 ? n6 + 1 : 0;
                    texCoord2fArray[n4++] = new TexCoord2f(fArray[n5][0] / f3, -(fArray[n5][1] - level.getFloorThickness()) / f4);
                    texCoord2fArray[n4++] = new TexCoord2f(fArray[n5][0] / f3, -fArray[n5][1] / f4);
                }
            }
            for (float[][] fArray : list2) {
                for (n6 = 0; n6 < fArray.length; ++n6) {
                    texCoord2fArray[n4++] = new TexCoord2f(fArray[n6][0] / f3, -fArray[n6][1] / f4);
                    n5 = n6 < fArray.length - 1 ? n6 + 1 : 0;
                    texCoord2fArray[n4++] = new TexCoord2f(fArray[n5][0] / f3, -fArray[n5][1] / f4);
                    texCoord2fArray[n4++] = new TexCoord2f(fArray[n5][0] / f3, -(fArray[n5][1] - level.getFloorThickness()) / f4);
                    texCoord2fArray[n4++] = new TexCoord2f(fArray[n6][0] / f3, -(fArray[n6][1] - level.getFloorThickness()) / f4);
                }
            }
            geometryInfo.setTextureCoordinateParams(1, 2);
            geometryInfo.setTextureCoordinates(0, texCoord2fArray);
        }
        new NormalGenerator(0.39269908169872414).generateNormals(geometryInfo);
        return geometryInfo.getIndexedGeometryArray();
    }

    private void removeStaircasesFromArea(List<HomePieceOfFurniture> list, Area area) {
        ModelManager modelManager = ModelManager.getInstance();
        for (HomePieceOfFurniture homePieceOfFurniture : list) {
            area.subtract(modelManager.getAreaOnFloor(homePieceOfFurniture));
        }
    }

    private List<HomePieceOfFurniture> getVisibleStaircases(List<HomePieceOfFurniture> list, int n, Level level, boolean bl) {
        ArrayList<HomePieceOfFurniture> arrayList = new ArrayList<HomePieceOfFurniture>(list.size());
        for (HomePieceOfFurniture homePieceOfFurniture : list) {
            if (!homePieceOfFurniture.isVisible() || homePieceOfFurniture.getLevel() != null && !homePieceOfFurniture.getLevel().isViewableAndVisible()) continue;
            if (homePieceOfFurniture instanceof HomeFurnitureGroup) {
                arrayList.addAll(this.getVisibleStaircases(((HomeFurnitureGroup)homePieceOfFurniture).getFurniture(), n, level, bl));
                continue;
            }
            if (homePieceOfFurniture.getStaircaseCutOutShape() == null || "false".equalsIgnoreCase(homePieceOfFurniture.getStaircaseCutOutShape()) || !(n == 0 && homePieceOfFurniture.getGroundElevation() < level.getElevation() && homePieceOfFurniture.getGroundElevation() + homePieceOfFurniture.getHeight() >= level.getElevation() - (bl ? 0.0f : level.getFloorThickness())) && (n != 1 || !(homePieceOfFurniture.getGroundElevation() < level.getElevation() + level.getHeight()) || !(homePieceOfFurniture.getGroundElevation() + homePieceOfFurniture.getHeight() >= level.getElevation() + level.getHeight()))) continue;
            arrayList.add(homePieceOfFurniture);
        }
        return arrayList;
    }

    private float[][] getReversedArray(float[][] fArray) {
        fArray = (float[][])fArray.clone();
        List list = Arrays.asList(fArray);
        Collections.reverse(list);
        return (float[][])list.toArray((T[])fArray);
    }

    private float getRoomHeightAt(float f, float f2) {
        double d = Double.POSITIVE_INFINITY;
        Room room = (Room)this.getUserData();
        Level level = room.getLevel();
        float f3 = level != null ? level.getElevation() : 0.0f;
        float f4 = f3 + (level == null ? this.home.getWallHeight() : level.getHeight());
        List<Level> list = this.home.getLevels();
        if (level == null || this.isLastLevel(level, list)) {
            Wall serializable = null;
            float[][] fArray = null;
            int n = -1;
            for (Wall serializable2 : this.home.getWalls()) {
                if (serializable2.getLevel() != null && !serializable2.getLevel().isViewable() || !serializable2.isAtLevel(level)) continue;
                float[][] f6 = serializable2.getPoints();
                for (int f7 = 0; f7 < f6.length; ++f7) {
                    double f8 = Point2D.distanceSq(f6[f7][0], f6[f7][1], f, f2);
                    if (!(f8 < d)) continue;
                    serializable = serializable2;
                    fArray = f6;
                    n = f7;
                    d = f8;
                }
            }
            if (serializable != null) {
                f4 = serializable.getLevel() == null ? 0.0f : serializable.getLevel().getElevation();
                Float f5 = serializable.getHeight();
                if (n == 0 || n == fArray.length - 1) {
                    f4 += f5 != null ? f5.floatValue() : this.home.getWallHeight();
                } else if (serializable.isTrapezoidal()) {
                    Float f6 = serializable.getArcExtent();
                    if (f6 == null || f6.floatValue() == 0.0f || n == fArray.length / 2 || n == fArray.length / 2 - 1) {
                        f4 += serializable.getHeightAtEnd().floatValue();
                    } else {
                        float f7 = serializable.getXArcCircleCenter();
                        float f8 = serializable.getYArcCircleCenter();
                        float f9 = fArray[n][0];
                        float f10 = fArray[n][1];
                        double d2 = Point2D.distance(f7, f8, f9, f10);
                        float f11 = serializable.getXStart();
                        float f12 = serializable.getYStart();
                        double d3 = Point2D.distance(f7, f8, f11, f12);
                        double d4 = (f9 - f7) * (f11 - f7) + (f10 - f8) * (f12 - f8);
                        double d5 = Math.acos(d4 /= d2 * d3) * (double)Math.signum(f6.floatValue());
                        f4 += (float)((double)f5.floatValue() + (double)(serializable.getHeightAtEnd().floatValue() - f5.floatValue()) * d5 / (double)f6.floatValue());
                    }
                } else {
                    f4 += f5 != null ? f5.floatValue() : this.home.getWallHeight();
                }
            }
        }
        return f4;
    }

    private boolean isLastLevel(Level level, List<Level> list) {
        return list.indexOf(level) == list.size() - 1;
    }

    private void updateRoomAppearance(boolean bl) {
        Room room = (Room)this.getUserData();
        boolean bl2 = room.getLevel() == null || room.getLevel().getElevation() <= 0.0f;
        this.updateRoomPartAppearance(((Shape3D)this.getChild(0)).getAppearance(), room.getFloorTexture(), bl, room.getFloorColor(), room.getFloorShininess(), room.isFloorVisible(), bl2);
        boolean bl3 = room.getLevel() == null;
        this.updateRoomPartAppearance(((Shape3D)this.getChild(1)).getAppearance(), room.getCeilingTexture(), bl, room.getCeilingColor(), room.getCeilingShininess(), room.isCeilingVisible(), bl3);
    }

    private void updateRoomPartAppearance(final Appearance appearance, HomeTexture homeTexture, boolean bl, Integer n, float f, boolean bl2, boolean bl3) {
        TextureManager textureManager;
        if (homeTexture == null) {
            appearance.setMaterial(this.getMaterial(n, n, f));
            appearance.setTexture(null);
        } else {
            appearance.setMaterial(this.getMaterial(DEFAULT_COLOR, DEFAULT_AMBIENT_COLOR, f));
            textureManager = TextureManager.getInstance();
            textureManager.loadTexture(homeTexture.getImage(), homeTexture.getAngle(), bl, new TextureManager.TextureObserver(){

                public void textureUpdated(Texture texture) {
                    texture = Room3D.this.getHomeTextureClone(texture, Room3D.this.home);
                    if (appearance.getTexture() != texture) {
                        appearance.setTexture(texture);
                    }
                }
            });
        }
        if (!bl3) {
            float f2 = this.home.getEnvironment().getWallsAlpha();
            TransparencyAttributes transparencyAttributes = appearance.getTransparencyAttributes();
            transparencyAttributes.setTransparency(f2);
            transparencyAttributes.setTransparencyMode(f2 == 0.0f ? 4 : 1);
        }
        textureManager = appearance.getRenderingAttributes();
        textureManager.setVisible(bl2);
    }

    static {
        MODULATE_TEXTURE_ATTRIBUTES.setTextureMode(2);
    }
}

