/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.snaptracer.impl.timeline;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import org.netbeans.lib.profiler.charts.ChartContext;
import org.netbeans.lib.profiler.charts.ChartItem;
import org.netbeans.lib.profiler.charts.ChartOverlay;
import org.netbeans.lib.profiler.charts.swing.Utils;
import org.netbeans.lib.profiler.charts.xy.synchronous.SynchronousXYItem;
import org.netbeans.modules.profiler.snaptracer.impl.swing.ColorIcon;
import org.netbeans.modules.profiler.snaptracer.impl.swing.LabelRenderer;
import org.netbeans.modules.profiler.snaptracer.impl.swing.LegendFont;
import org.netbeans.modules.profiler.snaptracer.impl.timeline.TimelineChart;
import org.netbeans.modules.profiler.snaptracer.impl.timeline.TimelineXYPainter;

final class TimelineLegendOverlay
extends ChartOverlay {
    private final TimelineChart chart;
    private final LabelRenderer painter;

    TimelineLegendOverlay(TimelineChart timelineChart) {
        this.chart = timelineChart;
        this.painter = new LabelRenderer();
        this.painter.setFont(new LegendFont());
        int n = this.painter.getFont().getSize() - 3;
        ColorIcon.setup(n, n, LegendFont.FOREGROUND_COLOR, LegendFont.BACKGROUND_COLOR);
    }

    private void setupPainter(String string, Color color) {
        this.painter.setText(string);
        this.painter.setIcon(ColorIcon.fromColor(color));
    }

    public void paint(Graphics graphics) {
        int n = this.chart.getRowsCount();
        for (int i = 0; i < n; ++i) {
            TimelineChart.Row row = this.chart.getRow(i);
            ChartContext chartContext = row.getContext();
            SynchronousXYItem[] synchronousXYItemArray = row.getItems();
            int n2 = 3;
            int n3 = -1;
            for (SynchronousXYItem synchronousXYItem : synchronousXYItemArray) {
                TimelineXYPainter timelineXYPainter = (TimelineXYPainter)this.chart.getPaintersModel().getPainter((ChartItem)synchronousXYItem);
                if (!timelineXYPainter.isPainting()) continue;
                this.setupPainter(synchronousXYItem.getName(), timelineXYPainter.getDefiningColor());
                Dimension dimension = this.painter.getPreferredSize();
                if (n3 == -1) {
                    n3 = Utils.checkedInt((double)chartContext.getViewportOffsetY()) + chartContext.getViewportHeight() - dimension.height - 1;
                }
                this.paint(graphics, n2, n3);
                n2 += dimension.width + 10;
            }
        }
    }

    private void paint(Graphics graphics, int n, int n2) {
        this.painter.setLocation(n, n2 + 1);
        this.painter.setForeground(LegendFont.BACKGROUND_COLOR);
        this.painter.paint(graphics);
        this.painter.setLocation(n, n2);
        this.painter.setForeground(LegendFont.FOREGROUND_COLOR);
        this.painter.setIcon(ColorIcon.BOTTOM_SHADOW);
        this.painter.paint(graphics);
    }

    public void invalidate() {
    }

    public void update(Graphics graphics) {
    }
}

