/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.results.memory;

import java.nio.ByteBuffer;
import java.util.logging.Level;
import org.netbeans.lib.profiler.results.AbstractDataFrameProcessor;
import org.netbeans.lib.profiler.results.ProfilingResultListener;
import org.netbeans.lib.profiler.results.locks.AbstractLockDataFrameProcessor;
import org.netbeans.lib.profiler.results.memory.MemoryProfilingResultsListener;

public class MemoryDataFrameProcessor
extends AbstractLockDataFrameProcessor {
    @Override
    public void doProcessDataFrame(ByteBuffer byteBuffer) {
        int c = -1;
        block12: while (byteBuffer.hasRemaining()) {
            byte by = byteBuffer.get();
            switch (by) {
                case 12: {
                    int n;
                    char c3 = byteBuffer.getChar();
                    long c4 = MemoryDataFrameProcessor.getObjSize(byteBuffer);
                    int n2 = MemoryDataFrameProcessor.getDepth(byteBuffer);
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.finest("Allocation stack trace: classId=" + c3 + ", objSize=" + c4 + ", depth=" + n2);
                    }
                    int[] l2 = new int[n2];
                    for (n = 0; n < n2; ++n) {
                        l2[n] = byteBuffer.getInt();
                    }
                    this.fireAllocStackTrace(c3, c4, l2);
                    continue block12;
                }
                case 14: {
                    char c2;
                    char c5 = byteBuffer.getChar();
                    char c6 = byteBuffer.getChar();
                    if (c6 > c2) {
                        c2 = c6;
                    }
                    long l = ((long)c5 & 0xFFFFL) << 48 | ((long)c6 & 0xFFFFL) << 32 | (long)byteBuffer.getInt() & 0xFFFFFFFFFFFFFFFFL;
                    long n3 = MemoryDataFrameProcessor.getObjSize(byteBuffer);
                    int n = MemoryDataFrameProcessor.getDepth(byteBuffer);
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.finest("Liveness stack trace: classId=" + c5 + ", objectId=" + l + ", objEpoch=" + c6 + ", objSize=" + n3 + ", depth=" + n);
                    }
                    int[] nArray = new int[n];
                    for (int i = 0; i < n; ++i) {
                        nArray[i] = byteBuffer.getInt();
                    }
                    this.fireLivenessStackTrace(c5, l, c6, n3, nArray);
                    continue block12;
                }
                case 15: {
                    char c2;
                    char c7 = byteBuffer.getChar();
                    char l = byteBuffer.getChar();
                    if (l > c2) {
                        c2 = l;
                    }
                    long string2 = ((long)c7 & 0xFFFFL) << 48 | ((long)l & 0xFFFFL) << 32 | (long)byteBuffer.getInt() & 0xFFFFFFFFFFFFFFFFL;
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.finest("GC Performed: classId=" + c7 + ", objectId=" + string2 + ", objEpoch=" + l);
                    }
                    this.fireGCPerformed(c7, string2, l);
                    continue block12;
                }
                case 10: {
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.finest("Profiling data reset");
                    }
                    this.fireReset();
                    continue block12;
                }
                case 29: {
                    char c8 = byteBuffer.getChar();
                    long string = MemoryDataFrameProcessor.getTimeStamp(byteBuffer);
                    int n2 = byteBuffer.getChar();
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.finest("Profile Point Hit " + c8 + ", threadId=" + c8 + ", timeStamp=" + string);
                    }
                    this.fireProfilingPoint(n2, c8, string);
                    continue block12;
                }
                case 13: {
                    this.currentThreadId = byteBuffer.getChar();
                    if (!LOGGER.isLoggable(Level.FINEST)) continue block12;
                    LOGGER.log(Level.FINEST, "Change current thread , tId={0}", this.currentThreadId);
                    continue block12;
                }
                case 11: {
                    char n = byteBuffer.getChar();
                    String string = MemoryDataFrameProcessor.getString(byteBuffer);
                    String l3 = MemoryDataFrameProcessor.getString(byteBuffer);
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.log(Level.FINEST, "Creating new thread , tId={0}", n);
                    }
                    this.fireNewThread(n, string, l3);
                    this.currentThreadId = n;
                    continue block12;
                }
                case 28: {
                    int l = byteBuffer.getInt();
                    String string = MemoryDataFrameProcessor.getString(byteBuffer);
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.log(Level.FINEST, "Creating new monitor , monitorId={0} , className={1}", new Object[]{Integer.toHexString(l), string});
                    }
                    this.fireNewMonitor(l, string);
                    continue block12;
                }
                case 22: 
                case 23: {
                    int n;
                    long l = MemoryDataFrameProcessor.getTimeStamp(byteBuffer);
                    long l4 = -1L;
                    int n3 = byteBuffer.getInt();
                    if (by == 22) {
                        n = byteBuffer.getInt();
                        if (LOGGER.isLoggable(Level.FINEST)) {
                            LOGGER.log(Level.FINEST, "Monitor entry , tId={0} , monitorId={1} , ownerId={2}", new Object[]{this.currentThreadId, Integer.toHexString(n3), n});
                        }
                        this.fireMonitorEntry(this.currentThreadId, l, l4, n3, n);
                    }
                    if (by != 23) continue block12;
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.log(Level.FINEST, "Monitor exit , tId={0} , monitorId={1}", new Object[]{this.currentThreadId, Integer.toHexString(n3)});
                    }
                    this.fireMonitorExit(this.currentThreadId, l, l4, n3);
                    continue block12;
                }
                case 5: {
                    long l = MemoryDataFrameProcessor.getTimeStamp(byteBuffer);
                    long l2 = MemoryDataFrameProcessor.getTimeStamp(byteBuffer);
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.log(Level.FINEST, "Adjust time , tId={0}", this.currentThreadId);
                    }
                    this.fireAdjustTime(this.currentThreadId, l, l2);
                    continue block12;
                }
            }
            LOGGER.severe("*** Profiler Engine: internal error: got unknown event type in MemoryDataFrameProcessor: " + by + " at " + byteBuffer.position());
        }
    }

    private void fireAllocStackTrace(final char c, final long l, final int[] nArray) {
        this.foreachListener(new AbstractDataFrameProcessor.ListenerFunctor(){

            @Override
            public void execute(ProfilingResultListener profilingResultListener) {
                try {
                    ((MemoryProfilingResultsListener)profilingResultListener).onAllocStackTrace(c, l, nArray);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
    }

    private void fireGCPerformed(final char c, final long l, final int n) {
        this.foreachListener(new AbstractDataFrameProcessor.ListenerFunctor(){

            @Override
            public void execute(ProfilingResultListener profilingResultListener) {
                ((MemoryProfilingResultsListener)profilingResultListener).onGcPerformed(c, l, n);
            }
        });
    }

    private void fireLivenessStackTrace(final char c, final long l, final int n, final long l2, final int[] nArray) {
        this.foreachListener(new AbstractDataFrameProcessor.ListenerFunctor(){

            @Override
            public void execute(ProfilingResultListener profilingResultListener) {
                ((MemoryProfilingResultsListener)profilingResultListener).onLivenessStackTrace(c, l, n, l2, nArray);
            }
        });
    }

    private static long getObjSize(ByteBuffer byteBuffer) {
        long l = ((long)byteBuffer.get() & 0xFFL) << 32 | ((long)byteBuffer.get() & 0xFFL) << 24 | ((long)byteBuffer.get() & 0xFFL) << 16 | ((long)byteBuffer.get() & 0xFFL) << 8 | (long)byteBuffer.get() & 0xFFL;
        return l;
    }

    private static int getDepth(ByteBuffer byteBuffer) {
        int n = (byteBuffer.get() & 0xFF) << 16 | (byteBuffer.get() & 0xFF) << 8 | byteBuffer.get() & 0xFF;
        return n;
    }
}

