/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk.details.jdk.image;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.modules.profiler.heapwalk.details.jdk.image.FieldAccessor;
import org.netbeans.modules.profiler.heapwalk.details.jdk.image.InstanceBuilder;

class InstanceBuilderRegistry {
    private final List<RegisteredBuilder> builders = new ArrayList<RegisteredBuilder>();

    public void register(String string, InstanceBuilder<?> instanceBuilder) {
        this.builders.add(new RegisteredBuilder(string, instanceBuilder));
    }

    public void register(Class<?> clazz, boolean bl, InstanceBuilder<?> instanceBuilder) {
        this.register(FieldAccessor.getClassMask(clazz, bl), instanceBuilder);
    }

    public <T> InstanceBuilder<? extends T> getBuilder(Instance instance, Class<T> clazz) {
        for (RegisteredBuilder registeredBuilder : this.builders) {
            if (!FieldAccessor.matchClassMask(instance, registeredBuilder.mask) || !clazz.isAssignableFrom(registeredBuilder.builder.getType())) continue;
            return registeredBuilder.builder;
        }
        return null;
    }

    public String[] getMasks(Class<?> ... classArray) {
        HashSet<String> hashSet = new HashSet<String>();
        for (RegisteredBuilder registeredBuilder : this.builders) {
            for (Class clazz : classArray) {
                if (!clazz.isAssignableFrom(registeredBuilder.builder.getType())) continue;
                hashSet.add(registeredBuilder.mask);
            }
        }
        return hashSet.toArray(new String[0]);
    }

    private static class RegisteredBuilder {
        private final String mask;
        private final InstanceBuilder<?> builder;

        public RegisteredBuilder(String string, InstanceBuilder<?> instanceBuilder) {
            this.mask = string;
            this.builder = instanceBuilder;
        }
    }
}

