#ifndef EFL_GENERATED_ELM_VIEW_LIST_HH
#define EFL_GENERATED_ELM_VIEW_LIST_HH

extern "C"
{
#include <Efl.h>
}
#include <Eo.hh>

#include <eo_cxx_interop.hh>

extern "C"
{
#include "elm_view_list.eo.h"
}

#include "eo_base.eo.hh"
#include <efl_model_base.eo.hh>
#include <eo_concrete.hh>
#include <string>

struct elm_view_list;

/// @cond EO_CXX_ABSTRACT
namespace eo_cxx {

struct elm_view_list
{
   /// @param[out] widget 
   ///
   void evas_object_get(Evas_Object ** widget_) const;

   /// @param property 
   /// @param part 
   ///
   void property_connect(::efl::eina::string_view property_, ::efl::eina::string_view part_) const;

   /// @param model 
   ///
   void model_set(::efl::model::base model_) const;

   void model_unset() const;

   /// @param[out] model 
   ///
   void model_get(::efl::eo::concrete* model_) const;

   template <typename F>
   ::efl::eo::signal_connection
   callback_model_selected_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (ELM_VIEW_LIST_EVENT_MODEL_SELECTED, priority_,
            &::efl::eo::_detail::event_callback<::elm_view_list, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm_view_list, function_type>,
         ELM_VIEW_LIST_EVENT_MODEL_SELECTED );
   }

   template <typename T>
   void
   callback_model_selected_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (ELM_VIEW_LIST_EVENT_MODEL_SELECTED, info));
   }



   static Eo_Class const* _eo_class()
   {
      return(ELM_VIEW_LIST_CLASS);
   }

   operator ::elm_view_list() const;
   operator ::elm_view_list&();
   operator ::elm_view_list const&() const;

   /// @cond LOCAL
   template <typename D>
   struct address_of
   {
      operator ::elm_view_list*() const { return static_cast<::elm_view_list*>(static_cast<D const*>(this)->p); }
      operator ::elm_view_list const*() const { return static_cast<::elm_view_list const*>(static_cast<D const*>(this)->p); }
   };

   template <typename D>
   struct address_const_of
   {
      operator ::elm_view_list const*() const { return static_cast<::elm_view_list const*>(static_cast<D const*>(this)->p); }
   };
   /// @endcond

private:

   /// @internal
   Eo* _concrete_eo_ptr() const
   {
      return static_cast<::efl::eo::concrete const*>(static_cast<void const*>(this))->_eo_ptr();
   }

};

}
/// @endcond

/// @brief Class elm_view_list
struct elm_view_list
      : ::efl::eo::concrete
      , EO_CXX_INHERIT(eo::base)
{
   /// @cond LOCAL
   struct _c_genlist_set
   {

      explicit _c_genlist_set(Evas_Object * genlist_, Elm_Genlist_Item_Type item_type_, ::efl::eina::string_view item_style_)
         : genlist_(genlist_), item_type_(item_type_), item_style_(item_style_)
      {}
      void operator()()
      {
         ::elm_view_list_genlist_set(genlist_, item_type_, ::efl::eolian::to_c(item_style_));
      }
      void register_ev_del_free_callback(Eo* _eoptr)
      {
         (void) _eoptr;
      }

      Evas_Object * genlist_;
      Elm_Genlist_Item_Type item_type_;
      ::efl::eina::string_view item_style_;
   };
   /// @endcond

   //@{
   /**
      @brief Constructs a new elm_view_list object.

      Constructs a new elm_view_list object. If you want this object to be a child
      of another Eo object, use an @ref efl::eo::parent expression, like the example.

      Since this class have a necessary constructor method, you must call it
      in the right place within this constructor parameters.

      Example:
      @code
      elm_view_list my_elm_view_list(efl::eo::parent = parent_object,
         my_elm_view_list.genlist_set(genlist_, item_type_, item_style_));
      @endcode

      @see elm_view_list::genlist_set
      @see elm_view_list(Eo* eo)
   */
   explicit elm_view_list(::efl::eo::parent_type _p, _c_genlist_set _c0)
      : elm_view_list(_ctors_call(_p, _c0))
   {}

   explicit elm_view_list(_c_genlist_set _c0)
      : elm_view_list(_ctors_call(::efl::eo::parent = nullptr, _c0))
   {}
   //@}

   /// @brief Eo Constructor.
   ///
   /// Constructs the object from an Eo* pointer stealing its ownership.
   ///
   /// @param eo The Eo object pointer.
   ///
   explicit elm_view_list(Eo* eo)
      : ::efl::eo::concrete(eo)
   {}

   /// @brief nullptr_t Constructor.
   ///
   /// Constructs an empty (null) object.
   ///
   explicit elm_view_list(std::nullptr_t)
      : ::efl::eo::concrete(nullptr)
   {}

   /// @brief Copy Constructor.
   ///
   elm_view_list(elm_view_list const& other)
      : elm_view_list(eo_ref(other._eo_ptr()))
   {}

   ~elm_view_list() {}

   /// @param genlist 
   /// @param item_type 
   /// @param item_style 
   ///
   static _c_genlist_set genlist_set(Evas_Object * genlist_, Elm_Genlist_Item_Type item_type_, ::efl::eina::string_view item_style_);

   /// @param[out] widget 
   ///
   void evas_object_get(Evas_Object ** widget_) const;

   /// @param property 
   /// @param part 
   ///
   void property_connect(::efl::eina::string_view property_, ::efl::eina::string_view part_) const;

   /// @param model 
   ///
   void model_set(::efl::model::base model_) const;

   void model_unset() const;

   /// @param[out] model 
   ///
   void model_get(::efl::eo::concrete* model_) const;

   template <typename F>
   ::efl::eo::signal_connection
   callback_callback_add_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (EO_BASE_EVENT_CALLBACK_ADD, priority_,
            &::efl::eo::_detail::event_callback<::elm_view_list, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm_view_list, function_type>,
         EO_BASE_EVENT_CALLBACK_ADD );
   }

   template <typename T>
   void
   callback_callback_add_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (EO_BASE_EVENT_CALLBACK_ADD, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_callback_del_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (EO_BASE_EVENT_CALLBACK_DEL, priority_,
            &::efl::eo::_detail::event_callback<::elm_view_list, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm_view_list, function_type>,
         EO_BASE_EVENT_CALLBACK_DEL );
   }

   template <typename T>
   void
   callback_callback_del_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (EO_BASE_EVENT_CALLBACK_DEL, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_del_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (EO_BASE_EVENT_DEL, priority_,
            &::efl::eo::_detail::event_callback<::elm_view_list, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm_view_list, function_type>,
         EO_BASE_EVENT_DEL );
   }

   template <typename T>
   void
   callback_del_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (EO_BASE_EVENT_DEL, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_model_selected_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (ELM_VIEW_LIST_EVENT_MODEL_SELECTED, priority_,
            &::efl::eo::_detail::event_callback<::elm_view_list, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm_view_list, function_type>,
         ELM_VIEW_LIST_EVENT_MODEL_SELECTED );
   }

   template <typename T>
   void
   callback_model_selected_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (ELM_VIEW_LIST_EVENT_MODEL_SELECTED, info));
   }



   static Eo_Class const* _eo_class()
   {
      return(ELM_VIEW_LIST_CLASS);
   }

   /// @cond LOCAL
   struct address_of
      : ::eo_cxx::elm_view_list::address_of<address_of>
      , ::eo_cxx::eo::base::address_of<address_of>
      , ::efl::eo::detail::concrete_address_of
   {
      explicit address_of(::elm_view_list* p)
         : ::efl::eo::detail::concrete_address_of(p)
      {}
   };
   address_of operator&() { return address_of(this); }

   struct address_const_of
      : ::eo_cxx::elm_view_list::address_const_of<address_const_of>
      , ::eo_cxx::eo::base::address_const_of<address_const_of>
      , ::efl::eo::detail::concrete_address_const_of
   {
      explicit address_const_of(::elm_view_list const* p)
         : ::efl::eo::detail::concrete_address_const_of(p)
      {}
   };
   address_const_of operator&() const { return address_const_of(this); }

   /// @endcond

private:

   /// @internal
   static Eo* _ctors_call(::efl::eo::parent_type _p, _c_genlist_set _c0)
   {
      Eo* _ret_eo = eo_add_ref(ELM_VIEW_LIST_CLASS, _p._eo_raw, _c0());

      _c0.register_ev_del_free_callback(_ret_eo);
      return _ret_eo;
   }

   /// @internal
   Eo* _concrete_eo_ptr() const { return _eo_ptr(); }
};

static_assert(sizeof(::elm_view_list) == sizeof(Eo*), "");
static_assert(std::is_standard_layout<::elm_view_list>::value, "");


#include "elm_view_list.eo.impl.hh"

#endif // EFL_GENERATED_ELM_VIEW_LIST_HH

