/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.glsof.common.lsof;

import net.sourceforge.glsof.common.model.Filter;
import net.sourceforge.glsof.common.model.Preferences;
import net.sourceforge.glsof.common.preferences.LsofParameterType;

public class LsofParametersBuilder {
    private static final String COMMAND = "lsof -F -T +c0";

    public String build(Preferences preferences) {
        StringBuilder sb1 = new StringBuilder(COMMAND);
        StringBuilder sb2 = new StringBuilder();
        for (Filter tv : preferences.getFilters()) {
            String type = tv.getType();
            boolean isPathType = type.equals(LsofParameterType.PATH.getId());
            LsofParameterType.getParameterType(type).appendParameter(isPathType ? sb2 : sb1, tv);
        }
        preferences.getOtherPreferences().toParameters(sb1);
        if (sb2.length() > 0) {
            sb1.append(" --").append((CharSequence)sb2);
        }
        return sb1.toString();
    }
}

