/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.glsof.common.main;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import net.sourceforge.glsof.common.main.Observer;
import net.sourceforge.glsof.common.utils.GButton;

public abstract class ActionButton {
    private List<Observer> _observers;
    private final JButton _button;

    protected abstract void execute();

    public ActionButton(List<Observer> observers, String iconPath, String toolTip) {
        this(iconPath, toolTip);
        this._observers = observers;
    }

    public ActionButton(String iconPath, String toolTip) {
        this._button = GButton.createTipButton(iconPath, toolTip);
        this._button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ActionButton.this.execute();
            }
        });
    }

    public JButton getButton() {
        return this._button;
    }

    protected ImageIcon getIcon(String icon) {
        return new ImageIcon(this.getClass().getResource(icon));
    }

    protected void notify(Observer.NOTIFY notify, Object ... params) {
        for (Observer observer : this._observers) {
            observer.update(notify, params);
        }
    }
}

