/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.services;

import java.io.File;
import java.io.IOException;
import javax.jnlp.FileContents;
import javax.jnlp.FileOpenService;
import javax.swing.JFileChooser;
import net.sourceforge.jnlp.security.SecurityDialogs;
import net.sourceforge.jnlp.services.ServiceUtil;
import net.sourceforge.jnlp.services.XFileContents;

class XFileOpenService
implements FileOpenService {
    protected XFileOpenService() {
    }

    @Override
    public FileContents openFileDialog(String pathHint, String[] extensions) throws IOException {
        if (ServiceUtil.checkAccess(SecurityDialogs.AccessType.READ_FILE, new Object[0])) {
            JFileChooser chooser = new JFileChooser();
            int chosen = chooser.showOpenDialog(null);
            if (chosen == 0) {
                return (FileContents)ServiceUtil.createPrivilegedProxy(FileContents.class, new XFileContents(chooser.getSelectedFile()));
            }
            return null;
        }
        return null;
    }

    @Override
    public FileContents[] openMultiFileDialog(String pathHint, String[] extensions) throws IOException {
        if (ServiceUtil.checkAccess(SecurityDialogs.AccessType.WRITE_FILE, new Object[0])) {
            JFileChooser chooser = new JFileChooser();
            chooser.setMultiSelectionEnabled(true);
            int chosen = chooser.showOpenDialog(null);
            if (chosen == 0) {
                File[] files = chooser.getSelectedFiles();
                int length = files.length;
                FileContents[] result = new FileContents[length];
                for (int i = 0; i < length; ++i) {
                    XFileContents xfile = new XFileContents(files[i]);
                    result[i] = (FileContents)ServiceUtil.createPrivilegedProxy(FileContents.class, xfile);
                }
                return result;
            }
            return null;
        }
        return null;
    }
}

