/*
 * Decompiled with CFR 0.152.
 */
package gnu.inet.http;

import gnu.inet.http.HTTPDateFormat;
import gnu.inet.util.LineInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class Headers
implements Map {
    static final DateFormat dateFormat = new HTTPDateFormat();
    private LinkedHashMap headers = new LinkedHashMap();

    @Override
    public int size() {
        return this.headers.size();
    }

    @Override
    public boolean isEmpty() {
        return this.headers.isEmpty();
    }

    @Override
    public boolean containsKey(Object object) {
        return this.headers.containsKey(new Header((String)object));
    }

    @Override
    public boolean containsValue(Object object) {
        return this.headers.containsValue(object);
    }

    public Object get(Object object) {
        return this.headers.get(new Header((String)object));
    }

    public String getValue(String string) {
        return (String)this.headers.get(new Header(string));
    }

    public int getIntValue(String string) {
        String string2 = this.getValue(string);
        if (string2 == null) {
            return -1;
        }
        try {
            return Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    public Date getDateValue(String string) {
        String string2 = this.getValue(string);
        if (string2 == null) {
            return null;
        }
        try {
            return dateFormat.parse(string2);
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public Object put(Object object, Object object2) {
        return this.headers.put(new Header((String)object), object2);
    }

    public Object remove(Object object) {
        return this.headers.remove(new Header((String)object));
    }

    public void putAll(Map map) {
        for (String string : map.keySet()) {
            String string2 = (String)map.get(string);
            this.headers.put(new Header(string), string2);
        }
    }

    @Override
    public void clear() {
        this.headers.clear();
    }

    public Set keySet() {
        Set set = this.headers.keySet();
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            linkedHashSet.add(((Header)iterator.next()).name);
        }
        return linkedHashSet;
    }

    public Collection values() {
        return this.headers.values();
    }

    public Set entrySet() {
        Set set = this.headers.entrySet();
        LinkedHashSet<HeaderEntry> linkedHashSet = new LinkedHashSet<HeaderEntry>();
        for (Map.Entry entry : set) {
            linkedHashSet.add(new HeaderEntry(entry));
        }
        return linkedHashSet;
    }

    @Override
    public boolean equals(Object object) {
        return this.headers.equals(object);
    }

    @Override
    public int hashCode() {
        return this.headers.hashCode();
    }

    public void parse(InputStream inputStream) throws IOException {
        LineInputStream lineInputStream = inputStream instanceof LineInputStream ? (LineInputStream)inputStream : new LineInputStream(inputStream);
        String string = null;
        StringBuffer stringBuffer = new StringBuffer();
        while (true) {
            String string2;
            if ((string2 = lineInputStream.readLine()) == null) {
                if (string == null) break;
                this.addValue(string, stringBuffer.toString());
                break;
            }
            int n = string2.length();
            if (n < 2) {
                if (string == null) break;
                this.addValue(string, stringBuffer.toString());
                break;
            }
            char c = string2.charAt(0);
            if (c == ' ' || c == '\t') {
                stringBuffer.append(string2.substring(0, n - 1));
                continue;
            }
            if (string != null) {
                this.addValue(string, stringBuffer.toString());
            }
            int n2 = string2.indexOf(58);
            string = string2.substring(0, n2);
            stringBuffer.setLength(0);
            while (++n2 < n && string2.charAt(n2) == ' ') {
            }
            stringBuffer.append(string2.substring(n2, n - 1));
        }
    }

    private void addValue(String string, String string2) {
        Header header = new Header(string);
        String string3 = (String)this.headers.get(header);
        if (string3 == null) {
            this.headers.put(header, string2);
        } else {
            this.headers.put(header, string3 + ", " + string2);
        }
    }

    static class HeaderEntry
    implements Map.Entry {
        final Map.Entry entry;

        HeaderEntry(Map.Entry entry) {
            this.entry = entry;
        }

        public Object getKey() {
            return ((Header)this.entry.getKey()).name;
        }

        public Object getValue() {
            return this.entry.getValue();
        }

        public Object setValue(Object object) {
            return this.entry.setValue(object);
        }

        @Override
        public int hashCode() {
            return this.entry.hashCode();
        }

        @Override
        public boolean equals(Object object) {
            return this.entry.equals(object);
        }

        public String toString() {
            return this.getKey().toString() + "=" + this.getValue();
        }
    }

    static class Header {
        final String name;

        Header(String string) {
            if (string == null || string.length() == 0) {
                throw new IllegalArgumentException(string);
            }
            this.name = string;
        }

        public int hashCode() {
            return this.name.toLowerCase().hashCode();
        }

        public boolean equals(Object object) {
            if (object instanceof Header) {
                return ((Header)object).name.equalsIgnoreCase(this.name);
            }
            return false;
        }

        public String toString() {
            return this.name;
        }
    }
}

