/*
 * Decompiled with CFR 0.152.
 */
package gnu.inet.nntp;

import gnu.inet.nntp.NNTPConnection;
import gnu.inet.nntp.PendingData;
import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class LineIterator
implements Iterator,
PendingData {
    static final String DOT = ".";
    boolean doneRead = false;
    NNTPConnection connection;
    String current;

    LineIterator(NNTPConnection nNTPConnection) {
        this.connection = nNTPConnection;
    }

    void doRead() throws IOException {
        if (this.doneRead) {
            return;
        }
        String string = this.connection.read();
        this.current = DOT.equals(string) ? null : string;
        this.doneRead = true;
    }

    @Override
    public boolean hasNext() {
        try {
            this.doRead();
        }
        catch (IOException iOException) {
            return false;
        }
        return this.current != null;
    }

    public Object next() {
        try {
            return this.nextLine();
        }
        catch (IOException iOException) {
            throw new NoSuchElementException("I/O error: " + iOException.getMessage());
        }
    }

    public String nextLine() throws IOException {
        this.doRead();
        if (this.current == null) {
            throw new NoSuchElementException();
        }
        this.doneRead = false;
        return this.current;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void readToEOF() throws IOException {
        do {
            this.doRead();
        } while (this.current != null);
    }
}

