/*
 * Decompiled with CFR 0.152.
 */
package gnu.inet.smtp;

import gnu.inet.smtp.ParameterList;
import gnu.inet.util.BASE64;
import gnu.inet.util.CRLFInputStream;
import gnu.inet.util.CRLFOutputStream;
import gnu.inet.util.EmptyX509TrustManager;
import gnu.inet.util.LineInputStream;
import gnu.inet.util.MessageOutputStream;
import gnu.inet.util.SaslCallbackHandler;
import gnu.inet.util.SaslCramMD5;
import gnu.inet.util.SaslInputStream;
import gnu.inet.util.SaslLogin;
import gnu.inet.util.SaslOutputStream;
import gnu.inet.util.SaslPlain;
import gnu.inet.util.TraceLevel;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.ProtocolException;
import java.net.Socket;
import java.net.SocketAddress;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;

public class SMTPConnection {
    public static final Level SMTP_TRACE = new TraceLevel("smtp");
    public static final int DEFAULT_PORT = 25;
    protected static final String MAIL_FROM = "MAIL FROM:";
    protected static final String RCPT_TO = "RCPT TO:";
    protected static final String SP = " ";
    protected static final String DATA = "DATA";
    protected static final String FINISH_DATA = "\n.";
    protected static final String RSET = "RSET";
    protected static final String VRFY = "VRFY";
    protected static final String EXPN = "EXPN";
    protected static final String HELP = "HELP";
    protected static final String NOOP = "NOOP";
    protected static final String QUIT = "QUIT";
    protected static final String HELO = "HELO";
    protected static final String EHLO = "EHLO";
    protected static final String AUTH = "AUTH";
    protected static final String STARTTLS = "STARTTLS";
    protected static final int INFO = 214;
    protected static final int READY = 220;
    protected static final int OK = 250;
    protected static final int OK_NOT_LOCAL = 251;
    protected static final int OK_UNVERIFIED = 252;
    protected static final int SEND_DATA = 354;
    protected static final int AMBIGUOUS = 553;
    public static final Logger logger = Logger.getLogger("gnu.inet.smtp");
    protected Socket socket;
    protected LineInputStream in;
    protected CRLFOutputStream out;
    protected String response;
    protected boolean continuation;
    protected String greeting;

    public SMTPConnection(String string) throws IOException {
        this(string, 25, 0, 0, false, null);
    }

    public SMTPConnection(String string, int n) throws IOException {
        this(string, n, 0, 0, false, null);
    }

    public SMTPConnection(String string, int n, int n2, int n3) throws IOException {
        this(string, n, n2, n3, false, null);
    }

    public SMTPConnection(String string, int n, int n2, int n3, boolean bl, TrustManager trustManager) throws IOException {
        this(string, n, n2, n3, bl, trustManager, true);
    }

    public SMTPConnection(String string, int n, int n2, int n3, boolean bl, TrustManager trustManager, boolean bl2) throws IOException {
        Object object;
        Object object2;
        if (n <= 0) {
            n = 25;
        }
        this.response = null;
        this.continuation = false;
        try {
            this.socket = new Socket();
            object2 = new InetSocketAddress(string, n);
            if (n2 > 0) {
                this.socket.connect((SocketAddress)object2, n2);
            } else {
                this.socket.connect((SocketAddress)object2);
            }
            if (n3 > 0) {
                this.socket.setSoTimeout(n3);
            }
            if (bl) {
                object = this.getSSLSocketFactory(trustManager);
                SSLSocket sSLSocket = (SSLSocket)((SSLSocketFactory)object).createSocket(this.socket, string, n, true);
                String[] stringArray = new String[]{"TLSv1", "SSLv3"};
                sSLSocket.setEnabledProtocols(stringArray);
                sSLSocket.setUseClientMode(true);
                sSLSocket.startHandshake();
                this.socket = sSLSocket;
            }
        }
        catch (GeneralSecurityException generalSecurityException) {
            IOException iOException = new IOException();
            iOException.initCause(generalSecurityException);
            throw iOException;
        }
        object2 = this.socket.getInputStream();
        object2 = new BufferedInputStream((InputStream)object2);
        object2 = new CRLFInputStream((InputStream)object2);
        this.in = new LineInputStream((InputStream)object2);
        object = this.socket.getOutputStream();
        object = new BufferedOutputStream((OutputStream)object);
        this.out = new CRLFOutputStream((OutputStream)object);
        if (bl2) {
            this.init();
        }
    }

    public void init() throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        do {
            if (this.getResponse() != 220) {
                throw new ProtocolException(this.response);
            }
            if (bl) {
                stringBuffer.append('\n');
            } else {
                bl = true;
            }
            stringBuffer.append(this.response);
        } while (this.continuation);
        this.greeting = stringBuffer.toString();
    }

    public String getGreeting() {
        return this.greeting;
    }

    public String getLastResponse() {
        return this.response;
    }

    public boolean mailFrom(String string, ParameterList parameterList) throws IOException {
        StringBuffer stringBuffer = new StringBuffer(MAIL_FROM);
        stringBuffer.append('<');
        stringBuffer.append(string);
        stringBuffer.append('>');
        if (parameterList != null) {
            stringBuffer.append(SP);
            stringBuffer.append(parameterList);
        }
        this.send(stringBuffer.toString());
        switch (this.getAllResponses()) {
            case 250: 
            case 251: 
            case 252: {
                return true;
            }
        }
        return false;
    }

    public boolean rcptTo(String string, ParameterList parameterList) throws IOException {
        StringBuffer stringBuffer = new StringBuffer(RCPT_TO);
        stringBuffer.append('<');
        stringBuffer.append(string);
        stringBuffer.append('>');
        if (parameterList != null) {
            stringBuffer.append(SP);
            stringBuffer.append(parameterList);
        }
        this.send(stringBuffer.toString());
        switch (this.getAllResponses()) {
            case 250: 
            case 251: 
            case 252: {
                return true;
            }
        }
        return false;
    }

    public OutputStream data() throws IOException {
        this.send(DATA);
        switch (this.getAllResponses()) {
            case 354: {
                return new MessageOutputStream(this.out);
            }
        }
        throw new ProtocolException(this.response);
    }

    public boolean finishData() throws IOException {
        this.send(FINISH_DATA);
        switch (this.getAllResponses()) {
            case 250: {
                return true;
            }
        }
        return false;
    }

    public void rset() throws IOException {
        this.send(RSET);
        if (this.getAllResponses() != 250) {
            throw new ProtocolException(this.response);
        }
    }

    public List vrfy(String string) throws IOException {
        String string2 = "VRFY " + string;
        this.send(string2);
        ArrayList<String> arrayList = new ArrayList<String>();
        block3: do {
            switch (this.getResponse()) {
                case 250: 
                case 553: {
                    this.response = this.response.trim();
                    if (this.response.indexOf(64) != -1) {
                        arrayList.add(this.response);
                        break;
                    }
                    if (this.response.indexOf(60) != -1) {
                        arrayList.add(this.response);
                        break;
                    }
                    if (this.response.indexOf(32) != -1) continue block3;
                    arrayList.add(this.response);
                    break;
                }
                default: {
                    return null;
                }
            }
        } while (this.continuation);
        return Collections.unmodifiableList(arrayList);
    }

    public List expn(String string) throws IOException {
        String string2 = "EXPN " + string;
        this.send(string2);
        ArrayList<String> arrayList = new ArrayList<String>();
        do {
            switch (this.getResponse()) {
                case 250: {
                    this.response = this.response.trim();
                    arrayList.add(this.response);
                    break;
                }
                default: {
                    return null;
                }
            }
        } while (this.continuation);
        return Collections.unmodifiableList(arrayList);
    }

    public List help(String string) throws IOException {
        String string2 = string == null ? HELP : "HELP " + string;
        this.send(string2);
        ArrayList<String> arrayList = new ArrayList<String>();
        do {
            switch (this.getResponse()) {
                case 214: {
                    arrayList.add(this.response);
                    break;
                }
                default: {
                    return null;
                }
            }
        } while (this.continuation);
        return Collections.unmodifiableList(arrayList);
    }

    public void noop() throws IOException {
        this.send(NOOP);
        this.getAllResponses();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void quit() throws IOException {
        try {
            this.send(QUIT);
            this.getAllResponses();
        }
        catch (IOException iOException) {
        }
        finally {
            this.socket.close();
        }
    }

    public boolean helo(String string) throws IOException {
        String string2 = "HELO " + string;
        this.send(string2);
        return this.getAllResponses() == 250;
    }

    public List ehlo(String string) throws IOException {
        String string2 = "EHLO " + string;
        this.send(string2);
        ArrayList<String> arrayList = new ArrayList<String>();
        do {
            switch (this.getResponse()) {
                case 250: {
                    arrayList.add(this.response);
                    break;
                }
                default: {
                    return null;
                }
            }
        } while (this.continuation);
        return Collections.unmodifiableList(arrayList);
    }

    protected SSLSocketFactory getSSLSocketFactory(TrustManager trustManager) throws GeneralSecurityException {
        if (trustManager == null) {
            trustManager = new EmptyX509TrustManager();
        }
        SSLContext sSLContext = SSLContext.getInstance("TLS");
        TrustManager[] trustManagerArray = new TrustManager[]{trustManager};
        sSLContext.init(null, trustManagerArray, null);
        return sSLContext.getSocketFactory();
    }

    public boolean starttls() throws IOException {
        return this.starttls(new EmptyX509TrustManager());
    }

    public boolean starttls(TrustManager trustManager) throws IOException {
        try {
            SSLSocketFactory sSLSocketFactory = this.getSSLSocketFactory(trustManager);
            this.send(STARTTLS);
            if (this.getAllResponses() != 220) {
                return false;
            }
            String string = this.socket.getInetAddress().getHostName();
            int n = this.socket.getPort();
            SSLSocket sSLSocket = (SSLSocket)sSLSocketFactory.createSocket(this.socket, string, n, true);
            String[] stringArray = new String[]{"TLSv1", "SSLv3"};
            sSLSocket.setEnabledProtocols(stringArray);
            sSLSocket.setUseClientMode(true);
            sSLSocket.startHandshake();
            InputStream inputStream = sSLSocket.getInputStream();
            inputStream = new BufferedInputStream(inputStream);
            inputStream = new CRLFInputStream(inputStream);
            this.in = new LineInputStream(inputStream);
            OutputStream outputStream = sSLSocket.getOutputStream();
            outputStream = new BufferedOutputStream(outputStream);
            this.out = new CRLFOutputStream(outputStream);
            return true;
        }
        catch (GeneralSecurityException generalSecurityException) {
            return false;
        }
    }

    public boolean authenticate(String string, String string2, String string3) throws IOException {
        try {
            Object object;
            String[] stringArray = new String[]{string};
            SaslCallbackHandler saslCallbackHandler = new SaslCallbackHandler(string2, string3);
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("gnu.crypto.sasl.username", string2);
            hashMap.put("gnu.crypto.sasl.password", string3);
            SaslClient saslClient = Sasl.createSaslClient(stringArray, null, "smtp", this.socket.getInetAddress().getHostName(), hashMap, saslCallbackHandler);
            if (saslClient == null) {
                if ("LOGIN".equalsIgnoreCase(string)) {
                    saslClient = new SaslLogin(string2, string3);
                } else if ("PLAIN".equalsIgnoreCase(string)) {
                    saslClient = new SaslPlain(string2, string3);
                } else if ("CRAM-MD5".equalsIgnoreCase(string)) {
                    saslClient = new SaslCramMD5(string2, string3);
                } else {
                    return false;
                }
            }
            StringBuffer stringBuffer = new StringBuffer(AUTH);
            stringBuffer.append(' ');
            stringBuffer.append(string);
            if (saslClient.hasInitialResponse()) {
                stringBuffer.append(' ');
                object = saslClient.evaluateChallenge(new byte[0]);
                if (((byte[])object).length == 0) {
                    stringBuffer.append('=');
                } else {
                    stringBuffer.append(new String(BASE64.encode(object), "US-ASCII"));
                }
            }
            this.send(stringBuffer.toString());
            block9: while (true) {
                switch (this.getAllResponses()) {
                    case 334: {
                        Object object2;
                        Object object3;
                        try {
                            object = this.response.getBytes("US-ASCII");
                            object3 = BASE64.decode(object);
                            object2 = saslClient.evaluateChallenge((byte[])object3);
                            byte[] byArray = BASE64.encode(object2);
                            this.out.write(byArray);
                            this.out.write(13);
                            this.out.flush();
                            logger.log(SMTP_TRACE, "> " + new String(byArray, "US-ASCII"));
                        }
                        catch (SaslException saslException) {
                            this.out.write(42);
                            this.out.write(13);
                            this.out.flush();
                            logger.log(SMTP_TRACE, "> *");
                        }
                        continue block9;
                    }
                    case 235: {
                        Object object2;
                        Object object3;
                        object = (String)saslClient.getNegotiatedProperty("javax.security.sasl.qop");
                        if ("auth-int".equalsIgnoreCase((String)object) || "auth-conf".equalsIgnoreCase((String)object)) {
                            object3 = this.socket.getInputStream();
                            object3 = new BufferedInputStream((InputStream)object3);
                            object3 = new SaslInputStream(saslClient, (InputStream)object3);
                            object3 = new CRLFInputStream((InputStream)object3);
                            this.in = new LineInputStream((InputStream)object3);
                            object2 = this.socket.getOutputStream();
                            object2 = new BufferedOutputStream((OutputStream)object2);
                            object2 = new SaslOutputStream(saslClient, (OutputStream)object2);
                            this.out = new CRLFOutputStream((OutputStream)object2);
                        }
                        return true;
                    }
                }
                break;
            }
            return false;
        }
        catch (SaslException saslException) {
            logger.log(SMTP_TRACE, saslException.getMessage(), saslException);
            return false;
        }
        catch (RuntimeException runtimeException) {
            logger.log(SMTP_TRACE, runtimeException.getMessage(), runtimeException);
            return false;
        }
    }

    protected void send(String string) throws IOException {
        logger.log(SMTP_TRACE, "> " + string);
        this.out.write(string.getBytes("US-ASCII"));
        this.out.write(13);
        this.out.flush();
    }

    protected int getResponse() throws IOException {
        String string = null;
        try {
            string = this.in.readLine();
            if (string.length() < 4) {
                string = string + '\n' + this.in.readLine();
            }
            logger.log(SMTP_TRACE, "< " + string);
            int n = Integer.parseInt(string.substring(0, 3));
            this.continuation = string.charAt(3) == '-';
            this.response = string.substring(4);
            return n;
        }
        catch (NumberFormatException numberFormatException) {
            throw new ProtocolException("Unexpected response: " + string);
        }
    }

    protected int getAllResponses() throws IOException {
        int n;
        boolean bl = false;
        int n2 = n = this.getResponse();
        while (this.continuation) {
            n = this.getResponse();
            if (n == n2) continue;
            bl = true;
        }
        if (bl) {
            throw new ProtocolException("Conflicting response codes");
        }
        return n;
    }
}

