/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.SyncFailedException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class FileDescriptor {
    private int fd = -1;
    private long handle = -1L;
    private long fp = 0L;
    protected InputStream slave = null;
    private int useCount = 0;
    public static final FileDescriptor in = new FileDescriptor(0);
    public static final FileDescriptor out = new FileDescriptor(1);
    public static final FileDescriptor err = new FileDescriptor(2);
    private List parents = null;
    private boolean closed = false;

    public FileDescriptor() {
    }

    private FileDescriptor(int fd) {
        this();
        this.fd = fd;
    }

    public boolean valid() {
        return this.fd != -1 || this.handle != -1L || this.fp != 0L || this.slave != null;
    }

    public native void sync() throws SyncFailedException;

    private static native void initIDs();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int incrementAndGetUseCount() {
        FileDescriptor fileDescriptor = this;
        synchronized (fileDescriptor) {
            ++this.useCount;
            return this.useCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int decrementAndGetUseCount() {
        FileDescriptor fileDescriptor = this;
        synchronized (fileDescriptor) {
            --this.useCount;
            return this.useCount;
        }
    }

    synchronized void attach(Closeable c) {
        if (this.parents == null) {
            this.parents = new ArrayList();
        }
        this.parents.add(c);
    }

    synchronized void closeAll(Closeable releaser) throws IOException {
        if (!this.closed) {
            IOException ex = null;
            this.closed = true;
            Iterator it = this.parents.iterator();
            while (it.hasNext()) {
                Closeable c = (Closeable)it.next();
                try {
                    c.close();
                }
                catch (IOException ioe) {
                    if (ex == null) continue;
                    ex = ioe;
                }
            }
            releaser.close();
            if (ex != null) {
                throw ex;
            }
        }
    }

    static {
        FileDescriptor.initIDs();
    }
}

