'''OpenGL extension EXT.texture_shared_exponent

This module customises the behaviour of the 
OpenGL.raw.GL.EXT.texture_shared_exponent to provide a more 
Python-friendly API

Overview (from the spec)
	
	Existing texture formats provide either fixed-point formats with
	limited range and precision but with compact encodings (allowing 32
	or fewer bits per multi-component texel), or floating-point formats
	with tremendous range and precision but without compact encodings
	(typically 16 or 32 bits per component).
	
	This extension adds a new packed format and new internal texture
	format for encoding 3-component vectors (typically RGB colors) with
	a single 5-bit exponent (biased up by 15) and three 9-bit mantissas
	for each respective component.  There is no sign bit so all three
	components must be non-negative.  The fractional mantissas are
	stored without an implied 1 to the left of the decimal point.
	Neither infinity nor not-a-number (NaN) are representable in this
	shared exponent format.
	
	This 32 bits/texel shared exponent format is particularly well-suited
	to high dynamic range (HDR) applications where light intensity is
	typically stored as non-negative red, green, and blue components
	with considerable range.

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/EXT/texture_shared_exponent.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
import ctypes
from OpenGL.raw.GL import _types, _glgets
from OpenGL.raw.GL.EXT.texture_shared_exponent import *
from OpenGL.raw.GL.EXT.texture_shared_exponent import _EXTENSION_NAME

def glInitTextureSharedExponentEXT():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )


### END AUTOGENERATED SECTION