/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.internal.gtk.OS;

public class FileTransfer
extends ByteArrayTransfer {
    private static FileTransfer _instance = new FileTransfer();
    private static final String URI_LIST = "text/uri-list";
    private static final int URI_LIST_ID = FileTransfer.registerType("text/uri-list");
    private static final String GNOME_LIST = "x-special/gnome-copied-files";
    private static final int GNOME_LIST_ID = FileTransfer.registerType("x-special/gnome-copied-files");

    private FileTransfer() {
    }

    public static FileTransfer getInstance() {
        return _instance;
    }

    @Override
    public void javaToNative(Object object, TransferData transferData) {
        int n;
        byte[] byArray;
        byte[] byArray2;
        boolean bl;
        transferData.result = 0;
        if (!this.checkFile(object) || !this.isSupportedType(transferData)) {
            DND.error(2003);
        }
        boolean bl2 = bl = transferData.type == GNOME_LIST_ID;
        if (bl) {
            byArray2 = new byte[]{99, 111, 112, 121};
            byArray = new byte[]{10};
        } else {
            byArray2 = new byte[]{};
            byArray = new byte[]{13, 10};
        }
        String[] stringArray = (String[])object;
        for (n = 0; n < stringArray.length; ++n) {
            int n2;
            String string = stringArray[n];
            if (string == null || (n2 = string.length()) == 0) continue;
            char[] cArray = new char[n2];
            string.getChars(0, n2, cArray, 0);
            int[] nArray = new int[1];
            int n3 = OS.g_utf16_to_utf8(cArray, cArray.length, null, null, nArray);
            if (nArray[0] != 0 || n3 == 0) continue;
            int n4 = OS.g_filename_from_utf8(n3, -1, null, null, nArray);
            OS.g_free(n3);
            if (nArray[0] != 0 || n4 == 0) continue;
            int n5 = OS.g_filename_to_uri(n4, 0, nArray);
            OS.g_free(n4);
            if (nArray[0] != 0 || n5 == 0) continue;
            n2 = OS.strlen(n5);
            byte[] byArray3 = new byte[n2];
            OS.memmove(byArray3, n5, n2);
            OS.g_free(n5);
            int n6 = byArray2.length > 0 ? byArray2.length + byArray.length + byArray3.length : byArray3.length;
            byte[] byArray4 = new byte[n6];
            int n7 = 0;
            if (byArray2.length > 0) {
                System.arraycopy(byArray2, 0, byArray4, 0, byArray2.length);
                System.arraycopy(byArray, 0, byArray4, n7 += byArray2.length, byArray.length);
                n7 += byArray.length;
            }
            System.arraycopy(byArray3, 0, byArray4, n7, byArray3.length);
            byArray2 = byArray4;
        }
        if (byArray2.length == 0) {
            return;
        }
        n = OS.g_malloc(byArray2.length + 1);
        OS.memset(n, 0, byArray2.length + 1);
        OS.memmove(n, byArray2, byArray2.length);
        transferData.pValue = n;
        transferData.length = byArray2.length;
        transferData.format = 8;
        transferData.result = 1;
    }

    @Override
    public Object nativeToJava(TransferData transferData) {
        int[] nArray;
        int n;
        int n2;
        if (!this.isSupportedType(transferData) || transferData.pValue == 0 || transferData.length <= 0) {
            return null;
        }
        int n3 = transferData.length;
        byte[] byArray = new byte[n3];
        OS.memmove(byArray, transferData.pValue, n3);
        boolean bl = transferData.type == GNOME_LIST_ID;
        int n4 = bl ? 1 : 2;
        int[] nArray2 = new int[]{};
        int n5 = 0;
        for (n2 = 0; n2 < byArray.length - 1; ++n2) {
            int n6 = bl ? (byArray[n2] == 10 ? 1 : 0) : (n = byArray[n2] == 13 && byArray[n2 + 1] == 10 ? 1 : 0);
            if (n == 0) continue;
            if (!bl || n5 != 0) {
                int n7 = n2 - n5;
                int n8 = OS.g_malloc(n7 + 1);
                byte[] byArray2 = new byte[n7 + 1];
                System.arraycopy(byArray, n5, byArray2, 0, n7);
                OS.memmove(n8, byArray2, n7 + 1);
                nArray = new int[nArray2.length + 1];
                System.arraycopy(nArray2, 0, nArray, 0, nArray2.length);
                nArray[nArray2.length] = n8;
                nArray2 = nArray;
            }
            n5 = n2 + n4;
        }
        if (n5 < byArray.length - n4) {
            n2 = byArray.length - n5;
            n = OS.g_malloc(n2 + 1);
            byte[] byArray3 = new byte[n2 + 1];
            System.arraycopy(byArray, n5, byArray3, 0, n2);
            OS.memmove(n, byArray3, n2 + 1);
            int[] nArray3 = new int[nArray2.length + 1];
            System.arraycopy(nArray2, 0, nArray3, 0, nArray2.length);
            nArray3[nArray2.length] = n;
            nArray2 = nArray3;
        }
        String[] stringArray = new String[]{};
        for (n = 0; n < nArray2.length; ++n) {
            int[] nArray4 = new int[1];
            int n9 = OS.g_filename_from_uri(nArray2[n], null, nArray4);
            OS.g_free(nArray2[n]);
            if (nArray4[0] != 0 || n9 == 0) continue;
            int n10 = OS.g_filename_to_utf8(n9, -1, null, null, null);
            if (n10 == 0) {
                n10 = OS.g_filename_display_name(n9);
            }
            if (n9 != n10) {
                OS.g_free(n9);
            }
            if (n10 == 0) continue;
            nArray = new int[1];
            int n11 = OS.g_utf8_to_utf16(n10, -1, null, nArray, null);
            OS.g_free(n10);
            if (n11 == 0) continue;
            n3 = nArray[0];
            char[] cArray = new char[n3];
            OS.memmove(cArray, n11, n3 * 2);
            OS.g_free(n11);
            String string = new String(cArray);
            String[] stringArray2 = new String[stringArray.length + 1];
            System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
            stringArray2[stringArray.length] = string;
            stringArray = stringArray2;
        }
        if (stringArray.length == 0) {
            return null;
        }
        return stringArray;
    }

    @Override
    protected int[] getTypeIds() {
        return new int[]{URI_LIST_ID, GNOME_LIST_ID};
    }

    @Override
    protected String[] getTypeNames() {
        return new String[]{URI_LIST, GNOME_LIST};
    }

    boolean checkFile(Object object) {
        if (object == null || !(object instanceof String[]) || ((String[])object).length == 0) {
            return false;
        }
        String[] stringArray = (String[])object;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] != null && stringArray[i].length() != 0) continue;
            return false;
        }
        return true;
    }

    @Override
    protected boolean validate(Object object) {
        return this.checkFile(object);
    }
}

