/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import java.util.Arrays;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SegmentListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.cairo.Cairo;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.GdkEvent;
import org.eclipse.swt.internal.gtk.GdkEventButton;
import org.eclipse.swt.internal.gtk.GdkEventFocus;
import org.eclipse.swt.internal.gtk.GdkEventKey;
import org.eclipse.swt.internal.gtk.GdkRGBA;
import org.eclipse.swt.internal.gtk.GdkRectangle;
import org.eclipse.swt.internal.gtk.GtkBorder;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.internal.gtk.PangoRectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.TypedListener;

public class Text
extends Scrollable {
    int bufferHandle;
    int imContext;
    int tabs = 8;
    int lastEventTime = 0;
    int gdkEventKey = 0;
    int fixStart = -1;
    int fixEnd = -1;
    boolean doubleClick;
    String message = "";
    static final char LTR_MARK = '\u200e';
    static final char RTL_MARK = '\u200f';
    int[] segments;
    static final int ITER_SIZEOF = OS.GtkTextIter_sizeof();
    static final int SPACE_FOR_CURSOR = 1;
    public static final int LIMIT = Integer.MAX_VALUE;
    public static final String DELIMITER = "\n";

    public Text(Composite composite, int n) {
        super(composite, Text.checkStyle(n));
        if ((n & 0x80) != 0) {
            if ((n & 0x100) != 0) {
                this.style |= 0x100;
                OS.gtk_entry_set_icon_from_icon_name(this.handle, 1, OS.GTK_NAMED_ICON_CLEAR);
                OS.gtk_entry_set_icon_sensitive(this.handle, 1, false);
            }
            if ((n & 0x200) != 0) {
                this.style |= 0x200;
                OS.gtk_entry_set_icon_from_icon_name(this.handle, 0, OS.GTK_NAMED_ICON_FIND);
            }
        }
    }

    static int checkStyle(int n) {
        if ((n & 0x80) != 0) {
            n |= 0x804;
            n &= 0xFFBFFFFF;
        }
        if ((n & 4) != 0 && (n & 2) != 0) {
            n &= 0xFFFFFFFD;
        }
        if (((n = Text.checkBits(n, 16384, 0x1000000, 131072, 0, 0, 0)) & 4) != 0) {
            n &= 0xFFFFFCBF;
        }
        if ((n & 0x40) != 0) {
            n |= 2;
            n &= 0xFFFFFEFF;
        }
        if ((n & 2) != 0) {
            n &= 0xFFBFFFFF;
        }
        if ((n & 6) != 0) {
            return n;
        }
        if ((n & 0x300) != 0) {
            return n | 2;
        }
        return n | 4;
    }

    @Override
    void createHandle(int n) {
        this.state |= 0x28;
        if ((this.style & 8) != 0 && this.applyThemeBackground() == 1) {
            this.state |= 0x10000;
        }
        this.fixedHandle = OS.g_object_new(this.display.gtk_fixed_get_type(), 0);
        if (this.fixedHandle == 0) {
            this.error(2);
        }
        OS.gtk_widget_set_has_window(this.fixedHandle, true);
        if ((this.style & 4) != 0) {
            this.handle = OS.gtk_entry_new();
            if (this.handle == 0) {
                this.error(2);
            }
            OS.gtk_container_add(this.fixedHandle, this.handle);
            OS.gtk_editable_set_editable(this.handle, (this.style & 8) == 0);
            OS.gtk_entry_set_has_frame(this.handle, (this.style & 0x800) != 0);
            OS.gtk_entry_set_visibility(this.handle, (this.style & 0x400000) == 0);
            float f = 0.0f;
            if ((this.style & 0x1000000) != 0) {
                f = 0.5f;
            }
            if ((this.style & 0x20000) != 0) {
                f = 1.0f;
            }
            if (f > 0.0f) {
                OS.gtk_entry_set_alignment(this.handle, f);
            }
        } else {
            this.scrolledHandle = OS.gtk_scrolled_window_new(0, 0);
            if (this.scrolledHandle == 0) {
                this.error(2);
            }
            this.handle = OS.gtk_text_view_new();
            if (this.handle == 0) {
                this.error(2);
            }
            this.bufferHandle = OS.gtk_text_view_get_buffer(this.handle);
            if (this.bufferHandle == 0) {
                this.error(2);
            }
            OS.gtk_container_add(this.fixedHandle, this.scrolledHandle);
            OS.gtk_container_add(this.scrolledHandle, this.handle);
            OS.gtk_text_view_set_editable(this.handle, (this.style & 8) == 0);
            if ((this.style & 0x40) != 0) {
                OS.gtk_text_view_set_wrap_mode(this.handle, 3);
            }
            int n2 = (this.style & 0x100) != 0 ? 0 : 2;
            int n3 = (this.style & 0x200) != 0 ? 0 : 2;
            OS.gtk_scrolled_window_set_policy(this.scrolledHandle, n2, n3);
            if ((this.style & 0x800) != 0) {
                OS.gtk_scrolled_window_set_shadow_type(this.scrolledHandle, 3);
            }
            int n4 = 0;
            if ((this.style & 0x1000000) != 0) {
                n4 = 2;
            }
            if ((this.style & 0x20000) != 0) {
                n4 = 1;
            }
            OS.gtk_text_view_set_justification(this.handle, n4);
        }
        if (OS.GTK3) {
            this.imContext = OS.imContextLast();
            if ((this.style & 4) != 0) {
                OS.gtk_entry_set_width_chars(this.handle, 6);
            }
            this.setFontDescription(this.defaultFont().handle);
        }
    }

    @Override
    int applyThemeBackground() {
        return this.backgroundAlpha == 0 || (this.style & 0xB00) == 0 ? 1 : 0;
    }

    @Override
    void createWidget(int n) {
        super.createWidget(n);
        this.doubleClick = true;
    }

    public void addModifyListener(ModifyListener modifyListener) {
        this.checkWidget();
        if (modifyListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(modifyListener);
        this.addListener(24, typedListener);
    }

    public void addSegmentListener(SegmentListener segmentListener) {
        this.checkWidget();
        if (segmentListener == null) {
            this.error(4);
        }
        this.addListener(49, new TypedListener(segmentListener));
        this.clearSegments(true);
        this.applySegments();
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    public void addVerifyListener(VerifyListener verifyListener) {
        this.checkWidget();
        if (verifyListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(verifyListener);
        this.addListener(25, typedListener);
    }

    public void append(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        byte[] byArray = Converter.wcsToMbcs(null, string, false);
        this.clearSegments(true);
        if ((this.style & 4) != 0) {
            OS.gtk_editable_insert_text(this.handle, byArray, byArray.length, new int[]{-1});
            OS.gtk_editable_set_position(this.handle, -1);
        } else {
            byte[] byArray2 = new byte[ITER_SIZEOF];
            OS.gtk_text_buffer_get_end_iter(this.bufferHandle, byArray2);
            OS.gtk_text_buffer_insert(this.bufferHandle, byArray2, byArray, byArray.length);
            OS.gtk_text_buffer_place_cursor(this.bufferHandle, byArray2);
            int n = OS.gtk_text_buffer_get_insert(this.bufferHandle);
            OS.gtk_text_view_scroll_mark_onscreen(this.handle, n);
        }
        this.applySegments();
    }

    void applySegments() {
        int n;
        String string;
        if (this.isDisposed() || !this.hooks(49) && !this.filters(49)) {
            return;
        }
        Event event = new Event();
        event.text = string = this.getText();
        event.segments = this.segments;
        this.sendEvent(49, event);
        this.segments = event.segments;
        if (this.segments == null) {
            return;
        }
        int n2 = this.segments.length;
        if (n2 == 0) {
            return;
        }
        int n3 = n = string == null ? 0 : string.length();
        for (int i = 1; i < n2; ++i) {
            if (event.segments[i] >= event.segments[i - 1] && event.segments[i] <= n) continue;
            this.error(5);
        }
        char[] cArray = event.segmentsChars;
        char[] cArray2 = new char[]{this.getOrientation() == 0x4000000 ? (char)'\u200f' : '\u200e'};
        if ((this.style & 4) != 0) {
            OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0, 0, 6);
            OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0, 0, 26);
            int n4 = OS.gtk_entry_get_max_length(this.handle);
            if (n4 != 0) {
                OS.gtk_entry_set_max_length(this.handle, this.translateOffset(n4));
            }
            int[] nArray = new int[1];
            for (int i = 0; i < n2; ++i) {
                nArray[0] = this.segments[i] + i;
                if (cArray != null && cArray.length > i) {
                    cArray2[0] = cArray[i];
                }
                byte[] byArray = Converter.wcsToMbcs(null, cArray2, false);
                int n5 = OS.gtk_entry_get_text(this.handle);
                nArray[0] = OS.g_utf16_offset_to_utf8_offset(n5, nArray[0]);
                OS.gtk_editable_insert_text(this.handle, byArray, byArray.length, nArray);
            }
            OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0, 0, 6);
            OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0, 0, 26);
        } else {
            OS.g_signal_handlers_block_matched(this.bufferHandle, 16, 0, 0, 0, 0, 6);
            OS.g_signal_handlers_block_matched(this.bufferHandle, 16, 0, 0, 0, 0, 52);
            byte[] byArray = new byte[ITER_SIZEOF];
            byte[] byArray2 = new byte[ITER_SIZEOF];
            byte[] byArray3 = new byte[ITER_SIZEOF];
            for (int i = 0; i < n2; ++i) {
                OS.gtk_text_buffer_get_bounds(this.bufferHandle, byArray2, byArray3);
                int n6 = OS.gtk_text_buffer_get_text(this.bufferHandle, byArray2, byArray3, true);
                OS.gtk_text_buffer_get_iter_at_offset(this.bufferHandle, byArray, OS.g_utf16_offset_to_utf8_offset(n6, this.segments[i] + i));
                OS.g_free(n6);
                if (cArray != null && cArray.length > i) {
                    cArray2[0] = cArray[i];
                }
                byte[] byArray4 = Converter.wcsToMbcs(null, cArray2, false);
                OS.gtk_text_buffer_insert(this.bufferHandle, byArray, byArray4, byArray4.length);
            }
            OS.g_signal_handlers_unblock_matched(this.bufferHandle, 16, 0, 0, 0, 0, 6);
            OS.g_signal_handlers_unblock_matched(this.bufferHandle, 16, 0, 0, 0, 0, 52);
        }
    }

    void clearSegments(boolean bl) {
        if (this.segments == null) {
            return;
        }
        int n = this.segments.length;
        if (n == 0) {
            return;
        }
        if ((this.style & 4) != 0) {
            int n2;
            OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0, 0, 6);
            if (bl) {
                OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0, 0, 13);
                n2 = OS.gtk_entry_get_text(this.handle);
                for (int i = 0; i < n; ++i) {
                    int n3 = OS.g_utf16_offset_to_utf8_offset(n2, this.segments[i]);
                    int n4 = OS.g_utf16_offset_to_utf8_offset(n2, this.segments[i] + 1);
                    OS.gtk_editable_delete_text(this.handle, n3, n4);
                }
                OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0, 0, 13);
            }
            if ((n2 = OS.gtk_entry_get_max_length(this.handle)) != 0) {
                OS.gtk_entry_set_max_length(this.handle, this.untranslateOffset(n2));
            }
            OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0, 0, 6);
        } else if (bl) {
            OS.g_signal_handlers_block_matched(this.bufferHandle, 16, 0, 0, 0, 0, 6);
            OS.g_signal_handlers_block_matched(this.bufferHandle, 16, 0, 0, 0, 0, 12);
            byte[] byArray = new byte[ITER_SIZEOF];
            byte[] byArray2 = new byte[ITER_SIZEOF];
            byte[] byArray3 = new byte[ITER_SIZEOF];
            byte[] byArray4 = new byte[ITER_SIZEOF];
            for (int i = 0; i < n; ++i) {
                OS.gtk_text_buffer_get_bounds(this.bufferHandle, byArray3, byArray4);
                int n5 = OS.gtk_text_buffer_get_text(this.bufferHandle, byArray3, byArray4, true);
                OS.gtk_text_buffer_get_iter_at_offset(this.bufferHandle, byArray, OS.g_utf16_offset_to_utf8_offset(n5, this.segments[i]));
                OS.gtk_text_buffer_get_iter_at_offset(this.bufferHandle, byArray2, OS.g_utf16_offset_to_utf8_offset(n5, this.segments[i] + 1));
                OS.gtk_text_buffer_delete(this.bufferHandle, byArray, byArray2);
                OS.g_free(n5);
            }
            OS.g_signal_handlers_unblock_matched(this.bufferHandle, 16, 0, 0, 0, 0, 12);
            OS.g_signal_handlers_unblock_matched(this.bufferHandle, 16, 0, 0, 0, 0, 6);
        }
        this.segments = null;
    }

    public void clearSelection() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            int n = OS.gtk_editable_get_position(this.handle);
            OS.gtk_editable_select_region(this.handle, n, n);
        } else {
            byte[] byArray = new byte[ITER_SIZEOF];
            int n = OS.gtk_text_buffer_get_insert(this.bufferHandle);
            OS.gtk_text_buffer_get_iter_at_mark(this.bufferHandle, byArray, n);
            OS.gtk_text_buffer_select_range(this.bufferHandle, byArray, byArray);
        }
    }

    @Override
    public Point computeSize(int n, int n2, boolean bl) {
        int n3;
        int n4;
        this.checkWidget();
        if (n != -1 && n < 0) {
            n = 0;
        }
        if (n2 != -1 && n2 < 0) {
            n2 = 0;
        }
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        if ((this.style & 4) != 0) {
            OS.gtk_widget_realize(this.handle);
            n4 = OS.gtk_entry_get_layout(this.handle);
            OS.pango_layout_get_pixel_size(n4, nArray, nArray2);
        } else {
            byte[] byArray = new byte[ITER_SIZEOF];
            byte[] byArray2 = new byte[ITER_SIZEOF];
            OS.gtk_text_buffer_get_bounds(this.bufferHandle, byArray, byArray2);
            int n5 = OS.gtk_text_buffer_get_text(this.bufferHandle, byArray, byArray2, true);
            n3 = OS.gtk_widget_create_pango_layout(this.handle, n5);
            OS.g_free(n5);
            OS.pango_layout_set_width(n3, n * 1024);
            OS.pango_layout_get_pixel_size(n3, nArray, nArray2);
            OS.g_object_unref(n3);
        }
        n4 = nArray[0];
        int n6 = nArray2[0];
        if ((this.style & 4) != 0 && this.message.length() > 0) {
            byte[] byArray = Converter.wcsToMbcs(null, this.message, true);
            n3 = OS.gtk_widget_create_pango_layout(this.handle, byArray);
            Arrays.fill(byArray, (byte)0);
            OS.pango_layout_get_pixel_size(n3, nArray, nArray2);
            OS.g_object_unref(n3);
            n4 = Math.max(n4, nArray[0]);
        }
        if (n4 == 0) {
            n4 = 64;
        }
        if (n6 == 0) {
            n6 = 64;
        }
        n4 = n == -1 ? n4 : n;
        n6 = n2 == -1 ? n6 : n2;
        Rectangle rectangle = this.computeTrim(0, 0, n4, n6);
        return new Point(rectangle.width, rectangle.height);
    }

    @Override
    public Rectangle computeTrim(int n, int n2, int n3, int n4) {
        this.checkWidget();
        Rectangle rectangle = super.computeTrim(n, n2, n3, n4);
        int n5 = 0;
        int n6 = 0;
        if ((this.style & 4) != 0) {
            if (OS.GTK3) {
                GtkBorder gtkBorder = new GtkBorder();
                int n7 = OS.gtk_widget_get_style_context(this.handle);
                OS.gtk_style_context_get_padding(n7, 0, gtkBorder);
                rectangle.x -= gtkBorder.left;
                rectangle.y -= gtkBorder.top;
                rectangle.width += gtkBorder.left + gtkBorder.right;
                rectangle.height += gtkBorder.top + gtkBorder.bottom;
                if ((this.style & 0x800) != 0) {
                    OS.gtk_style_context_get_border(n7, 0, gtkBorder);
                    rectangle.x -= gtkBorder.left;
                    rectangle.y -= gtkBorder.top;
                    rectangle.width += gtkBorder.left + gtkBorder.right;
                    rectangle.height += gtkBorder.top + gtkBorder.bottom;
                }
                GdkRectangle gdkRectangle = new GdkRectangle();
                OS.gtk_entry_get_icon_area(this.handle, 0, gdkRectangle);
                rectangle.x -= gdkRectangle.width;
                rectangle.width += gdkRectangle.width;
                OS.gtk_entry_get_icon_area(this.handle, 1, gdkRectangle);
                rectangle.width += gdkRectangle.width;
            } else {
                Object object;
                if ((this.style & 0x800) != 0) {
                    object = this.getThickness(this.handle);
                    n5 += ((Point)object).x;
                    n6 += ((Point)object).y;
                }
                object = Display.getEntryInnerBorder(this.handle);
                rectangle.x -= ((GtkBorder)object).left;
                rectangle.y -= ((GtkBorder)object).top;
                rectangle.width += ((GtkBorder)object).left + ((GtkBorder)object).right;
                rectangle.height += ((GtkBorder)object).top + ((GtkBorder)object).bottom;
            }
        } else {
            int n8 = OS.gtk_container_get_border_width(this.handle);
            n5 += n8;
            n6 += n8;
        }
        int[] nArray = new int[1];
        OS.gtk_widget_style_get(this.handle, OS.interior_focus, nArray, 0);
        if (nArray[0] == 0) {
            OS.gtk_widget_style_get(this.handle, OS.focus_line_width, nArray, 0);
            n5 += nArray[0];
            n6 += nArray[0];
        }
        rectangle.x -= n5;
        rectangle.y -= n6;
        rectangle.width += 2 * n5;
        rectangle.height += 2 * n6;
        ++rectangle.width;
        return new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void copy() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            OS.gtk_editable_copy_clipboard(this.handle);
        } else {
            int n = OS.gtk_clipboard_get(0);
            this.clearSegments(true);
            OS.gtk_text_buffer_copy_clipboard(this.bufferHandle, n);
            this.applySegments();
        }
    }

    public void cut() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            OS.gtk_editable_cut_clipboard(this.handle);
        } else {
            int n = OS.gtk_clipboard_get(0);
            this.clearSegments(true);
            OS.gtk_text_buffer_cut_clipboard(this.bufferHandle, n, OS.gtk_text_view_get_editable(this.handle));
            this.applySegments();
        }
    }

    char[] deprocessText(char[] cArray, int n, int n2) {
        int n3;
        if (cArray == null) {
            return new char[0];
        }
        if (n < 0) {
            n = 0;
        }
        int n4 = cArray.length;
        if (n2 == -1) {
            n2 = n + n4;
        }
        if (this.segments != null && n2 > this.segments[0] && (n3 = this.segments.length) > 0 && n <= this.segments[n3 - 1]) {
            int n5 = 0;
            while (n - n5 > this.segments[n5]) {
                ++n5;
            }
            int n6 = n5;
            for (int i = n; i < n2; ++i) {
                if (n6 < n3 && i - n6 == this.segments[n6]) {
                    ++n6;
                    continue;
                }
                cArray[i - n6 + n5 - n] = cArray[i - n];
            }
            n4 = n2 - n - n6 + n5;
        }
        if (n != 0 || n2 != n + n4) {
            char[] cArray2 = new char[n4];
            System.arraycopy(cArray, 0, cArray2, 0, n4);
            return cArray2;
        }
        return cArray;
    }

    @Override
    void deregister() {
        int n;
        super.deregister();
        if (this.bufferHandle != 0) {
            this.display.removeWidget(this.bufferHandle);
        }
        if ((n = this.imContext()) != 0) {
            this.display.removeWidget(n);
        }
    }

    @Override
    boolean dragDetect(int n, int n2, boolean bl, boolean bl2, boolean[] blArray) {
        if (bl) {
            Object[] objectArray;
            Object[] objectArray2;
            int n3 = 0;
            int n4 = 0;
            if ((this.style & 4) != 0) {
                objectArray2 = new int[1];
                objectArray = new int[1];
                OS.gtk_editable_get_selection_bounds(this.handle, objectArray2, objectArray);
                n3 = objectArray2[0];
                n4 = objectArray[0];
            } else {
                objectArray2 = new byte[ITER_SIZEOF];
                objectArray = new byte[ITER_SIZEOF];
                OS.gtk_text_buffer_get_selection_bounds(this.bufferHandle, (byte[])objectArray2, (byte[])objectArray);
                n3 = OS.gtk_text_iter_get_offset((byte[])objectArray2);
                n4 = OS.gtk_text_iter_get_offset((byte[])objectArray);
            }
            if (n3 != n4) {
                if (n4 < n3) {
                    int n5 = n4;
                    n4 = n3;
                    n3 = n5;
                }
                int n6 = -1;
                if ((this.style & 4) != 0) {
                    objectArray = new int[1];
                    int[] nArray = new int[1];
                    int n7 = OS.gtk_entry_get_layout(this.handle);
                    OS.pango_layout_xy_to_index(n7, n * 1024, n2 * 1024, objectArray, nArray);
                    int n8 = OS.pango_layout_get_text(n7);
                    n6 = OS.g_utf8_pointer_to_offset(n8, n8 + objectArray[0]) + nArray[0];
                } else {
                    objectArray = new byte[ITER_SIZEOF];
                    OS.gtk_text_view_get_iter_at_location(this.handle, (byte[])objectArray, n, n2);
                    n6 = OS.gtk_text_iter_get_offset((byte[])objectArray);
                }
                if (n3 <= n6 && n6 < n4 && super.dragDetect(n, n2, bl, bl2, blArray)) {
                    if (blArray != null) {
                        blArray[0] = true;
                    }
                    return true;
                }
            }
            return false;
        }
        return super.dragDetect(n, n2, bl, bl2, blArray);
    }

    @Override
    int eventWindow() {
        return this.paintWindow();
    }

    @Override
    boolean filterKey(int n, int n2) {
        int n3 = OS.gdk_event_get_time(n2);
        if (n3 != this.lastEventTime) {
            this.lastEventTime = n3;
            int n4 = this.imContext();
            if (n4 != 0) {
                return OS.gtk_im_context_filter_keypress(n4, n2);
            }
        }
        this.gdkEventKey = n2;
        return false;
    }

    void fixIM() {
        int n;
        if (this.gdkEventKey != 0 && this.gdkEventKey != -1 && (n = this.imContext()) != 0) {
            OS.gtk_im_context_filter_keypress(n, this.gdkEventKey);
            this.gdkEventKey = -1;
            return;
        }
        this.gdkEventKey = 0;
    }

    @Override
    GdkColor getBackgroundColor() {
        return this.getBaseColor();
    }

    @Override
    public int getBorderWidth() {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            return super.getBorderWidth();
        }
        if ((this.style & 0x800) != 0) {
            return this.getThickness((int)this.handle).x;
        }
        return 0;
    }

    public int getCaretLineNumber() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return 0;
        }
        byte[] byArray = new byte[ITER_SIZEOF];
        int n = OS.gtk_text_buffer_get_insert(this.bufferHandle);
        OS.gtk_text_buffer_get_iter_at_mark(this.bufferHandle, byArray, n);
        return OS.gtk_text_iter_get_line(byArray);
    }

    public Point getCaretLocation() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            int n = OS.gtk_editable_get_position(this.handle);
            n = OS.gtk_entry_text_index_to_layout_index(this.handle, n);
            int[] nArray = new int[1];
            int[] nArray2 = new int[1];
            OS.gtk_entry_get_layout_offsets(this.handle, nArray, nArray2);
            int n2 = OS.gtk_entry_get_layout(this.handle);
            PangoRectangle pangoRectangle = new PangoRectangle();
            OS.pango_layout_index_to_pos(n2, n, pangoRectangle);
            int n3 = nArray[0] + OS.PANGO_PIXELS(pangoRectangle.x) - this.getBorderWidth();
            int n4 = nArray2[0] + OS.PANGO_PIXELS(pangoRectangle.y);
            return new Point(n3, n4);
        }
        byte[] byArray = new byte[ITER_SIZEOF];
        int n = OS.gtk_text_buffer_get_insert(this.bufferHandle);
        OS.gtk_text_buffer_get_iter_at_mark(this.bufferHandle, byArray, n);
        GdkRectangle gdkRectangle = new GdkRectangle();
        OS.gtk_text_view_get_iter_location(this.handle, byArray, gdkRectangle);
        int[] nArray = new int[1];
        int[] nArray3 = new int[1];
        OS.gtk_text_view_buffer_to_window_coords(this.handle, 2, gdkRectangle.x, gdkRectangle.y, nArray, nArray3);
        return new Point(nArray[0], nArray3[0]);
    }

    public int getCaretPosition() {
        int n;
        this.checkWidget();
        if ((this.style & 4) != 0) {
            int n2 = OS.gtk_entry_get_text(this.handle);
            n = OS.g_utf8_offset_to_utf16_offset(n2, OS.gtk_editable_get_position(this.handle));
        } else {
            byte[] byArray = new byte[ITER_SIZEOF];
            int n3 = OS.gtk_text_buffer_get_insert(this.bufferHandle);
            OS.gtk_text_buffer_get_iter_at_mark(this.bufferHandle, byArray, n3);
            byte[] byArray2 = new byte[ITER_SIZEOF];
            OS.gtk_text_buffer_get_iter_at_offset(this.bufferHandle, byArray2, 0);
            int n4 = OS.gtk_text_buffer_get_text(this.bufferHandle, byArray2, byArray, true);
            n = OS.g_utf8_offset_to_utf16_offset(n4, OS.gtk_text_iter_get_offset(byArray));
            OS.g_free(n4);
        }
        return this.untranslateOffset(n);
    }

    public int getCharCount() {
        int n;
        this.checkWidget();
        if ((this.style & 4) != 0) {
            int n2 = OS.gtk_entry_get_text(this.handle);
            n = OS.g_utf16_strlen(n2, -1);
        } else {
            byte[] byArray = new byte[ITER_SIZEOF];
            byte[] byArray2 = new byte[ITER_SIZEOF];
            OS.gtk_text_buffer_get_bounds(this.bufferHandle, byArray, byArray2);
            int n3 = OS.gtk_text_buffer_get_text(this.bufferHandle, byArray, byArray2, true);
            n = OS.g_utf16_strlen(n3, -1);
            OS.g_free(n3);
        }
        return this.untranslateOffset(n);
    }

    public boolean getDoubleClickEnabled() {
        this.checkWidget();
        return this.doubleClick;
    }

    public char getEchoChar() {
        this.checkWidget();
        if ((this.style & 4) != 0 && !OS.gtk_entry_get_visibility(this.handle)) {
            return OS.gtk_entry_get_invisible_char(this.handle);
        }
        return '\u0000';
    }

    public boolean getEditable() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return OS.gtk_editable_get_editable(this.handle);
        }
        return OS.gtk_text_view_get_editable(this.handle);
    }

    @Override
    GdkColor getForegroundColor() {
        return this.getTextColor();
    }

    public int getLineCount() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return 1;
        }
        return OS.gtk_text_buffer_get_line_count(this.bufferHandle);
    }

    public String getLineDelimiter() {
        this.checkWidget();
        return "\n";
    }

    public int getLineHeight() {
        this.checkWidget();
        return this.fontHeight(this.getFontDescription(), this.handle);
    }

    public String getMessage() {
        this.checkWidget();
        return this.message;
    }

    @Override
    public int getOrientation() {
        return super.getOrientation();
    }

    int getPosition(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        int n = -1;
        if ((this.style & 4) != 0) {
            int[] nArray = new int[1];
            int[] nArray2 = new int[1];
            int n2 = OS.gtk_entry_get_layout(this.handle);
            OS.pango_layout_xy_to_index(n2, point.x * 1024, point.y * 1024, nArray, nArray2);
            int n3 = OS.pango_layout_get_text(n2);
            n = OS.g_utf16_pointer_to_offset(n3, n3 + nArray[0]) + nArray2[0];
        } else {
            byte[] byArray = new byte[ITER_SIZEOF];
            OS.gtk_text_view_get_iter_at_location(this.handle, byArray, point.x, point.y);
            byte[] byArray2 = new byte[ITER_SIZEOF];
            OS.gtk_text_buffer_get_iter_at_offset(this.bufferHandle, byArray2, 0);
            int n4 = OS.gtk_text_buffer_get_text(this.bufferHandle, byArray2, byArray, true);
            n = OS.g_utf8_offset_to_utf16_offset(n4, OS.gtk_text_iter_get_offset(byArray));
            OS.g_free(n4);
        }
        return this.untranslateOffset(n);
    }

    public Point getSelection() {
        Point point;
        this.checkWidget();
        if ((this.style & 4) != 0) {
            int[] nArray = new int[1];
            int[] nArray2 = new int[1];
            OS.gtk_editable_get_selection_bounds(this.handle, nArray, nArray2);
            int n = OS.gtk_entry_get_text(this.handle);
            nArray[0] = OS.g_utf8_offset_to_utf16_offset(n, nArray[0]);
            nArray2[0] = OS.g_utf8_offset_to_utf16_offset(n, nArray2[0]);
            point = new Point(nArray[0], nArray2[0]);
        } else {
            byte[] byArray = new byte[ITER_SIZEOF];
            byte[] byArray2 = new byte[ITER_SIZEOF];
            OS.gtk_text_buffer_get_selection_bounds(this.bufferHandle, byArray, byArray2);
            byte[] byArray3 = new byte[ITER_SIZEOF];
            OS.gtk_text_buffer_get_iter_at_offset(this.bufferHandle, byArray3, 0);
            int n = OS.gtk_text_buffer_get_text(this.bufferHandle, byArray3, byArray2, true);
            int n2 = OS.g_utf8_offset_to_utf16_offset(n, OS.gtk_text_iter_get_offset(byArray));
            int n3 = OS.g_utf8_offset_to_utf16_offset(n, OS.gtk_text_iter_get_offset(byArray2));
            OS.g_free(n);
            point = new Point(n2, n3);
        }
        point.x = this.untranslateOffset(point.x);
        point.y = this.untranslateOffset(point.y);
        return point;
    }

    public int getSelectionCount() {
        this.checkWidget();
        Point point = this.getSelection();
        return Math.abs(point.y - point.x);
    }

    public String getSelectionText() {
        this.checkWidget();
        Point point = this.getSelection();
        return this.getText().substring(point.x, point.y);
    }

    public int getTabs() {
        this.checkWidget();
        return this.tabs;
    }

    int getTabWidth(int n) {
        byte[] byArray = Converter.wcsToMbcs(null, " ", true);
        int n2 = OS.gtk_widget_create_pango_layout(this.handle, byArray);
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        OS.pango_layout_get_size(n2, nArray, nArray2);
        OS.g_object_unref(n2);
        return nArray[0] * n;
    }

    public String getText() {
        return new String(this.getTextChars());
    }

    public String getText(int n, int n2) {
        this.checkWidget();
        if (n > n2 || 0 > n2) {
            return "";
        }
        String string = this.getText();
        int n3 = string.length();
        if (n > (n2 = Math.min(n2, n3 - 1))) {
            return "";
        }
        n = Math.max(0, n);
        return string.substring(n, n2 + 1);
    }

    public char[] getTextChars() {
        byte[] byArray;
        int n;
        this.checkWidget();
        if ((this.style & 4) != 0) {
            n = OS.gtk_entry_get_text(this.handle);
        } else {
            byte[] byArray2 = new byte[ITER_SIZEOF];
            byArray = new byte[ITER_SIZEOF];
            OS.gtk_text_buffer_get_bounds(this.bufferHandle, byArray2, byArray);
            n = OS.gtk_text_buffer_get_text(this.bufferHandle, byArray2, byArray, true);
        }
        if (n == 0) {
            return new char[0];
        }
        int n2 = OS.strlen(n);
        byArray = new byte[n2];
        OS.memmove(byArray, n, n2);
        if ((this.style & 2) != 0) {
            OS.g_free(n);
        }
        char[] cArray = Converter.mbcsToWcs(null, byArray);
        Arrays.fill(byArray, (byte)0);
        if (this.segments != null) {
            cArray = this.deprocessText(cArray, 0, -1);
        }
        return cArray;
    }

    public int getTextLimit() {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            return LIMIT;
        }
        int n = OS.gtk_entry_get_max_length(this.handle);
        return n == 0 ? 65535 : this.untranslateOffset(n);
    }

    public int getTopIndex() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return 0;
        }
        byte[] byArray = new byte[ITER_SIZEOF];
        GdkRectangle gdkRectangle = new GdkRectangle();
        OS.gtk_text_view_get_visible_rect(this.handle, gdkRectangle);
        OS.gtk_text_view_get_line_at_y(this.handle, byArray, gdkRectangle.y, null);
        return OS.gtk_text_iter_get_line(byArray);
    }

    public int getTopPixel() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return 0;
        }
        byte[] byArray = new byte[ITER_SIZEOF];
        GdkRectangle gdkRectangle = new GdkRectangle();
        OS.gtk_text_view_get_visible_rect(this.handle, gdkRectangle);
        int[] nArray = new int[1];
        OS.gtk_text_view_get_line_at_y(this.handle, byArray, gdkRectangle.y, nArray);
        return nArray[0];
    }

    @Override
    int gtk_activate(int n) {
        this.sendSelectionEvent(14);
        return 0;
    }

    @Override
    int gtk_button_press_event(int n, int n2) {
        int n3 = super.gtk_button_press_event(n, n2);
        if (n3 != 0) {
            return n3;
        }
        GdkEventButton gdkEventButton = new GdkEventButton();
        OS.memmove(gdkEventButton, n2, GdkEventButton.sizeof);
        if (!this.doubleClick) {
            switch (gdkEventButton.type) {
                case 5: 
                case 6: {
                    return 1;
                }
            }
        }
        return n3;
    }

    @Override
    int gtk_changed(int n) {
        boolean bl = false;
        int n2 = OS.gtk_get_current_event();
        if (n2 != 0) {
            GdkEventKey gdkEventKey = new GdkEventKey();
            OS.memmove(gdkEventKey, n2, GdkEventKey.sizeof);
            switch (gdkEventKey.type) {
                case 8: {
                    bl = true;
                }
            }
            OS.gdk_event_free(n2);
        }
        if (bl) {
            this.postEvent(24);
        } else {
            this.sendEvent(24);
        }
        if ((this.style & 0x80) != 0 && (this.style & 0x100) != 0) {
            int n3 = OS.gtk_entry_get_text(this.handle);
            OS.gtk_entry_set_icon_sensitive(this.handle, 1, OS.g_utf16_strlen(n3, -1) > 0);
        }
        return 0;
    }

    @Override
    int gtk_commit(int n, int n2) {
        if (n2 == 0) {
            return 0;
        }
        if ((this.style & 4) != 0 && !OS.gtk_editable_get_editable(this.handle)) {
            return 0;
        }
        int n3 = OS.strlen(n2);
        if (n3 == 0) {
            return 0;
        }
        byte[] byArray = new byte[n3];
        OS.memmove(byArray, n2, n3);
        char[] cArray = Converter.mbcsToWcs(null, byArray);
        Arrays.fill(byArray, (byte)0);
        char[] cArray2 = this.sendIMKeyEvent(1, null, cArray);
        if (cArray2 == null) {
            return 0;
        }
        this.fixEnd = -1;
        this.fixStart = -1;
        OS.g_signal_handlers_block_matched(n, 16, 0, 0, 0, 0, 9);
        int n4 = OS.g_signal_lookup(OS.commit, OS.gtk_im_context_get_type());
        int n5 = 17;
        OS.g_signal_handlers_unblock_matched(n, n5, n4, 0, 0, 0, this.handle);
        if (cArray2 == cArray) {
            OS.g_signal_emit_by_name(n, OS.commit, n2);
        } else {
            byArray = Converter.wcsToMbcs(null, cArray2, true);
            OS.g_signal_emit_by_name(n, OS.commit, byArray);
            Arrays.fill(byArray, (byte)0);
        }
        OS.g_signal_handlers_unblock_matched(n, 16, 0, 0, 0, 0, 9);
        OS.g_signal_handlers_block_matched(n, n5, n4, 0, 0, 0, this.handle);
        if ((this.style & 4) != 0 && this.fixStart != -1 && this.fixEnd != -1) {
            OS.gtk_editable_set_position(this.handle, this.fixStart);
            OS.gtk_editable_select_region(this.handle, this.fixStart, this.fixEnd);
        }
        this.fixEnd = -1;
        this.fixStart = -1;
        return 0;
    }

    @Override
    int gtk_delete_range(int n, int n2, int n3) {
        if (!this.hooks(25) && !this.filters(25)) {
            return 0;
        }
        byte[] byArray = new byte[ITER_SIZEOF];
        byte[] byArray2 = new byte[ITER_SIZEOF];
        OS.memmove(byArray, n2, byArray.length);
        OS.memmove(byArray2, n3, byArray2.length);
        int n4 = OS.gtk_text_iter_get_offset(byArray);
        int n5 = OS.gtk_text_iter_get_offset(byArray2);
        byte[] byArray3 = new byte[ITER_SIZEOF];
        OS.gtk_text_buffer_get_iter_at_offset(this.bufferHandle, byArray3, 0);
        int n6 = OS.gtk_text_buffer_get_text(this.bufferHandle, byArray3, byArray2, true);
        n4 = OS.g_utf8_offset_to_utf16_offset(n6, n4);
        n5 = OS.g_utf8_offset_to_utf16_offset(n6, n5);
        OS.g_free(n6);
        String string = this.verifyText("", n4, n5);
        if (string == null) {
            OS.gtk_text_buffer_get_selection_bounds(this.bufferHandle, byArray, byArray2);
            n4 = OS.gtk_text_iter_get_offset(byArray);
            n5 = OS.gtk_text_iter_get_offset(byArray2);
            if (n4 != n5) {
                this.fixStart = n4;
                this.fixEnd = n5;
            }
            OS.g_signal_stop_emission_by_name(this.bufferHandle, OS.delete_range);
        } else if (string.length() > 0) {
            byte[] byArray4 = Converter.wcsToMbcs(null, string, false);
            OS.g_signal_handlers_block_matched(this.bufferHandle, 16, 0, 0, 0, 0, 6);
            OS.g_signal_handlers_block_matched(this.bufferHandle, 16, 0, 0, 0, 0, 12);
            OS.gtk_text_buffer_delete(this.bufferHandle, byArray, byArray2);
            OS.g_signal_handlers_unblock_matched(this.bufferHandle, 16, 0, 0, 0, 0, 12);
            OS.g_signal_handlers_unblock_matched(this.bufferHandle, 16, 0, 0, 0, 0, 6);
            OS.g_signal_handlers_block_matched(this.bufferHandle, 16, 0, 0, 0, 0, 52);
            OS.gtk_text_buffer_insert(this.bufferHandle, byArray, byArray4, byArray4.length);
            OS.g_signal_handlers_unblock_matched(this.bufferHandle, 16, 0, 0, 0, 0, 52);
            OS.g_signal_stop_emission_by_name(this.bufferHandle, OS.delete_range);
            Arrays.fill(byArray4, (byte)0);
        }
        return 0;
    }

    @Override
    int gtk_delete_text(int n, int n2, int n3) {
        int n4;
        int n5;
        String string;
        if (!this.hooks(25) && !this.filters(25)) {
            return 0;
        }
        int n6 = OS.gtk_entry_get_text(this.handle);
        if (n3 == -1) {
            n3 = OS.g_utf8_strlen(n6, -1);
        }
        if ((string = this.verifyText("", n5 = OS.g_utf8_offset_to_utf16_offset(n6, n2), n4 = OS.g_utf8_offset_to_utf16_offset(n6, n3))) == null) {
            int[] nArray = new int[1];
            int[] nArray2 = new int[1];
            OS.gtk_editable_get_selection_bounds(this.handle, nArray, nArray2);
            if (nArray[0] != nArray2[0]) {
                this.fixStart = nArray[0];
                this.fixEnd = nArray2[0];
            }
            OS.g_signal_stop_emission_by_name(this.handle, OS.delete_text);
        } else if (string.length() > 0) {
            int[] nArray = new int[]{n3};
            byte[] byArray = Converter.wcsToMbcs(null, string, false);
            OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0, 0, 6);
            OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0, 0, 26);
            OS.gtk_editable_insert_text(this.handle, byArray, byArray.length, nArray);
            OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0, 0, 26);
            OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0, 0, 6);
            OS.gtk_editable_set_position(this.handle, nArray[0]);
            Arrays.fill(byArray, (byte)0);
        }
        return 0;
    }

    @Override
    int gtk_event_after(int n, int n2) {
        if (this.cursor != null) {
            this.setCursor(this.cursor.handle);
        }
        if ((this.style & 4) != 0 && this.display.entrySelectOnFocus) {
            GdkEvent gdkEvent = new GdkEvent();
            OS.memmove(gdkEvent, n2, GdkEvent.sizeof);
            switch (gdkEvent.type) {
                case 12: {
                    GdkEventFocus gdkEventFocus = new GdkEventFocus();
                    OS.memmove(gdkEventFocus, n2, GdkEventFocus.sizeof);
                    if (gdkEventFocus.in != 0) break;
                    int n3 = OS.gtk_settings_get_default();
                    OS.g_object_set(n3, OS.gtk_entry_select_on_focus, true, 0);
                }
            }
        }
        return super.gtk_event_after(n, n2);
    }

    void drawMessage(int n) {
        if (OS.GTK_VERSION >= OS.VERSION(3, 2, 0)) {
            return;
        }
        if ((this.style & 4) != 0 && this.message.length() > 0) {
            int n2 = OS.gtk_entry_get_text(this.handle);
            if (!OS.gtk_widget_has_focus(this.handle) && OS.strlen(n2) == 0) {
                int n3;
                int n4 = this.paintWindow();
                int[] nArray = new int[1];
                int[] nArray2 = new int[1];
                this.gdk_window_get_size(n4, nArray, nArray2);
                GtkBorder gtkBorder = Display.getEntryInnerBorder(this.handle);
                int n5 = nArray[0] - gtkBorder.left - gtkBorder.right;
                int n6 = nArray2[0] - gtkBorder.top - gtkBorder.bottom;
                int n7 = OS.gtk_widget_get_pango_context(this.handle);
                int n8 = OS.pango_context_get_language(n7);
                int n9 = OS.pango_context_get_metrics(n7, this.getFontDescription(), n8);
                int n10 = OS.PANGO_PIXELS(OS.pango_font_metrics_get_ascent(n9));
                int n11 = OS.PANGO_PIXELS(OS.pango_font_metrics_get_descent(n9));
                OS.pango_font_metrics_unref(n9);
                byte[] byArray = Converter.wcsToMbcs(null, this.message, true);
                int n12 = OS.gtk_widget_create_pango_layout(this.handle, byArray);
                int n13 = OS.pango_layout_get_line(n12, 0);
                PangoRectangle pangoRectangle = new PangoRectangle();
                OS.pango_layout_line_get_extents(n13, null, pangoRectangle);
                pangoRectangle.y = OS.PANGO_PIXELS(pangoRectangle.y);
                pangoRectangle.height = OS.PANGO_PIXELS(pangoRectangle.height);
                pangoRectangle.width = OS.PANGO_PIXELS(pangoRectangle.width);
                int n14 = (n6 - n10 - n11) / 2 + n10 + pangoRectangle.y;
                if (pangoRectangle.height > n6) {
                    n14 = (n6 - pangoRectangle.height) / 2;
                } else if (n14 < 0) {
                    n14 = 0;
                } else if (n14 + pangoRectangle.height > n6) {
                    n14 = n6 - pangoRectangle.height;
                }
                n14 += gtkBorder.top;
                int n15 = gtkBorder.left;
                boolean bl = (this.style & 0x4000000) != 0;
                int n16 = this.style & 0x1024000;
                switch (n16) {
                    case 16384: {
                        n15 = bl ? n5 - pangoRectangle.width : gtkBorder.left;
                        break;
                    }
                    case 0x1000000: {
                        n15 = (n5 - pangoRectangle.width) / 2;
                        break;
                    }
                    case 131072: {
                        n15 = bl ? gtkBorder.left : n5 - pangoRectangle.width;
                    }
                }
                GdkColor gdkColor = new GdkColor();
                GdkColor gdkColor2 = new GdkColor();
                if (OS.GTK3) {
                    n3 = OS.gtk_widget_get_style_context(this.handle);
                    GdkRGBA gdkRGBA = new GdkRGBA();
                    OS.gtk_style_context_get_color(n3, 8, gdkRGBA);
                    gdkColor.red = (short)(gdkRGBA.red * 65535.0);
                    gdkColor.green = (short)(gdkRGBA.green * 65535.0);
                    gdkColor.blue = (short)(gdkRGBA.blue * 65535.0);
                    Point point = this.getThickness(this.handle);
                    n15 += point.x;
                    n14 += point.y;
                } else {
                    n3 = OS.gtk_widget_get_style(this.handle);
                    OS.gtk_style_get_text(n3, 4, gdkColor);
                    OS.gtk_style_get_base(n3, 0, gdkColor2);
                }
                if (OS.USE_CAIRO) {
                    n3 = n != 0 ? n : OS.gdk_cairo_create(n4);
                    Cairo.cairo_set_source_rgba(n3, (float)(gdkColor.red & 0xFFFF) / 65535.0f, (float)(gdkColor.green & 0xFFFF) / 65535.0f, (float)(gdkColor.blue & 0xFFFF) / 65535.0f, 1.0);
                    Cairo.cairo_move_to(n3, n15, n14);
                    OS.pango_cairo_show_layout(n3, n12);
                    if (n != n3) {
                        Cairo.cairo_destroy(n3);
                    }
                } else {
                    n3 = OS.gdk_gc_new(n4);
                    OS.gdk_draw_layout_with_colors(n4, n3, n15, n14, n12, gdkColor, gdkColor2);
                    OS.g_object_unref(n3);
                }
                OS.g_object_unref(n12);
            }
        }
    }

    @Override
    int gtk_draw(int n, int n2) {
        if ((this.state & 0x40) != 0) {
            return 0;
        }
        int n3 = super.gtk_draw(n, n2);
        this.drawMessage(n2);
        return n3;
    }

    @Override
    int gtk_expose_event(int n, int n2) {
        if ((this.state & 0x40) != 0) {
            return 0;
        }
        int n3 = super.gtk_expose_event(n, n2);
        this.drawMessage(0);
        return n3;
    }

    @Override
    int gtk_focus_out_event(int n, int n2) {
        this.fixIM();
        return super.gtk_focus_out_event(n, n2);
    }

    @Override
    int gtk_grab_focus(int n) {
        int n2 = super.gtk_grab_focus(n);
        if ((this.style & 4) != 0 && this.display.entrySelectOnFocus) {
            int n3 = OS.gtk_settings_get_default();
            OS.g_object_set(n3, OS.gtk_entry_select_on_focus, false, 0);
        }
        return n2;
    }

    @Override
    int gtk_icon_release(int n, int n2, int n3) {
        Event event = new Event();
        if (n2 == 0) {
            event.detail = 512;
        } else {
            event.detail = 256;
            OS.gtk_editable_delete_text(this.handle, 0, -1);
        }
        this.sendSelectionEvent(14, event, false);
        return 0;
    }

    @Override
    int gtk_insert_text(int n, int n2, int n3, int n4) {
        String string;
        if (!this.hooks(25) && !this.filters(25)) {
            return 0;
        }
        if (n2 == 0 || n3 == 0) {
            return 0;
        }
        byte[] byArray = new byte[n3];
        OS.memmove(byArray, n2, byArray.length);
        String string2 = new String(Converter.mbcsToWcs(null, byArray));
        int[] nArray = new int[1];
        OS.memmove(nArray, n4, 4);
        int n5 = OS.gtk_entry_get_text(this.handle);
        if (nArray[0] == -1) {
            nArray[0] = OS.g_utf8_strlen(n5, -1);
        }
        int n6 = nArray[0];
        int n7 = nArray[0];
        if (this.fixStart != -1 && this.fixEnd != -1) {
            n6 = nArray[0] = this.fixStart;
            n7 = this.fixEnd;
            this.fixEnd = -1;
            this.fixStart = -1;
        }
        if ((string = this.verifyText(string2, n6 = OS.g_utf8_offset_to_utf16_offset(n5, n6), n7 = OS.g_utf8_offset_to_utf16_offset(n5, n7))) != string2) {
            int[] nArray2 = new int[1];
            int[] nArray3 = new int[1];
            OS.gtk_editable_get_selection_bounds(this.handle, nArray2, nArray3);
            if (string != null) {
                if (nArray2[0] != nArray3[0]) {
                    OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0, 0, 13);
                    OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0, 0, 6);
                    OS.gtk_editable_delete_selection(this.handle);
                    OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0, 0, 13);
                    OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0, 0, 6);
                }
                byte[] byArray2 = Converter.wcsToMbcs(null, string, false);
                OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0, 0, 26);
                OS.gtk_editable_insert_text(this.handle, byArray2, byArray2.length, nArray);
                OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0, 0, 26);
                nArray2[0] = nArray3[0] = nArray[0];
            }
            nArray[0] = nArray3[0];
            if (nArray2[0] != nArray3[0]) {
                this.fixStart = nArray2[0];
                this.fixEnd = nArray3[0];
            }
            OS.memmove(n4, nArray, 4);
            OS.g_signal_stop_emission_by_name(this.handle, OS.insert_text);
        }
        return 0;
    }

    @Override
    int gtk_key_press_event(int n, int n2) {
        int n3;
        boolean bl = false;
        boolean bl2 = false;
        if (this.hooks(49) || this.filters(49)) {
            GdkEventKey gdkEventKey = new GdkEventKey();
            OS.memmove(gdkEventKey, n2, GdkEventKey.sizeof);
            if (gdkEventKey.length > 0 && (gdkEventKey.state & 0xC) == 0) {
                bl = true;
                if (this.segments != null) {
                    this.clearSegments(true);
                    bl2 = true;
                }
            }
        }
        if ((n3 = super.gtk_key_press_event(n, n2)) != 0) {
            this.fixIM();
        }
        if (this.gdkEventKey == -1) {
            n3 = 1;
        }
        this.gdkEventKey = 0;
        if (bl && (n3 != 0 || bl2)) {
            this.applySegments();
        }
        return n3;
    }

    @Override
    int gtk_populate_popup(int n, int n2) {
        if ((this.style & 0x4000000) != 0) {
            OS.gtk_widget_set_direction(n2, 2);
            OS.gtk_container_forall(n2, this.display.setDirectionProc, 2);
        }
        return 0;
    }

    @Override
    int gtk_text_buffer_insert_text(int n, int n2, int n3, int n4) {
        int n5;
        if (!this.hooks(25) && !this.filters(25)) {
            return 0;
        }
        byte[] byArray = new byte[ITER_SIZEOF];
        OS.memmove(byArray, n2, byArray.length);
        int n6 = n5 = OS.gtk_text_iter_get_offset(byArray);
        if (this.fixStart != -1 && this.fixEnd != -1) {
            n5 = this.fixStart;
            n6 = this.fixEnd;
            this.fixEnd = -1;
            this.fixStart = -1;
        }
        byte[] byArray2 = new byte[ITER_SIZEOF];
        OS.gtk_text_buffer_get_iter_at_offset(this.bufferHandle, byArray2, 0);
        int n7 = OS.gtk_text_buffer_get_text(this.bufferHandle, byArray2, byArray, true);
        n5 = OS.g_utf8_offset_to_utf16_offset(n7, n5);
        n6 = OS.g_utf8_offset_to_utf16_offset(n7, n6);
        OS.g_free(n7);
        byte[] byArray3 = new byte[n4];
        OS.memmove(byArray3, n3, byArray3.length);
        String string = new String(Converter.mbcsToWcs(null, byArray3));
        String string2 = this.verifyText(string, n5, n6);
        if (string2 == null) {
            OS.g_signal_stop_emission_by_name(this.bufferHandle, OS.insert_text);
        } else if (string2 != string) {
            byte[] byArray4 = Converter.wcsToMbcs(null, string2, false);
            OS.g_signal_handlers_block_matched(this.bufferHandle, 16, 0, 0, 0, 0, 52);
            OS.gtk_text_buffer_insert(this.bufferHandle, n2, byArray4, byArray4.length);
            OS.g_signal_handlers_unblock_matched(this.bufferHandle, 16, 0, 0, 0, 0, 52);
            OS.g_signal_stop_emission_by_name(this.bufferHandle, OS.insert_text);
        }
        return 0;
    }

    @Override
    void hookEvents() {
        int n;
        super.hookEvents();
        if ((this.style & 4) != 0) {
            OS.g_signal_connect_closure(this.handle, OS.changed, this.display.getClosure(6), true);
            OS.g_signal_connect_closure(this.handle, OS.insert_text, this.display.getClosure(26), false);
            OS.g_signal_connect_closure(this.handle, OS.delete_text, this.display.getClosure(13), false);
            OS.g_signal_connect_closure(this.handle, OS.activate, this.display.getClosure(1), false);
            OS.g_signal_connect_closure(this.handle, OS.grab_focus, this.display.getClosure(23), false);
            OS.g_signal_connect_closure(this.handle, OS.populate_popup, this.display.getClosure(37), false);
            if ((this.style & 0x80) != 0) {
                OS.g_signal_connect_closure(this.handle, OS.icon_release, this.display.getClosure(67), false);
            }
        } else {
            OS.g_signal_connect_closure(this.bufferHandle, OS.changed, this.display.getClosure(6), false);
            OS.g_signal_connect_closure(this.bufferHandle, OS.insert_text, this.display.getClosure(52), false);
            OS.g_signal_connect_closure(this.bufferHandle, OS.delete_range, this.display.getClosure(12), false);
            OS.g_signal_connect_closure(this.handle, OS.populate_popup, this.display.getClosure(37), false);
        }
        if ((n = this.imContext()) != 0) {
            OS.g_signal_connect_closure(n, OS.commit, this.display.getClosure(9), false);
            int n2 = OS.g_signal_lookup(OS.commit, OS.gtk_im_context_get_type());
            int n3 = 17;
            OS.g_signal_handlers_block_matched(n, n3, n2, 0, 0, 0, this.handle);
        }
        OS.g_signal_connect_closure(this.handle, OS.backspace, this.display.getClosure(70), false);
        OS.g_signal_connect_closure(this.handle, OS.backspace, this.display.getClosure(71), true);
        OS.g_signal_connect_closure(this.handle, OS.copy_clipboard, this.display.getClosure(72), false);
        OS.g_signal_connect_closure(this.handle, OS.copy_clipboard, this.display.getClosure(73), true);
        OS.g_signal_connect_closure(this.handle, OS.cut_clipboard, this.display.getClosure(74), false);
        OS.g_signal_connect_closure(this.handle, OS.cut_clipboard, this.display.getClosure(75), true);
        OS.g_signal_connect_closure(this.handle, OS.paste_clipboard, this.display.getClosure(76), false);
        OS.g_signal_connect_closure(this.handle, OS.paste_clipboard, this.display.getClosure(77), true);
        OS.g_signal_connect_closure(this.handle, OS.delete_from_cursor, this.display.getClosure(78), false);
        OS.g_signal_connect_closure(this.handle, OS.delete_from_cursor, this.display.getClosure(79), true);
        OS.g_signal_connect_closure(this.handle, OS.move_cursor, this.display.getClosure(80), false);
        OS.g_signal_connect_closure(this.handle, OS.move_cursor, this.display.getClosure(81), true);
        OS.g_signal_connect_closure(this.handle, OS.direction_changed, this.display.getClosure(82), true);
    }

    int imContext() {
        if (this.imContext != 0) {
            return this.imContext;
        }
        if ((this.style & 4) != 0) {
            return OS.GTK_ENTRY_IM_CONTEXT(this.handle);
        }
        return OS.GTK_TEXTVIEW_IM_CONTEXT(this.handle);
    }

    public void insert(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        this.clearSegments(true);
        byte[] byArray = Converter.wcsToMbcs(null, string, false);
        if ((this.style & 4) != 0) {
            int[] nArray = new int[1];
            int[] nArray2 = new int[1];
            OS.gtk_editable_get_selection_bounds(this.handle, nArray, nArray2);
            OS.gtk_editable_delete_selection(this.handle);
            OS.gtk_editable_insert_text(this.handle, byArray, byArray.length, nArray);
            OS.gtk_editable_set_position(this.handle, nArray[0]);
        } else {
            byte[] byArray2 = new byte[ITER_SIZEOF];
            byte[] byArray3 = new byte[ITER_SIZEOF];
            if (OS.gtk_text_buffer_get_selection_bounds(this.bufferHandle, byArray2, byArray3)) {
                OS.gtk_text_buffer_delete(this.bufferHandle, byArray2, byArray3);
            }
            OS.gtk_text_buffer_insert(this.bufferHandle, byArray2, byArray, byArray.length);
            OS.gtk_text_buffer_place_cursor(this.bufferHandle, byArray2);
            int n = OS.gtk_text_buffer_get_insert(this.bufferHandle);
            OS.gtk_text_view_scroll_mark_onscreen(this.handle, n);
        }
        this.applySegments();
    }

    @Override
    int paintWindow() {
        if ((this.style & 4) != 0) {
            int n = super.paintWindow();
            int n2 = OS.gdk_window_get_children(n);
            if (n2 != 0) {
                do {
                    n = OS.g_list_data(n2);
                } while ((n2 = OS.g_list_next(n2)) != 0);
            }
            OS.g_list_free(n2);
            return n;
        }
        OS.gtk_widget_realize(this.handle);
        return OS.gtk_text_view_get_window(this.handle, 2);
    }

    public void paste() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            OS.gtk_editable_paste_clipboard(this.handle);
        } else {
            int n = OS.gtk_clipboard_get(0);
            this.clearSegments(true);
            OS.gtk_text_buffer_paste_clipboard(this.bufferHandle, n, null, OS.gtk_text_view_get_editable(this.handle));
            this.applySegments();
        }
    }

    @Override
    void register() {
        int n;
        super.register();
        if (this.bufferHandle != 0) {
            this.display.addWidget(this.bufferHandle, this);
        }
        if ((n = this.imContext()) != 0) {
            this.display.addWidget(n, this);
        }
    }

    @Override
    void releaseWidget() {
        super.releaseWidget();
        this.fixIM();
        this.message = null;
    }

    public void removeModifyListener(ModifyListener modifyListener) {
        this.checkWidget();
        if (modifyListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(24, modifyListener);
    }

    public void removeSegmentListener(SegmentListener segmentListener) {
        this.checkWidget();
        if (segmentListener == null) {
            this.error(4);
        }
        this.eventTable.unhook(49, segmentListener);
        this.clearSegments(true);
        this.applySegments();
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    public void removeVerifyListener(VerifyListener verifyListener) {
        this.checkWidget();
        if (verifyListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(25, verifyListener);
    }

    public void selectAll() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            OS.gtk_editable_select_region(this.handle, 0, -1);
        } else {
            byte[] byArray = new byte[ITER_SIZEOF];
            byte[] byArray2 = new byte[ITER_SIZEOF];
            OS.gtk_text_buffer_get_iter_at_offset(this.bufferHandle, byArray, 0);
            OS.gtk_text_buffer_get_end_iter(this.bufferHandle, byArray2);
            OS.gtk_text_buffer_select_range(this.bufferHandle, byArray, byArray2);
        }
    }

    @Override
    void setBackgroundColor(GdkColor gdkColor) {
        super.setBackgroundColor(gdkColor);
        if (!OS.GTK3) {
            OS.gtk_widget_modify_base(this.handle, 0, gdkColor);
        }
    }

    @Override
    void setBackgroundColor(int n, int n2, GdkRGBA gdkRGBA) {
        if ((this.style & 2) != 0) {
            super.setBackgroundColor(n, n2, gdkRGBA);
            return;
        }
        this.setBackgroundColorGradient(n, n2, gdkRGBA);
    }

    @Override
    void setCursor(int n) {
        int n2 = 0;
        if (n == 0) {
            n2 = OS.gdk_cursor_new(152);
        }
        super.setCursor(n != 0 ? n : n2);
        if (n == 0) {
            this.gdk_cursor_unref(n2);
        }
    }

    public void setDoubleClickEnabled(boolean bl) {
        this.checkWidget();
        this.doubleClick = bl;
    }

    public void setEchoChar(char c) {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            OS.gtk_entry_set_visibility(this.handle, c == '\u0000');
            OS.gtk_entry_set_invisible_char(this.handle, c);
        }
    }

    public void setEditable(boolean bl) {
        this.checkWidget();
        this.style &= 0xFFFFFFF7;
        if (!bl) {
            this.style |= 8;
        }
        if ((this.style & 4) != 0) {
            OS.gtk_editable_set_editable(this.handle, bl);
        } else {
            OS.gtk_text_view_set_editable(this.handle, bl);
        }
    }

    @Override
    void setFontDescription(int n) {
        super.setFontDescription(n);
        this.setTabStops(this.tabs);
    }

    @Override
    void setForegroundColor(GdkColor gdkColor) {
        this.setForegroundColor(this.handle, gdkColor, false);
    }

    public void setMessage(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        this.message = string;
        if (OS.GTK_VERSION >= OS.VERSION(3, 2, 0) && (this.style & 4) != 0) {
            byte[] byArray = Converter.wcsToMbcs(null, string, true);
            OS.gtk_entry_set_placeholder_text(this.handle, byArray);
            return;
        }
        this.redraw(false);
    }

    @Override
    public void setOrientation(int n) {
        this.checkWidget();
    }

    public void setSelection(int n) {
        this.checkWidget();
        n = this.translateOffset(n);
        if ((this.style & 4) != 0) {
            int n2 = OS.gtk_entry_get_text(this.handle);
            n = OS.g_utf16_offset_to_utf8_offset(n2, n);
            OS.gtk_editable_set_position(this.handle, n);
        } else {
            byte[] byArray = new byte[ITER_SIZEOF];
            byte[] byArray2 = new byte[ITER_SIZEOF];
            OS.gtk_text_buffer_get_bounds(this.bufferHandle, byArray, byArray2);
            int n3 = OS.gtk_text_buffer_get_text(this.bufferHandle, byArray, byArray2, true);
            n = OS.g_utf16_offset_to_utf8_offset(n3, n);
            OS.g_free(n3);
            OS.gtk_text_buffer_get_iter_at_offset(this.bufferHandle, byArray, n);
            OS.gtk_text_buffer_place_cursor(this.bufferHandle, byArray);
            int n4 = OS.gtk_text_buffer_get_insert(this.bufferHandle);
            OS.gtk_text_view_scroll_mark_onscreen(this.handle, n4);
        }
    }

    public void setSelection(int n, int n2) {
        this.checkWidget();
        n = this.translateOffset(n);
        n2 = this.translateOffset(n2);
        if ((this.style & 4) != 0) {
            int n3 = OS.gtk_entry_get_text(this.handle);
            n = OS.g_utf16_offset_to_utf8_offset(n3, n);
            n2 = OS.g_utf16_offset_to_utf8_offset(n3, n2);
            OS.gtk_editable_set_position(this.handle, n);
            OS.gtk_editable_select_region(this.handle, n, n2);
        } else {
            byte[] byArray = new byte[ITER_SIZEOF];
            byte[] byArray2 = new byte[ITER_SIZEOF];
            OS.gtk_text_buffer_get_bounds(this.bufferHandle, byArray, byArray2);
            int n4 = OS.gtk_text_buffer_get_text(this.bufferHandle, byArray, byArray2, true);
            n = OS.g_utf16_offset_to_utf8_offset(n4, n);
            n2 = OS.g_utf16_offset_to_utf8_offset(n4, n2);
            OS.g_free(n4);
            OS.gtk_text_buffer_get_iter_at_offset(this.bufferHandle, byArray, n);
            OS.gtk_text_buffer_get_iter_at_offset(this.bufferHandle, byArray2, n2);
            OS.gtk_text_buffer_select_range(this.bufferHandle, byArray, byArray2);
        }
    }

    public void setSelection(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        this.setSelection(point.x, point.y);
    }

    public void setTabs(int n) {
        this.checkWidget();
        if (n < 0) {
            return;
        }
        this.tabs = n;
        this.setTabStops(this.tabs);
    }

    void setTabStops(int n) {
        if ((this.style & 4) != 0) {
            return;
        }
        int n2 = this.getTabWidth(n);
        int n3 = OS.pango_tab_array_new(1, false);
        OS.pango_tab_array_set_tab(n3, 0, 0, n2);
        OS.gtk_text_view_set_tabs(this.handle, n3);
        OS.pango_tab_array_free(n3);
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((this.hooks(25) || this.filters(25)) && (string = this.verifyText(string, 0, this.getCharCount())) == null) {
            return;
        }
        char[] cArray = new char[string.length()];
        string.getChars(0, cArray.length, cArray, 0);
        this.setText(cArray);
    }

    public void setTextChars(char[] cArray) {
        this.checkWidget();
        if (cArray == null) {
            this.error(4);
        }
        if (this.hooks(25) || this.filters(25)) {
            String string = this.verifyText(new String(cArray), 0, this.getCharCount());
            if (string == null) {
                return;
            }
            cArray = new char[string.length()];
            string.getChars(0, cArray.length, cArray, 0);
        }
        this.setText(cArray);
    }

    void setText(char[] cArray) {
        this.clearSegments(false);
        if ((this.style & 4) != 0) {
            byte[] byArray = Converter.wcsToMbcs(null, cArray, true);
            OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0, 0, 6);
            OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0, 0, 13);
            OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0, 0, 26);
            OS.gtk_entry_set_text(this.handle, byArray);
            OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0, 0, 6);
            OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0, 0, 13);
            OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0, 0, 26);
            Arrays.fill(byArray, (byte)0);
        } else {
            byte[] byArray = Converter.wcsToMbcs(null, cArray, false);
            byte[] byArray2 = new byte[ITER_SIZEOF];
            OS.g_signal_handlers_block_matched(this.bufferHandle, 16, 0, 0, 0, 0, 6);
            OS.g_signal_handlers_block_matched(this.bufferHandle, 16, 0, 0, 0, 0, 12);
            OS.g_signal_handlers_block_matched(this.bufferHandle, 16, 0, 0, 0, 0, 52);
            OS.gtk_text_buffer_set_text(this.bufferHandle, byArray, byArray.length);
            OS.g_signal_handlers_unblock_matched(this.bufferHandle, 16, 0, 0, 0, 0, 6);
            OS.g_signal_handlers_unblock_matched(this.bufferHandle, 16, 0, 0, 0, 0, 12);
            OS.g_signal_handlers_unblock_matched(this.bufferHandle, 16, 0, 0, 0, 0, 52);
            OS.gtk_text_buffer_get_iter_at_offset(this.bufferHandle, byArray2, 0);
            OS.gtk_text_buffer_place_cursor(this.bufferHandle, byArray2);
            int n = OS.gtk_text_buffer_get_insert(this.bufferHandle);
            OS.gtk_text_view_scroll_mark_onscreen(this.handle, n);
            Arrays.fill(byArray, (byte)0);
        }
        this.sendEvent(24);
        if ((this.style & 0x80) != 0 && (this.style & 0x100) != 0) {
            OS.gtk_entry_set_icon_sensitive(this.handle, 1, true);
        }
        this.applySegments();
    }

    public void setTextLimit(int n) {
        this.checkWidget();
        if (n == 0) {
            this.error(7);
        }
        if ((this.style & 4) != 0) {
            OS.gtk_entry_set_max_length(this.handle, this.segments != null ? Math.min(LIMIT, this.translateOffset(n)) : n);
        }
    }

    public void setTopIndex(int n) {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return;
        }
        byte[] byArray = new byte[ITER_SIZEOF];
        OS.gtk_text_buffer_get_iter_at_line(this.bufferHandle, byArray, n);
        OS.gtk_text_view_scroll_to_iter(this.handle, byArray, 0.0, true, 0.0, 0.0);
    }

    public void showSelection() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return;
        }
        int n = OS.gtk_text_buffer_get_selection_bound(this.bufferHandle);
        OS.gtk_text_view_scroll_mark_onscreen(this.handle, n);
        n = OS.gtk_text_buffer_get_insert(this.bufferHandle);
        OS.gtk_text_view_scroll_mark_onscreen(this.handle, n);
    }

    int translateOffset(int n) {
        if (this.segments == null) {
            return n;
        }
        int n2 = this.segments.length;
        for (int i = 0; i < n2 && n - i >= this.segments[i]; ++i) {
            ++n;
        }
        return n;
    }

    @Override
    boolean translateTraversal(GdkEventKey gdkEventKey) {
        int n = gdkEventKey.keyval;
        switch (n) {
            case 65293: 
            case 65421: {
                int n2 = this.imContext();
                if (n2 == 0) break;
                int[] nArray = new int[1];
                OS.gtk_im_context_get_preedit_string(n2, nArray, null, null);
                if (nArray[0] == 0) break;
                int n3 = OS.strlen(nArray[0]);
                OS.g_free(nArray[0]);
                if (n3 == 0) break;
                return false;
            }
        }
        return super.translateTraversal(gdkEventKey);
    }

    @Override
    int traversalCode(int n, GdkEventKey gdkEventKey) {
        int n2 = super.traversalCode(n, gdkEventKey);
        if ((this.style & 8) != 0) {
            return n2;
        }
        if ((this.style & 2) != 0) {
            n2 &= 0xFFFFFFFB;
            if (n == 65289 && gdkEventKey != null) {
                boolean bl;
                boolean bl2 = bl = (gdkEventKey.state & 1) == 0;
                if (bl && (gdkEventKey.state & 4) == 0) {
                    n2 &= 0xFFFFFFE7;
                }
            }
        }
        return n2;
    }

    int untranslateOffset(int n) {
        if (this.segments == null) {
            return n;
        }
        int n2 = this.segments.length;
        for (int i = 0; i < n2 && n > this.segments[i]; --n, ++i) {
        }
        return n;
    }

    String verifyText(String string, int n, int n2) {
        if (string != null && string.length() == 0 && n == n2) {
            return null;
        }
        Event event = new Event();
        event.text = string;
        event.start = n;
        event.end = n2;
        int n3 = OS.gtk_get_current_event();
        if (n3 != 0) {
            GdkEventKey gdkEventKey = new GdkEventKey();
            OS.memmove(gdkEventKey, n3, GdkEventKey.sizeof);
            switch (gdkEventKey.type) {
                case 8: {
                    this.setKeyState(event, gdkEventKey);
                }
            }
            OS.gdk_event_free(n3);
        }
        this.sendEvent(25, event);
        if (!event.doit || this.isDisposed()) {
            return null;
        }
        return event.text;
    }

    @Override
    int windowProc(int n, int n2) {
        if (this.hooks(49) || this.filters(49) || this.segments != null) {
            switch (n2) {
                case 70: 
                case 72: 
                case 74: 
                case 76: {
                    this.clearSegments(true);
                    break;
                }
                case 71: 
                case 73: 
                case 75: 
                case 77: {
                    this.applySegments();
                }
            }
        }
        return super.windowProc(n, n2);
    }

    @Override
    int windowProc(int n, int n2, int n3) {
        if (this.hooks(49) || this.filters(49) || this.segments != null) {
            switch (n3) {
                case 82: {
                    this.clearSegments(true);
                    this.applySegments();
                }
            }
        }
        return super.windowProc(n, n2, n3);
    }

    @Override
    int windowProc(int n, int n2, int n3, int n4) {
        if (this.hooks(49) || this.filters(49) || this.segments != null) {
            switch (n4) {
                case 78: {
                    this.clearSegments(true);
                    break;
                }
                case 79: {
                    this.applySegments();
                }
            }
        }
        return super.windowProc(n, n2, n3, n4);
    }

    @Override
    int windowProc(int n, int n2, int n3, int n4, int n5) {
        if (this.hooks(49) || this.filters(49) || this.segments != null) {
            switch (n5) {
                case 80: {
                    if (n2 != 1) break;
                    this.clearSegments(true);
                    break;
                }
                case 81: {
                    if (n2 != 1) break;
                    this.applySegments();
                }
            }
        }
        return super.windowProc(n, n2, n3, n4, n5);
    }
}

