/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.downloadtasks;

import java.io.IOException;
import java.net.URL;
import java.util.concurrent.Future;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.downloadtasks.AbstractDownloadTask;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.gpx.GpxData;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.markerlayer.MarkerLayer;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.gui.progress.ProgressTaskId;
import org.openstreetmap.josm.gui.progress.ProgressTaskIds;
import org.openstreetmap.josm.io.BoundingBoxDownloader;
import org.openstreetmap.josm.io.GpxImporter;
import org.openstreetmap.josm.io.OsmServerLocationReader;
import org.openstreetmap.josm.io.OsmServerReader;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.xml.sax.SAXException;

public class DownloadGpsTask
extends AbstractDownloadTask<GpxData> {
    private DownloadTask downloadTask;
    private static final String PATTERN_TRACE_ID = "https?://.*(osm|openstreetmap).org/trace/\\p{Digit}+/data";
    private static final String PATTERN_TRACKPOINTS_BBOX = "https?://.*/api/0.6/trackpoints\\?bbox=.*,.*,.*,.*";
    private static final String PATTERN_EXTERNAL_GPX_SCRIPT = "https?://.*exportgpx.*";
    private static final String PATTERN_EXTERNAL_GPX_FILE = "https?://.*/(.*\\.gpx)";
    protected String newLayerName;

    @Override
    public String[] getPatterns() {
        return new String[]{PATTERN_EXTERNAL_GPX_FILE, PATTERN_EXTERNAL_GPX_SCRIPT, PATTERN_TRACE_ID, PATTERN_TRACKPOINTS_BBOX};
    }

    @Override
    public String getTitle() {
        return I18n.tr("Download GPS", new Object[0]);
    }

    @Override
    public Future<?> download(boolean bl, Bounds bounds, ProgressMonitor progressMonitor) {
        this.downloadTask = new DownloadTask(bl, new BoundingBoxDownloader(bounds), progressMonitor);
        return Main.worker.submit(this.downloadTask);
    }

    @Override
    public Future<?> loadUrl(boolean bl, String string, ProgressMonitor progressMonitor) {
        CheckParameterUtil.ensureParameterNotNull(string, "url");
        if (string.matches(PATTERN_TRACE_ID) || string.matches(PATTERN_EXTERNAL_GPX_SCRIPT) || string.matches(PATTERN_EXTERNAL_GPX_FILE)) {
            this.downloadTask = new DownloadTask(bl, new OsmServerLocationReader(string), progressMonitor);
            Matcher matcher = Pattern.compile(PATTERN_EXTERNAL_GPX_FILE).matcher(string);
            this.newLayerName = matcher.matches() ? matcher.group(1) : null;
            return Main.worker.submit(this.downloadTask);
        }
        if (string.matches(PATTERN_TRACKPOINTS_BBOX)) {
            String[] stringArray = string.split("\\?|=|&");
            for (int i = 0; i < stringArray.length; ++i) {
                if (!"bbox".equals(stringArray[i]) || i >= stringArray.length - 1) continue;
                return this.download(bl, new Bounds(stringArray[i + 1], ",", Bounds.ParseMethod.LEFT_BOTTOM_RIGHT_TOP), progressMonitor);
            }
        }
        return null;
    }

    @Override
    public void cancel() {
        if (this.downloadTask != null) {
            this.downloadTask.cancel();
        }
    }

    @Override
    public String getConfirmationMessage(URL uRL) {
        return null;
    }

    @Override
    public boolean isSafeForRemotecontrolRequests() {
        return true;
    }

    public static final boolean isFromServer(String string) {
        return string != null && (string.matches(PATTERN_TRACE_ID) || string.matches(PATTERN_TRACKPOINTS_BBOX));
    }

    class DownloadTask
    extends PleaseWaitRunnable {
        private final OsmServerReader reader;
        private GpxData rawData;
        private final boolean newLayer;

        DownloadTask(boolean bl, OsmServerReader osmServerReader, ProgressMonitor progressMonitor) {
            super(I18n.tr("Downloading GPS data", new Object[0]), progressMonitor, false);
            this.reader = osmServerReader;
            this.newLayer = bl;
        }

        @Override
        public void realRun() throws IOException, SAXException, OsmTransferException {
            try {
                if (DownloadGpsTask.this.isCanceled()) {
                    return;
                }
                ProgressMonitor progressMonitor = this.progressMonitor.createSubTaskMonitor(-1, false);
                this.rawData = this.reader.parseRawGps(progressMonitor);
            }
            catch (OsmTransferException osmTransferException) {
                if (DownloadGpsTask.this.isCanceled()) {
                    return;
                }
                DownloadGpsTask.this.rememberException(osmTransferException);
            }
        }

        @Override
        protected void finish() {
            DownloadGpsTask.this.rememberDownloadedData(this.rawData);
            if (this.rawData == null) {
                return;
            }
            String string = DownloadGpsTask.this.newLayerName != null ? DownloadGpsTask.this.newLayerName : I18n.tr("Downloaded GPX Data", new Object[0]);
            GpxImporter.GpxImporterData gpxImporterData = GpxImporter.loadLayers(this.rawData, this.reader.isGpxParsedProperly(), string, I18n.tr("Markers from {0}", string));
            GpxLayer gpxLayer = this.addOrMergeLayer(gpxImporterData.getGpxLayer(), this.findGpxMergeLayer());
            this.addOrMergeLayer(gpxImporterData.getMarkerLayer(), this.findMarkerMergeLayer(gpxLayer));
            gpxImporterData.getPostLayerTask().run();
        }

        private <L extends Layer> L addOrMergeLayer(L l, L l2) {
            if (l == null) {
                return null;
            }
            if (this.newLayer || l2 == null) {
                if (Main.main != null) {
                    Main.main.addLayer(l);
                }
                return l;
            }
            l2.mergeFrom(l);
            if (Main.map != null) {
                Main.map.repaint();
            }
            return l2;
        }

        private GpxLayer findGpxMergeLayer() {
            boolean bl = Main.pref.getBoolean("download.gps.mergeWithLocal", false);
            Layer layer = Main.getLayerManager().getActiveLayer();
            if (layer instanceof GpxLayer && (bl || ((GpxLayer)layer).data.fromServer)) {
                return (GpxLayer)layer;
            }
            for (GpxLayer gpxLayer : Main.getLayerManager().getLayersOfType(GpxLayer.class)) {
                if (!bl && !gpxLayer.data.fromServer) continue;
                return gpxLayer;
            }
            return null;
        }

        private MarkerLayer findMarkerMergeLayer(GpxLayer gpxLayer) {
            for (MarkerLayer markerLayer : Main.getLayerManager().getLayersOfType(MarkerLayer.class)) {
                if (gpxLayer == null || markerLayer.fromLayer != gpxLayer) continue;
                return markerLayer;
            }
            return null;
        }

        @Override
        protected void cancel() {
            DownloadGpsTask.this.setCanceled(true);
            if (this.reader != null) {
                this.reader.cancel();
            }
        }

        @Override
        public ProgressTaskId canRunInBackground() {
            return ProgressTaskIds.DOWNLOAD_GPS;
        }
    }
}

