/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.layer;

import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.AbstractAction;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.dialogs.LayerListDialog;
import org.openstreetmap.josm.gui.dialogs.layer.IEnabledStateUpdating;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.MultikeyShortcutAction;
import org.openstreetmap.josm.tools.Shortcut;

public final class ActivateLayerAction
extends AbstractAction
implements IEnabledStateUpdating,
MapView.LayerChangeListener,
MultikeyShortcutAction {
    private transient Layer layer;
    private transient Shortcut multikeyShortcut;
    private final LayerListDialog.LayerListModel model;

    public ActivateLayerAction(Layer layer, LayerListDialog.LayerListModel layerListModel) {
        this(layerListModel);
        CheckParameterUtil.ensureParameterNotNull(layer, "layer");
        this.layer = layer;
        this.putValue("Name", I18n.tr("Activate", new Object[0]));
        this.updateEnabledState();
    }

    public ActivateLayerAction(LayerListDialog.LayerListModel layerListModel) {
        this.model = layerListModel;
        this.putValue("Name", I18n.tr("Activate", new Object[0]));
        this.putValue("SmallIcon", ImageProvider.get("dialogs", "activate"));
        this.putValue("ShortDescription", I18n.tr("Activate the selected layer", new Object[0]));
        this.multikeyShortcut = Shortcut.registerShortcut("core_multikey:activateLayer", I18n.tr("Multikey: {0}", I18n.tr("Activate layer", new Object[0])), 65, 5005);
        this.multikeyShortcut.setAccelerator(this);
        this.putValue("help", HelpUtil.ht("/Dialog/LayerList#ActivateLayer"));
    }

    @Override
    public Shortcut getMultikeyShortcut() {
        return this.multikeyShortcut;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Layer layer = this.layer != null ? this.layer : this.model.getSelectedLayers().get(0);
        this.execute(layer);
    }

    private void execute(Layer layer) {
        Main.map.mapView.setActiveLayer(layer);
        layer.setVisible(true);
    }

    protected boolean isActiveLayer(Layer layer) {
        if (!Main.isDisplayingMapView()) {
            return false;
        }
        return Main.map.mapView.getActiveLayer() == layer;
    }

    @Override
    public void updateEnabledState() {
        GuiHelper.runInEDTAndWait(new Runnable(){

            @Override
            public void run() {
                if (ActivateLayerAction.this.layer == null) {
                    if (ActivateLayerAction.this.model.getSelectedLayers().size() != 1) {
                        ActivateLayerAction.this.setEnabled(false);
                        return;
                    }
                    ActivateLayerAction.this.setEnabled(!ActivateLayerAction.this.isActiveLayer(ActivateLayerAction.this.model.getSelectedLayers().get(0)));
                } else {
                    ActivateLayerAction.this.setEnabled(!ActivateLayerAction.this.isActiveLayer(ActivateLayerAction.this.layer));
                }
            }
        });
    }

    @Override
    public void activeLayerChange(Layer layer, Layer layer2) {
        this.updateEnabledState();
    }

    @Override
    public void layerAdded(Layer layer) {
        this.updateEnabledState();
    }

    @Override
    public void layerRemoved(Layer layer) {
        this.updateEnabledState();
    }

    @Override
    public void executeMultikeyAction(int n, boolean bl) {
        Layer layer = LayerListDialog.getLayerForIndex(n);
        if (layer != null) {
            this.execute(layer);
        }
    }

    @Override
    public List<MultikeyShortcutAction.MultikeyInfo> getMultikeyCombinations() {
        return LayerListDialog.getLayerInfoByClass(Layer.class);
    }

    @Override
    public MultikeyShortcutAction.MultikeyInfo getLastMultikeyAction() {
        return null;
    }
}

