/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.relation;

import java.awt.Container;
import java.awt.Dialog;
import java.io.IOException;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreePath;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.DataSetMerger;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.dialogs.relation.RelationTreeCellRenderer;
import org.openstreetmap.josm.gui.dialogs.relation.RelationTreeModel;
import org.openstreetmap.josm.gui.progress.PleaseWaitProgressMonitor;
import org.openstreetmap.josm.io.OsmApi;
import org.openstreetmap.josm.io.OsmServerObjectReader;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.I18n;
import org.xml.sax.SAXException;

public class RelationTree
extends JTree {
    protected void build() {
        this.setRootVisible(false);
        this.setCellRenderer(new RelationTreeCellRenderer());
        this.addTreeWillExpandListener(new LazyRelationLoader());
    }

    public RelationTree() {
        this.build();
    }

    public RelationTree(RelationTreeModel relationTreeModel) {
        super(relationTreeModel);
        this.build();
    }

    protected Dialog getParentDialog() {
        Container container;
        for (container = this; container != null && !(container instanceof Dialog); container = container.getParent()) {
        }
        return (Dialog)container;
    }

    class RelationLoader
    extends PleaseWaitRunnable {
        private boolean canceled;
        private Exception lastException;
        private final Relation relation;
        private DataSet ds;
        private final TreePath path;

        RelationLoader(Dialog dialog, Relation relation, TreePath treePath) {
            super(I18n.tr("Load relation", new Object[0]), new PleaseWaitProgressMonitor(dialog), false);
            this.relation = relation;
            this.path = treePath;
        }

        @Override
        protected void cancel() {
            OsmApi.getOsmApi().cancel();
            this.canceled = true;
        }

        @Override
        protected void finish() {
            if (this.canceled) {
                return;
            }
            if (this.lastException != null) {
                Main.error(this.lastException);
                return;
            }
            DataSetMerger dataSetMerger = new DataSetMerger(Main.main.getEditLayer().data, this.ds);
            dataSetMerger.merge();
            if (!dataSetMerger.getConflicts().isEmpty()) {
                Main.main.getEditLayer().getConflicts().add(dataSetMerger.getConflicts());
            }
            final RelationTreeModel relationTreeModel = (RelationTreeModel)RelationTree.this.getModel();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    relationTreeModel.refreshNode(RelationLoader.this.path);
                }
            });
        }

        @Override
        protected void realRun() throws SAXException, IOException, OsmTransferException {
            try {
                OsmServerObjectReader osmServerObjectReader = new OsmServerObjectReader(this.relation.getId(), OsmPrimitiveType.from(this.relation), true);
                this.ds = osmServerObjectReader.parseOsm(this.progressMonitor.createSubTaskMonitor(-1, false));
            }
            catch (OsmTransferException osmTransferException) {
                if (this.canceled) {
                    Main.warn(I18n.tr("Ignoring exception because task was canceled. Exception: {0}", osmTransferException.toString()));
                    return;
                }
                this.lastException = osmTransferException;
            }
        }
    }

    class LazyRelationLoader
    implements TreeWillExpandListener {
        LazyRelationLoader() {
        }

        @Override
        public void treeWillCollapse(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
        }

        @Override
        public void treeWillExpand(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
            TreePath treePath = treeExpansionEvent.getPath();
            Relation relation = (Relation)treeExpansionEvent.getPath().getLastPathComponent();
            if (!relation.isIncomplete() || relation.isNew()) {
                return;
            }
            Main.worker.submit(new RelationLoader(RelationTree.this.getParentDialog(), relation, treePath));
        }
    }
}

