/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.dsl.internal;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.dsl.internal.DSLMetadata;
import com.oracle.truffle.api.dsl.internal.DSLNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import java.util.Arrays;
import java.util.concurrent.Callable;

public class DSLShare {
    public static boolean isExcluded(Node currentNode, DSLMetadata otherMetadata) {
        CompilerAsserts.neverPartOfCompilation("do not call DSLShare.isExcluded from compiled code");
        assert (otherMetadata.getExcludedBy().length > 0) : "At least one exclude must be defined for isIncluded.";
        Node cur = DSLShare.findRoot(currentNode);
        while (cur != null) {
            Class<?> curClass = cur.getClass();
            if (curClass == otherMetadata.getSpecializationClass()) {
                return true;
            }
            if (DSLShare.containsClass(otherMetadata.getExcludedBy(), cur)) {
                return true;
            }
            cur = DSLShare.getNext(cur);
        }
        return false;
    }

    private static boolean includes(Node oldNode, DSLNode newNode) {
        return DSLShare.containsClass(newNode.getMetadata0().getIncludes(), oldNode);
    }

    public static <T extends Node> T rewrite(final Node thisNode, final T newNode, final String message) {
        CompilerAsserts.neverPartOfCompilation("do not call DSLShare.rewrite from compiled code");
        return (T)((Node)thisNode.atomic(new Callable<T>(){

            @Override
            public T call() {
                assert (newNode != null);
                if (DSLShare.getNext(thisNode) != null || DSLShare.getPrevious(thisNode) != null) {
                    return DSLShare.appendPolymorphic(DSLShare.findUninitialized(thisNode), newNode);
                }
                if (DSLShare.includes(thisNode, (DSLNode)((Object)newNode))) {
                    ((DSLNode)((Object)newNode)).adoptChildren0(thisNode, null);
                    return thisNode.replace(newNode, message);
                }
                return null;
            }
        }));
    }

    public static <T extends Node> T findRoot(T node) {
        T cur;
        CompilerAsserts.neverPartOfCompilation("do not call DSLShare.findRoot from compiled code");
        Object prev = node;
        while ((prev = DSLShare.getPrevious(cur = prev)) != null) {
        }
        return cur;
    }

    private static Node findUninitialized(Node node) {
        Node cur;
        Node next = node;
        while ((next = DSLShare.getNext(cur = next)) != null) {
        }
        return cur;
    }

    public static <T extends Node> T rewriteUninitialized(final Node uninitialized, final T newNode) {
        CompilerAsserts.neverPartOfCompilation("do not call DSLShare.rewriteUninitialized from compiled code");
        return (T)((Node)uninitialized.atomic(new Callable<T>(){

            @Override
            public T call() {
                Node prev = DSLShare.getPrevious(uninitialized);
                if (prev == null) {
                    ((DSLNode)((Object)newNode)).adoptChildren0(uninitialized, null);
                    return uninitialized.replace(newNode, "Uninitialized monomorphic");
                }
                return DSLShare.appendPolymorphic(uninitialized, newNode);
            }
        }));
    }

    public static <T extends Node> T rewriteToPolymorphic(final Node oldNode, final DSLNode uninitializedDSL, final T polymorphic, final DSLNode currentCopy, final DSLNode newNodeDSL, final String message) {
        CompilerAsserts.neverPartOfCompilation("do not call DSLShare.rewriteToPolymorphic from compiled code");
        return (T)((Node)oldNode.atomic(new Callable<T>(){

            @Override
            public T call() {
                assert (DSLShare.getNext(oldNode) == null);
                assert (DSLShare.getPrevious(oldNode) == null);
                assert (newNodeDSL != null);
                Node uninitialized = (Node)((Object)uninitializedDSL);
                Node newNode = (Node)((Object)newNodeDSL);
                ((DSLNode)((Object)polymorphic)).adoptChildren0(oldNode, (Node)((Object)currentCopy));
                DSLShare.updateSourceSection(oldNode, uninitialized);
                DSLShare.updateSourceSection(oldNode, newNode);
                newNodeDSL.adoptChildren0(null, uninitialized);
                currentCopy.adoptChildren0(null, newNode);
                oldNode.replace(polymorphic, message);
                assert (newNode == null ? currentCopy.getNext0() == uninitialized : currentCopy.getNext0() == newNode);
                assert (uninitializedDSL.getNext0() == null);
                return polymorphic;
            }
        }));
    }

    private static void updateSourceSection(Node oldNode, Node newNode) {
        if (newNode.getSourceSection() == null) {
            throw new IllegalArgumentException("Can't update source: " + oldNode);
        }
    }

    private static Class<?>[] mergeTypes(DSLNode node, Class<?>[] types) {
        Class<?>[] specializedTypes = node.getMetadata0().getSpecializedTypes();
        if (specializedTypes.length == 0) {
            return null;
        }
        if (types == null) {
            return Arrays.copyOf(specializedTypes, specializedTypes.length);
        }
        for (int i = 0; i < specializedTypes.length; ++i) {
            if (specializedTypes[i] == types[i]) continue;
            types[i] = Object.class;
        }
        return types;
    }

    private static <T extends Node> T appendPolymorphic(Node uninitialized, T newNode) {
        Class<?>[] includes = ((DSLNode)((Object)newNode)).getMetadata0().getIncludes();
        Node cur = DSLShare.getPrevious(uninitialized);
        Node prev = uninitialized;
        int depth = 0;
        Class<?>[] types = null;
        while (cur != null) {
            if (DSLShare.containsClass(includes, cur)) {
                cur.replace(prev, "Included in other specialization");
                cur = prev;
            } else {
                ++depth;
                types = DSLShare.mergeTypes((DSLNode)((Object)cur), types);
            }
            prev = cur;
            cur = DSLShare.getPrevious(cur);
        }
        assert (prev.getCost() == NodeCost.POLYMORPHIC);
        DSLShare.updateSourceSection(prev, newNode);
        if (depth <= 1) {
            ((DSLNode)((Object)newNode)).adoptChildren0(prev, null);
            return prev.replace(newNode, "Polymorphic to monomorphic.");
        }
        ((DSLNode)((Object)newNode)).adoptChildren0(null, uninitialized);
        ((DSLNode)((Object)prev)).updateTypes0(DSLShare.mergeTypes((DSLNode)((Object)newNode), types));
        return uninitialized.replace(newNode, "Appended polymorphic");
    }

    private static boolean containsClass(Class<?>[] classList, Node node) {
        Class<?> nodeClass = node.getClass();
        for (Class<?> toCheck : classList) {
            if (nodeClass != toCheck || node.getCost() == NodeCost.UNINITIALIZED) continue;
            return true;
        }
        return false;
    }

    private static Node getNext(Node node) {
        return ((DSLNode)((Object)node)).getNext0();
    }

    private static Node getPrevious(Node node) {
        Node parent = node.getParent();
        if (parent instanceof DSLNode && DSLShare.getNext(parent) == node) {
            return parent;
        }
        return null;
    }
}

