/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.openide.modules;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import javax.tools.StandardLocation;
import org.openide.modules.PatchedPublic;

@SupportedSourceVersion(value=SourceVersion.RELEASE_6)
public class PatchedPublicProcessor
extends AbstractProcessor {
    private List<Element> originatingElements;

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return Collections.singleton(PatchedPublic.class.getCanonicalName());
    }

    @Override
    public synchronized void init(ProcessingEnvironment processingEnvironment) {
        super.init(processingEnvironment);
        this.originatingElements = new ArrayList<Element>();
    }

    @Override
    public boolean process(Set<? extends TypeElement> set, RoundEnvironment roundEnvironment) {
        if (roundEnvironment.processingOver()) {
            if (!this.originatingElements.isEmpty()) {
                try {
                    this.processingEnv.getFiler().createResource(StandardLocation.CLASS_OUTPUT, "", "META-INF/.bytecodePatched", this.originatingElements.toArray(new Element[this.originatingElements.size()])).openOutputStream().close();
                }
                catch (IOException iOException) {
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, iOException.getMessage());
                }
            }
            return false;
        }
        for (Element element : roundEnvironment.getElementsAnnotatedWith(PatchedPublic.class)) {
            if (element.getAnnotationMirrors().size() > 1) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Cannot currently mix @PatchedPublic with other annotations", element);
                continue;
            }
            if (element.getModifiers().contains((Object)Modifier.PUBLIC)) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "@PatchedPublic cannot be applied to what is already public", element);
                continue;
            }
            this.originatingElements.add(element);
        }
        return true;
    }
}

