/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.netbeans.api.autoupdate.UpdateUnitProvider;
import org.netbeans.api.options.OptionsDisplayer;
import org.netbeans.modules.autoupdate.ui.Bundle;
import org.netbeans.modules.autoupdate.ui.DetailsPanel;
import org.netbeans.modules.autoupdate.ui.PluginManagerUI;
import org.netbeans.modules.autoupdate.ui.SettingsTableModel;
import org.netbeans.modules.autoupdate.ui.UnitDetails;
import org.netbeans.modules.autoupdate.ui.UnitTab;
import org.netbeans.modules.autoupdate.ui.UnitTable;
import org.netbeans.modules.autoupdate.ui.UpdateUnitProviderPanel;
import org.netbeans.modules.autoupdate.ui.Utilities;
import org.netbeans.modules.autoupdate.ui.actions.AutoupdateSettings;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public class SettingsTab
extends JPanel {
    private DetailsPanel details;
    private JScrollPane scrollerForDetails;
    private JTable table;
    private JScrollPane scrollerForTable;
    private Action removeAction;
    private Action editAction;
    private Action addAction;
    private Listener listener;
    private PluginManagerUI manager;
    private boolean refreshModel;
    private JButton addButton;
    private JButton bProxy;
    private JComboBox cbCheckPeriod;
    private JComboBox cbLocation;
    private JSeparator jSeparatorAdvanced;
    private JSeparator jSeparatorConnection;
    private JLabel lCheckPeriod;
    private JLabel lConnection;
    private JLabel lGeneral;
    private JLabel lLocation;
    private JLabel lUpdateCenters;
    private ButtonGroup pluginsViewGroup;
    private JSplitPane spTab;

    public SettingsTab(PluginManagerUI pluginManagerUI) {
        this.manager = pluginManagerUI;
        this.initComponents();
        this.scrollerForTable = new JScrollPane();
        this.table = new Table();
        this.scrollerForTable.setViewportView(this.table);
        this.scrollerForDetails = new JScrollPane();
        this.details = new DetailsPanel();
        this.scrollerForDetails.setViewportView(this.details);
        this.spTab.setLeftComponent(this.scrollerForTable);
        this.spTab.setRightComponent(this.scrollerForDetails);
        this.table.setModel(new SettingsTableModel());
        this.table.setSelectionMode(0);
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        tableColumnModel.getColumn(1).setCellRenderer(new UpdateProviderRenderer());
        this.cbCheckPeriod.setModel(new DefaultComboBoxModel<String>(new String[]{SettingsTab.getMessage("CTL_Update_every_startup"), SettingsTab.getMessage("CTL_Update_every_day"), SettingsTab.getMessage("CTL_Update_every_week"), SettingsTab.getMessage("CTL_Update_every_2weeks"), SettingsTab.getMessage("CTL_Update_every_month"), SettingsTab.getMessage("CTL_Update_never")}));
        if (6 == this.getAutoUpdatePeriod()) {
            this.cbCheckPeriod.addItem(SettingsTab.getMessage("CTL_Update_custom"));
        }
        this.cbCheckPeriod.setSelectedIndex(this.getAutoUpdatePeriod());
        this.cbLocation.setModel(new DefaultComboBoxModel<String>(new String[]{Bundle.cbLocation_InstallDefault(), Bundle.cbLocation_InstallGlobal(), Bundle.cbLocation_InstallLocal()}));
        this.cbLocation.setSelectedIndex(Utilities.isGlobalInstallation() == null ? 0 : (Utilities.isGlobalInstallation() != false ? 1 : 2));
        this.getSettingsTableModel().setSettingsTab(this);
        TableColumn tableColumn = this.table.getColumnModel().getColumn(0);
        tableColumn.setMaxWidth(this.table.getTableHeader().getHeaderRect((int)0).width);
        this.editAction = new EditAction();
        this.removeAction = new RemoveAction();
        this.addAction = new AddAction();
        this.addButton.setAction(this.addAction);
    }

    public String getDisplayName() {
        return NbBundle.getMessage(SettingsTab.class, (String)"SettingsTab_displayName");
    }

    PluginManagerUI getPluginManager() {
        return this.manager;
    }

    private synchronized void attachListener() {
        if (this.listener == null) {
            this.listener = new Listener();
            this.table.getSelectionModel().addListSelectionListener(this.listener);
            this.getSettingsTableModel().addTableModelListener(this.listener);
        }
    }

    private synchronized void removeListener() {
        if (this.listener != null) {
            this.table.getSelectionModel().removeListSelectionListener(this.listener);
            this.getSettingsTableModel().removeTableModelListener(this.listener);
            this.listener = null;
        }
    }

    public int getSelectedRow() {
        if (this.table != null) {
            return this.table.getSelectedRow();
        }
        return -1;
    }

    public int setSelectedRow(int n) {
        if (this.table != null && this.table.getModel().getRowCount() > n) {
            this.table.getSelectionModel().setSelectionInterval(n, n);
        }
        return -1;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.attachListener();
        Utilities.startAsWorkerThread(new Runnable(){

            @Override
            public void run() {
                SettingsTab.this.getSettingsTableModel().refreshModel();
                if (SettingsTab.this.getSettingsTableModel().getRowCount() > 0) {
                    SettingsTab.this.table.getSelectionModel().setSelectionInterval(0, 0);
                }
            }
        });
        this.refreshModel = false;
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.removeListener();
        this.doLazyRefresh(null);
    }

    public void doLazyRefresh(final Runnable runnable) {
        if (this.needRefresh()) {
            Utilities.startAsWorkerThread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    SettingsTab.this.setWaitingState(true);
                    try {
                        Utilities.presentRefreshProviders(SettingsTab.this.manager, false);
                        SettingsTab.this.manager.updateUnitsChanged();
                        if (runnable != null) {
                            runnable.run();
                        }
                    }
                    finally {
                        SettingsTab.this.setWaitingState(false);
                    }
                }
            });
        }
        this.refreshModel = false;
    }

    private static String getMessage(String string) {
        return NbBundle.getMessage(SettingsTab.class, (String)string);
    }

    private void initComponents() {
        this.pluginsViewGroup = new ButtonGroup();
        this.lUpdateCenters = new JLabel();
        this.spTab = new JSplitPane();
        this.addButton = new JButton();
        this.lConnection = new JLabel();
        this.jSeparatorConnection = new JSeparator();
        this.lCheckPeriod = new JLabel();
        this.cbCheckPeriod = new JComboBox();
        this.bProxy = new JButton();
        this.lGeneral = new JLabel();
        this.jSeparatorAdvanced = new JSeparator();
        this.lLocation = new JLabel();
        this.cbLocation = new JComboBox();
        Mnemonics.setLocalizedText((JLabel)this.lUpdateCenters, (String)NbBundle.getMessage(SettingsTab.class, (String)"SettingsTab.lUpdateCenters.text"));
        this.spTab.setBorder(null);
        this.spTab.setDividerLocation(Integer.parseInt(NbBundle.getMessage(SettingsTab.class, (String)"SettingsTab_Splitter_DefaultDividerLocation")));
        this.spTab.setResizeWeight(0.5);
        this.spTab.setOneTouchExpandable(true);
        Mnemonics.setLocalizedText((AbstractButton)this.addButton, (String)NbBundle.getMessage(SettingsTab.class, (String)"SettingsTab.addButton.text"));
        Mnemonics.setLocalizedText((JLabel)this.lConnection, (String)NbBundle.getMessage(SettingsTab.class, (String)"SettingsTab.lConnection.text"));
        this.lCheckPeriod.setLabelFor(this.cbCheckPeriod);
        Mnemonics.setLocalizedText((JLabel)this.lCheckPeriod, (String)NbBundle.getMessage(SettingsTab.class, (String)"SettingsTab.lCheckPeriod.text"));
        this.cbCheckPeriod.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SettingsTab.this.cbCheckPeriodActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.bProxy, (String)NbBundle.getMessage(SettingsTab.class, (String)"SettingsTab.bProxy.text"));
        this.bProxy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SettingsTab.this.bProxyActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.lGeneral, (String)NbBundle.getMessage(SettingsTab.class, (String)"SettingsTab.lGeneral.text"));
        this.lLocation.setLabelFor(this.cbLocation);
        Mnemonics.setLocalizedText((JLabel)this.lLocation, (String)NbBundle.getMessage(SettingsTab.class, (String)"SettingsTab.lLocation.text"));
        this.cbLocation.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SettingsTab.this.cbLocationActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.addButton).addComponent(this.spTab, -1, 871, Short.MAX_VALUE)).addGap(1, 1, 1)).addGroup(groupLayout.createSequentialGroup().addComponent(this.lGeneral).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparatorAdvanced, -1, 792, Short.MAX_VALUE)).addGroup(groupLayout.createSequentialGroup().addComponent(this.lConnection).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparatorConnection, -1, 630, Short.MAX_VALUE)).addComponent(this.lUpdateCenters).addGroup(groupLayout.createSequentialGroup().addGap(12, 12, 12).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this.lLocation).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbLocation, -2, -1, -2).addGap(0, 0, Short.MAX_VALUE)).addGroup(groupLayout.createSequentialGroup().addComponent(this.lCheckPeriod).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbCheckPeriod, 0, 548, Short.MAX_VALUE).addGap(58, 58, 58).addComponent(this.bProxy))))).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addContainerGap().addComponent(this.lUpdateCenters).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.spTab, -1, 32, Short.MAX_VALUE).addGap(4, 4, 4).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(groupLayout.createSequentialGroup().addComponent(this.addButton).addGap(11, 11, 11).addComponent(this.jSeparatorConnection, -2, 10, -2)).addComponent(this.lConnection)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.bProxy).addComponent(this.lCheckPeriod).addComponent(this.cbCheckPeriod, -2, -1, -2)).addGap(11, 11, 11).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.lGeneral, -2, 15, -2).addComponent(this.jSeparatorAdvanced, -2, 10, -2)).addGap(7, 7, 7).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lLocation).addComponent(this.cbLocation, -2, -1, -2)).addContainerGap()));
    }

    private void cbCheckPeriodActionPerformed(ActionEvent actionEvent) {
        this.setAutoUpdatePeriod(this.cbCheckPeriod.getSelectedIndex());
    }

    private void bProxyActionPerformed(ActionEvent actionEvent) {
        OptionsDisplayer.getDefault().open("General");
    }

    private void cbLocationActionPerformed(ActionEvent actionEvent) {
        block0 : switch (this.cbLocation.getSelectedIndex()) {
            case 0: {
                Utilities.setGlobalInstallation(null);
                break;
            }
            case 1: {
                List<File> list = Utilities.sharedDirs();
                if (list.isEmpty()) {
                    NotifyDescriptor notifyDescriptor = new NotifyDescriptor((Object)NbBundle.getMessage(SettingsTab.class, (String)"SettingsTab.cbSharedInstall.NoSharedMessage"), NbBundle.getMessage(SettingsTab.class, (String)"SettingsTab.cbSharedInstall.NoSharedTitle"), 0, 0, new Object[]{NotifyDescriptor.OK_OPTION}, null);
                    DialogDisplayer.getDefault().notifyLater(notifyDescriptor);
                    this.cbLocation.setSelectedIndex(0);
                    break;
                }
                for (File file : list) {
                    if (file.exists() && file.isDirectory() && !Utilities.canWriteInCluster(file)) {
                        NotifyDescriptor notifyDescriptor = new NotifyDescriptor((Object)NbBundle.getMessage(SettingsTab.class, (String)"SettingsTab.cbSharedInstall.ReadOnlyMessage", (Object)file), NbBundle.getMessage(SettingsTab.class, (String)"SettingsTab.cbSharedInstall.ReadOnlyTitle"), 0, 0, new Object[]{NotifyDescriptor.OK_OPTION}, null);
                        DialogDisplayer.getDefault().notifyLater(notifyDescriptor);
                        this.cbLocation.setSelectedIndex(0);
                        break block0;
                    }
                    Utilities.setGlobalInstallation(true);
                }
                break;
            }
            case 2: {
                Utilities.setGlobalInstallation(false);
                break;
            }
            default: {
                assert (false) : "Unknow index";
                break;
            }
        }
    }

    public SettingsTableModel getSettingsTableModel() {
        return (SettingsTableModel)this.table.getModel();
    }

    private long lastModification(UpdateUnitProvider updateUnitProvider) {
        Preferences preferences = NbPreferences.root().node("/org/netbeans/modules/autoupdate");
        return preferences.getLong(updateUnitProvider.getName() + "_" + "lastCheckTime", 0L);
    }

    private boolean needRefresh() {
        return this.refreshModel;
    }

    public void setNeedRefresh() {
        this.refreshModel = true;
        this.getPluginManager().undecorateTabTitles();
    }

    private void setData(UpdateUnitProvider updateUnitProvider, UpdateUnitProviderPanel updateUnitProviderPanel) {
        updateUnitProvider.setDisplayName(updateUnitProviderPanel.getProviderName());
        boolean bl = false;
        try {
            URL uRL = updateUnitProvider.getProviderURL();
            URL uRL2 = new URL(updateUnitProviderPanel.getProviderURL());
            if (!uRL.toExternalForm().equals(uRL2.toExternalForm())) {
                updateUnitProvider.setProviderURL(uRL2);
                this.setNeedRefresh();
                bl = true;
            }
        }
        catch (MalformedURLException malformedURLException) {
            Logger.getLogger(SettingsTab.class.getName()).log(Level.INFO, malformedURLException.getLocalizedMessage(), malformedURLException);
        }
        updateUnitProvider.setEnable(updateUnitProviderPanel.isActive());
        if (updateUnitProviderPanel.isActive()) {
            this.refreshProvider(updateUnitProvider, bl);
        } else {
            this.setNeedRefresh();
        }
    }

    public void refreshProvider(final UpdateUnitProvider updateUnitProvider, final boolean bl) {
        this.setWaitingState(true);
        Utilities.startAsWorkerThread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    Utilities.presentRefreshProviders(Collections.singleton(updateUnitProvider), SettingsTab.this.getPluginManager(), bl);
                    SettingsTab.this.getPluginManager().updateUnitsChanged();
                }
                finally {
                    SettingsTab.this.setWaitingState(false);
                }
            }
        });
    }

    private static DialogDescriptor getCustomizerDescriptor(UpdateUnitProviderPanel updateUnitProviderPanel) {
        JButton jButton = updateUnitProviderPanel.getOKButton();
        Object[] objectArray = new Object[]{jButton, DialogDescriptor.CANCEL_OPTION};
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)updateUnitProviderPanel, updateUnitProviderPanel.getDisplayName(), true, objectArray, DialogDescriptor.OK_OPTION, 0, null, null);
        return dialogDescriptor;
    }

    private int getAutoUpdatePeriod() {
        return AutoupdateSettings.getPeriod();
    }

    private void setAutoUpdatePeriod(int n) {
        if (n != this.getAutoUpdatePeriod()) {
            AutoupdateSettings.setPeriod(n);
            this.cbCheckPeriod.removeItem(SettingsTab.getMessage("CTL_Update_custom"));
        }
    }

    void setWaitingState(boolean bl) {
        this.getPluginManager().setWaitingState(bl);
        this.table.setEnabled(!bl);
    }

    private static class UpdateProviderRenderer
    extends DefaultTableCellRenderer {
        private UpdateProviderRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            JLabel jLabel;
            JLabel jLabel2 = (JLabel)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (object instanceof UpdateUnitProvider) {
                jLabel = (UpdateUnitProvider)object;
                Image image = jLabel.getSourceIcon();
                Icon icon = ImageUtilities.image2Icon((Image)image);
                jLabel2.setIcon(icon);
                jLabel2.setText(jLabel.getDisplayName());
                jLabel2.setHorizontalAlignment(2);
            }
            jLabel = jLabel2;
            return jLabel;
        }
    }

    private class Table
    extends JTable {
        public Table() {
            this.setShowGrid(false);
            this.setIntercellSpacing(new Dimension(0, 0));
            this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(UnitTable.class, (String)"ACN_UpdateCentersTable"));
            this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(UnitTab.class, (String)"ACD_UpdateCentersTable"));
            SettingsTab.this.lUpdateCenters.setLabelFor(this);
        }

        @Override
        public void addNotify() {
            super.addNotify();
            if (UIManager.getLookAndFeel().getID().equals("Nimbus")) {
                this.getParent().setBackground(new Color(this.getBackground().getRGB(), false));
            } else {
                this.getParent().setBackground(this.getBackground());
            }
        }

        @Override
        public Component prepareRenderer(TableCellRenderer tableCellRenderer, int n, int n2) {
            Component component = super.prepareRenderer(tableCellRenderer, n, n2);
            Color color = this.getBackground();
            Color color2 = UnitTable.getDarkerColor(color);
            if (this.isRowSelected(n)) {
                component.setForeground(this.getSelectionForeground());
            } else {
                component.setForeground(this.getForeground());
            }
            if (!this.isCellSelected(n, n2)) {
                if (n % 2 == 0) {
                    component.setBackground(color2);
                } else {
                    component.setBackground(color);
                }
            }
            return component;
        }
    }

    private class AddAction
    extends AbstractAction {
        AddAction() {
            super(UnitTab.textForKey("SettingsTab.AddButton.text"));
            this.putValue("MnemonicKey", UnitTab.mnemonicForKey("SettingsTab.AddButton.text"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            final UpdateUnitProviderPanel updateUnitProviderPanel = new UpdateUnitProviderPanel(true, NbBundle.getMessage(SettingsTab.class, (String)"SettingsTab_NewProviderName"), NbBundle.getMessage(SettingsTab.class, (String)"SettingsTab_NewProviderURL"), false);
            DialogDescriptor dialogDescriptor = SettingsTab.getCustomizerDescriptor(updateUnitProviderPanel);
            updateUnitProviderPanel.getOKButton().addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        SettingsTab.this.getSettingsTableModel().add(updateUnitProviderPanel.getProviderName(), updateUnitProviderPanel.getProviderName(), new URL(updateUnitProviderPanel.getProviderURL()), updateUnitProviderPanel.isActive());
                        SettingsTab.this.getSettingsTableModel().refreshModel();
                        SettingsTableModel settingsTableModel = SettingsTab.this.getSettingsTableModel();
                        for (int i = 0; i < settingsTableModel.getRowCount(); ++i) {
                            String string = settingsTableModel.getValueAt(i, 1).toString();
                            if (updateUnitProviderPanel.getProviderName() == null || !updateUnitProviderPanel.getProviderName().equals(string)) continue;
                            SettingsTab.this.table.getSelectionModel().setSelectionInterval(i, i);
                        }
                    }
                    catch (MalformedURLException malformedURLException) {
                        Logger.getLogger(SettingsTab.class.getName()).log(Level.INFO, malformedURLException.getLocalizedMessage(), malformedURLException);
                    }
                }
            });
            DialogDisplayer.getDefault().createDialog(dialogDescriptor).setVisible(true);
        }
    }

    private class RemoveAction
    extends AbstractAction {
        RemoveAction() {
            super(UnitTab.textForKey("SettingsTab.RemoveButton.text"));
            this.putValue("MnemonicKey", UnitTab.mnemonicForKey("SettingsTab.RemoveButton.text"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int[] nArray;
            SettingsTableModel settingsTableModel = SettingsTab.this.getSettingsTableModel();
            for (int n : nArray = SettingsTab.this.table.getSelectedRows()) {
                UpdateUnitProvider updateUnitProvider;
                if (n == -1 || (updateUnitProvider = settingsTableModel.getUpdateUnitProvider(n)) == null) continue;
                String string = NbBundle.getMessage(SettingsTab.class, (String)"SettingsTab.bRemove.message", (Object)updateUnitProvider.getDisplayName());
                NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)string);
                confirmation.setOptionType(0);
                Object object = DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation);
                if (!NotifyDescriptor.YES_OPTION.equals(object)) continue;
                settingsTableModel.remove(n);
            }
            settingsTableModel.refreshModel();
            if (nArray.length > 0) {
                if (settingsTableModel.getRowCount() > nArray[0]) {
                    SettingsTab.this.table.getSelectionModel().setSelectionInterval(nArray[0], nArray[0]);
                } else {
                    SettingsTab.this.table.getSelectionModel().setSelectionInterval(0, 0);
                }
            }
        }
    }

    private class EditAction
    extends AbstractAction {
        EditAction() {
            super(UnitTab.textForKey("SettingsTab.EditButton.text"));
            this.putValue("MnemonicKey", UnitTab.mnemonicForKey("SettingsTab.EditButton.text"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            final int n = SettingsTab.this.table.getSelectedRow();
            if (n != -1) {
                final UpdateUnitProvider updateUnitProvider = SettingsTab.this.getSettingsTableModel().getUpdateUnitProvider(n);
                if (updateUnitProvider == null) {
                    return;
                }
                if (updateUnitProvider.getProviderURL() == null) {
                    return;
                }
                final UpdateUnitProviderPanel updateUnitProviderPanel = new UpdateUnitProviderPanel(updateUnitProvider.isEnabled(), updateUnitProvider.getDisplayName(), updateUnitProvider.getProviderURL().toExternalForm(), true);
                DialogDescriptor dialogDescriptor = SettingsTab.getCustomizerDescriptor(updateUnitProviderPanel);
                updateUnitProviderPanel.getOKButton().addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        SettingsTab.this.setData(updateUnitProvider, updateUnitProviderPanel);
                        SettingsTab.this.table.getSelectionModel().setSelectionInterval(n, n);
                    }
                });
                DialogDisplayer.getDefault().createDialog(dialogDescriptor).setVisible(true);
                if (SettingsTab.this.listener != null) {
                    SettingsTab.this.listener.modelOrSelectionChanged();
                }
            }
        }
    }

    private class Listener
    implements ListSelectionListener,
    TableModelListener,
    Runnable {
        private StringBuffer detailsText;
        private boolean sbEnabled;
        private String detailsTitle;

        private Listener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.modelOrSelectionChanged();
        }

        @Override
        public void tableChanged(TableModelEvent tableModelEvent) {
            this.modelOrSelectionChanged();
        }

        private synchronized void prepareContent() {
            assert (!SwingUtilities.isEventDispatchThread()) : "Invoke SettingsTab.prepareContent out of AWT only";
            int n = SettingsTab.this.table.getSelectedRow();
            if (n != -1 && SettingsTab.this.table.getRowCount() > 0 && SettingsTab.this.getSettingsTableModel().getUpdateUnitProvider(n) != null) {
                String string;
                Object object;
                UpdateUnitProvider updateUnitProvider = SettingsTab.this.getSettingsTableModel().getUpdateUnitProvider(n);
                this.detailsTitle = updateUnitProvider.getDisplayName();
                long l = SettingsTab.this.lastModification(updateUnitProvider);
                if (l > 0L) {
                    this.detailsText = new StringBuffer().append("<b>").append(NbBundle.getMessage(UnitTab.class, (String)"UnitTab_ReloadTime", (Object)"</b>")).append(new SimpleDateFormat().format(new Date(l))).append("<br>");
                } else {
                    object = SettingsTab.getMessage("UnitTab_ReloadTime_Never");
                    this.detailsText = new StringBuffer().append("<b>").append(NbBundle.getMessage(UnitTab.class, (String)"UnitTab_ReloadTime", (Object)"</b>")).append((String)object).append("<br>");
                }
                object = updateUnitProvider.getProviderURL();
                String string2 = string = updateUnitProvider.getDescription() == null ? "" : updateUnitProvider.getDescription();
                if (object != null) {
                    if (string.length() > 0) {
                        this.detailsText.append("<b>").append(SettingsTab.getMessage("SettingsTab_UpdateUnitProvider_Description")).append("</b><br>");
                        this.detailsText.append(string).append("<br><br>");
                    }
                    this.detailsText.append("<b>").append(SettingsTab.getMessage("SettingsTab_UpdateUnitProvider_URL")).append(" </b><a href=\"").append(((URL)object).toExternalForm()).append("\">").append(((URL)object).toExternalForm()).append("</a><br>");
                    this.sbEnabled = true;
                } else {
                    this.sbEnabled = false;
                }
            } else {
                this.detailsTitle = null;
                this.detailsText = null;
            }
            SwingUtilities.invokeLater(this);
        }

        private void modelOrSelectionChanged() {
            if (!SwingUtilities.isEventDispatchThread()) {
                this.prepareContent();
            } else {
                UnitDetails.UNIT_DETAILS_PROCESSOR.post((Runnable)this);
            }
        }

        @Override
        public void run() {
            if (!SwingUtilities.isEventDispatchThread()) {
                this.prepareContent();
            } else {
                SettingsTab.this.details.setText(this.detailsText == null ? null : this.detailsText.toString());
                SettingsTab.this.editAction.setEnabled(this.sbEnabled);
                SettingsTab.this.details.setTitle(this.detailsTitle);
                if (SettingsTab.this.table.getSelectedRow() != -1) {
                    SettingsTab.this.details.setActionListener(SettingsTab.this.removeAction);
                    SettingsTab.this.details.setActionListener2(SettingsTab.this.editAction);
                } else {
                    SettingsTab.this.details.setActionListener2(null);
                    SettingsTab.this.details.setActionListener(null);
                }
                SettingsTab.this.revalidate();
            }
        }
    }
}

