/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.pipeline.movavg;

import com.google.common.collect.EvictingQueue;
import org.elasticsearch.search.aggregations.pipeline.movavg.models.MovAvgModel;

public class SimulatedAnealingMinimizer {
    public static MovAvgModel minimize(MovAvgModel model, EvictingQueue<Double> train, double[] test) {
        double oldCost;
        double minTemp = 1.0E-4;
        int iterations = 100;
        double alpha = 0.9;
        MovAvgModel bestModel = model;
        MovAvgModel oldModel = model;
        double bestCost = oldCost = SimulatedAnealingMinimizer.cost(model, train, test);
        for (double temp = 1.0; temp > minTemp; temp *= alpha) {
            for (int i = 0; i < iterations; ++i) {
                MovAvgModel newModel = oldModel.neighboringModel();
                double newCost = SimulatedAnealingMinimizer.cost(newModel, train, test);
                double ap = SimulatedAnealingMinimizer.acceptanceProbability(oldCost, newCost, temp);
                if (!(ap > Math.random())) continue;
                oldModel = newModel;
                oldCost = newCost;
                if (!(newCost < bestCost)) continue;
                bestCost = newCost;
                bestModel = newModel;
            }
        }
        return bestModel;
    }

    private static double acceptanceProbability(double oldCost, double newCost, double temp) {
        return newCost < oldCost ? 1.0 : Math.exp(-(newCost - oldCost) / temp);
    }

    private static double cost(MovAvgModel model, EvictingQueue<Double> train, double[] test) {
        double error = 0.0;
        double[] predictions = model.predict(train, test.length);
        assert (predictions.length == test.length);
        for (int i = 0; i < predictions.length; ++i) {
            error += Math.abs(test[i] - predictions[i]);
        }
        return error;
    }
}

