/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport.local;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.component.Lifecycle;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.io.stream.NamedWriteableAwareStreamInput;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.BoundTransportAddress;
import org.elasticsearch.common.transport.LocalTransportAddress;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.ActionNotFoundTransportException;
import org.elasticsearch.transport.ConnectTransportException;
import org.elasticsearch.transport.NodeNotConnectedException;
import org.elasticsearch.transport.RemoteTransportException;
import org.elasticsearch.transport.RequestHandlerRegistry;
import org.elasticsearch.transport.ResponseHandlerFailureTransportException;
import org.elasticsearch.transport.Transport;
import org.elasticsearch.transport.TransportException;
import org.elasticsearch.transport.TransportMessage;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportResponseHandler;
import org.elasticsearch.transport.TransportSerializationException;
import org.elasticsearch.transport.TransportServiceAdapter;
import org.elasticsearch.transport.Transports;
import org.elasticsearch.transport.local.LocalTransportChannel;
import org.elasticsearch.transport.support.TransportStatus;

public class LocalTransport
extends AbstractLifecycleComponent<Transport>
implements Transport {
    public static final String LOCAL_TRANSPORT_THREAD_NAME_PREFIX = "local_transport";
    private final ThreadPool threadPool;
    private final ThreadPoolExecutor workers;
    private final Version version;
    private volatile TransportServiceAdapter transportServiceAdapter;
    private volatile BoundTransportAddress boundAddress;
    private volatile LocalTransportAddress localAddress;
    private static final ConcurrentMap<LocalTransportAddress, LocalTransport> transports = ConcurrentCollections.newConcurrentMap();
    private static final AtomicLong transportAddressIdGenerator = new AtomicLong();
    private final ConcurrentMap<DiscoveryNode, LocalTransport> connectedNodes = ConcurrentCollections.newConcurrentMap();
    private final NamedWriteableRegistry namedWriteableRegistry;
    public static final String TRANSPORT_LOCAL_ADDRESS = "transport.local.address";
    public static final String TRANSPORT_LOCAL_WORKERS = "transport.local.workers";
    public static final String TRANSPORT_LOCAL_QUEUE = "transport.local.queue";

    @Inject
    public LocalTransport(Settings settings, ThreadPool threadPool, Version version, NamedWriteableRegistry namedWriteableRegistry) {
        super(settings);
        this.threadPool = threadPool;
        this.version = version;
        int workerCount = this.settings.getAsInt(TRANSPORT_LOCAL_WORKERS, (Integer)EsExecutors.boundedNumberOfProcessors(settings));
        int queueSize = this.settings.getAsInt(TRANSPORT_LOCAL_QUEUE, (Integer)-1);
        this.logger.debug("creating [{}] workers, queue_size [{}]", workerCount, queueSize);
        ThreadFactory threadFactory = EsExecutors.daemonThreadFactory(this.settings, LOCAL_TRANSPORT_THREAD_NAME_PREFIX);
        this.workers = EsExecutors.newFixed(LOCAL_TRANSPORT_THREAD_NAME_PREFIX, workerCount, queueSize, threadFactory);
        this.namedWriteableRegistry = namedWriteableRegistry;
    }

    @Override
    public TransportAddress[] addressesFromString(String address, int perAddressLimit) {
        return new TransportAddress[]{new LocalTransportAddress(address)};
    }

    @Override
    public boolean addressSupported(Class<? extends TransportAddress> address) {
        return LocalTransportAddress.class.equals(address);
    }

    @Override
    protected void doStart() {
        String address = this.settings.get(TRANSPORT_LOCAL_ADDRESS);
        if (address == null) {
            address = Long.toString(transportAddressIdGenerator.incrementAndGet());
        }
        this.localAddress = new LocalTransportAddress(address);
        LocalTransport previous = transports.put(this.localAddress, this);
        if (previous != null) {
            throw new ElasticsearchException("local address [" + address + "] is already bound", new Object[0]);
        }
        this.boundAddress = new BoundTransportAddress(new TransportAddress[]{this.localAddress}, this.localAddress);
    }

    @Override
    protected void doStop() {
        transports.remove(this.localAddress);
        for (LocalTransport targetTransport : transports.values()) {
            for (Map.Entry entry : targetTransport.connectedNodes.entrySet()) {
                if (entry.getValue() != this) continue;
                targetTransport.disconnectFromNode((DiscoveryNode)entry.getKey());
            }
        }
    }

    @Override
    protected void doClose() {
        ThreadPool.terminate(this.workers, 10L, TimeUnit.SECONDS);
    }

    @Override
    public void transportServiceAdapter(TransportServiceAdapter transportServiceAdapter) {
        this.transportServiceAdapter = transportServiceAdapter;
    }

    @Override
    public BoundTransportAddress boundAddress() {
        return this.boundAddress;
    }

    @Override
    public Map<String, BoundTransportAddress> profileBoundAddresses() {
        return Collections.EMPTY_MAP;
    }

    @Override
    public boolean nodeConnected(DiscoveryNode node) {
        return this.connectedNodes.containsKey(node);
    }

    @Override
    public void connectToNodeLight(DiscoveryNode node) throws ConnectTransportException {
        this.connectToNode(node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connectToNode(DiscoveryNode node) throws ConnectTransportException {
        LocalTransport localTransport = this;
        synchronized (localTransport) {
            if (this.connectedNodes.containsKey(node)) {
                return;
            }
            LocalTransport targetTransport = (LocalTransport)transports.get(node.address());
            if (targetTransport == null) {
                throw new ConnectTransportException(node, "Failed to connect");
            }
            this.connectedNodes.put(node, targetTransport);
            this.transportServiceAdapter.raiseNodeConnected(node);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnectFromNode(DiscoveryNode node) {
        LocalTransport localTransport = this;
        synchronized (localTransport) {
            LocalTransport removed = (LocalTransport)this.connectedNodes.remove(node);
            if (removed != null) {
                this.transportServiceAdapter.raiseNodeDisconnected(node);
            }
        }
    }

    @Override
    public long serverOpen() {
        return 0L;
    }

    @Override
    public void sendRequest(DiscoveryNode node, final long requestId, final String action, TransportRequest request, TransportRequestOptions options) throws IOException, TransportException {
        final Version version = Version.smallest(node.version(), this.version);
        try (BytesStreamOutput stream = new BytesStreamOutput();){
            stream.setVersion(version);
            stream.writeLong(requestId);
            byte status = 0;
            status = TransportStatus.setRequest(status);
            stream.writeByte(status);
            stream.writeString(action);
            request.writeTo(stream);
            stream.close();
            final LocalTransport targetTransport = (LocalTransport)this.connectedNodes.get(node);
            if (targetTransport == null) {
                throw new NodeNotConnectedException(node, "Node not connected");
            }
            final byte[] data = stream.bytes().toBytes();
            this.transportServiceAdapter.sent(data.length);
            this.transportServiceAdapter.onRequestSent(node, requestId, action, request, options);
            targetTransport.workers().execute(new Runnable(){

                @Override
                public void run() {
                    targetTransport.messageReceived(data, action, LocalTransport.this, version, requestId);
                }
            });
        }
    }

    ThreadPoolExecutor workers() {
        return this.workers;
    }

    protected void messageReceived(byte[] data, String action, LocalTransport sourceTransport, Version version, @Nullable Long sendRequestId) {
        Transports.assertTransportThread();
        try {
            this.transportServiceAdapter.received(data.length);
            StreamInput stream = StreamInput.wrap(data);
            stream.setVersion(version);
            long requestId = stream.readLong();
            byte status = stream.readByte();
            boolean isRequest = TransportStatus.isRequest(status);
            if (isRequest) {
                this.handleRequest(stream, requestId, sourceTransport, version);
            } else {
                TransportResponseHandler handler = this.transportServiceAdapter.onResponseReceived(requestId);
                if (handler != null) {
                    if (TransportStatus.isError(status)) {
                        this.handlerResponseError(stream, handler);
                    } else {
                        this.handleResponse(stream, sourceTransport, handler);
                    }
                }
            }
        }
        catch (Throwable e) {
            if (sendRequestId != null) {
                TransportResponseHandler handler = this.transportServiceAdapter.onResponseReceived(sendRequestId);
                if (handler != null) {
                    this.handleException(handler, new RemoteTransportException(this.nodeName(), this.localAddress, action, e));
                }
            }
            this.logger.warn("Failed to receive message for action [" + action + "]", e, new Object[0]);
        }
    }

    private void handleRequest(StreamInput stream, long requestId, LocalTransport sourceTransport, Version version) throws Exception {
        stream = new NamedWriteableAwareStreamInput(stream, this.namedWriteableRegistry);
        String action = stream.readString();
        this.transportServiceAdapter.onRequestReceived(requestId, action);
        LocalTransportChannel transportChannel = new LocalTransportChannel(this, this.transportServiceAdapter, sourceTransport, action, requestId, version);
        try {
            final RequestHandlerRegistry reg = this.transportServiceAdapter.getRequestHandler(action);
            if (reg == null) {
                throw new ActionNotFoundTransportException("Action [" + action + "] not found");
            }
            Object request = reg.newRequest();
            ((TransportMessage)request).remoteAddress(sourceTransport.boundAddress.publishAddress());
            ((TransportMessage)request).readFrom(stream);
            if ("same".equals(reg.getExecutor())) {
                reg.processMessageReceived(request, transportChannel);
            } else {
                this.threadPool.executor(reg.getExecutor()).execute(new AbstractRunnable((TransportRequest)request, transportChannel, action){
                    final /* synthetic */ TransportRequest val$request;
                    final /* synthetic */ LocalTransportChannel val$transportChannel;
                    final /* synthetic */ String val$action;
                    {
                        this.val$request = transportRequest;
                        this.val$transportChannel = localTransportChannel;
                        this.val$action = string;
                    }

                    @Override
                    protected void doRun() throws Exception {
                        reg.processMessageReceived(this.val$request, this.val$transportChannel);
                    }

                    @Override
                    public boolean isForceExecution() {
                        return reg.isForceExecution();
                    }

                    @Override
                    public void onFailure(Throwable e) {
                        if (LocalTransport.this.lifecycleState() == Lifecycle.State.STARTED) {
                            try {
                                this.val$transportChannel.sendResponse(e);
                            }
                            catch (Throwable e1) {
                                LocalTransport.this.logger.warn("Failed to send error message back to client for action [" + this.val$action + "]", e1, new Object[0]);
                                LocalTransport.this.logger.warn("Actual Exception", e, new Object[0]);
                            }
                        }
                    }
                });
            }
        }
        catch (Throwable e) {
            try {
                transportChannel.sendResponse(e);
            }
            catch (Throwable e1) {
                this.logger.warn("Failed to send error message back to client for action [" + action + "]", e, new Object[0]);
                this.logger.warn("Actual Exception", e1, new Object[0]);
            }
        }
    }

    protected void handleResponse(StreamInput buffer, LocalTransport sourceTransport, TransportResponseHandler handler) {
        buffer = new NamedWriteableAwareStreamInput(buffer, this.namedWriteableRegistry);
        Object response = handler.newInstance();
        ((TransportMessage)response).remoteAddress(sourceTransport.boundAddress.publishAddress());
        try {
            ((TransportMessage)response).readFrom(buffer);
        }
        catch (Throwable e) {
            this.handleException(handler, new TransportSerializationException("Failed to deserialize response of type [" + response.getClass().getName() + "]", e));
            return;
        }
        this.handleParsedResponse((TransportResponse)response, handler);
    }

    protected void handleParsedResponse(final TransportResponse response, final TransportResponseHandler handler) {
        this.threadPool.executor(handler.executor()).execute(new Runnable(){

            @Override
            public void run() {
                try {
                    handler.handleResponse(response);
                }
                catch (Throwable e) {
                    LocalTransport.this.handleException(handler, new ResponseHandlerFailureTransportException(e));
                }
            }
        });
    }

    private void handlerResponseError(StreamInput buffer, TransportResponseHandler handler) {
        Object error;
        try {
            error = buffer.readThrowable();
        }
        catch (Throwable e) {
            error = new TransportSerializationException("Failed to deserialize exception response from stream", e);
        }
        this.handleException(handler, (Throwable)error);
    }

    private void handleException(TransportResponseHandler handler, Throwable error) {
        if (!(error instanceof RemoteTransportException)) {
            error = new RemoteTransportException("None remote transport exception", null, null, error);
        }
        RemoteTransportException rtx = (RemoteTransportException)error;
        try {
            handler.handleException(rtx);
        }
        catch (Throwable t) {
            this.logger.error("failed to handle exception response [{}]", t, handler);
        }
    }

    @Override
    public List<String> getLocalAddresses() {
        return Collections.singletonList("0.0.0.0");
    }
}

