/*
 * Decompiled with CFR 0.152.
 */
package info.dolezel.fatrat.plugins.util;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class FormatUtils {
    private static final Pattern reFileSize = Pattern.compile("(\\d+[\\d\\.,]+)\\s*(b|ki?b|mi?b|gi?b|ti?b|pi?b)", 2);

    private FormatUtils() {
    }

    public static String formatSize(long l) {
        if (l < 1024L) {
            return l + " B";
        }
        if (l < 0x100000L) {
            return FormatUtils.singleDecimalDigit((double)l / 1024.0) + " KB";
        }
        if (l < 0x40000000L) {
            return FormatUtils.singleDecimalDigit((double)l / 1024.0 / 1024.0) + " MB";
        }
        return FormatUtils.singleDecimalDigit((double)l / 1024.0 / 1024.0 / 1024.0) + " GB";
    }

    public static String singleDecimalDigit(double d) {
        return new DecimalFormat("#.#").format(d);
    }

    public static String formatTime(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = n / 86400;
        int n3 = (n %= 86400) / 3600;
        int n4 = (n %= 3600) / 60;
        int n5 = n % 60;
        if (n2 > 0) {
            stringBuilder.append(n2).append("d ");
        }
        if (n3 > 0) {
            stringBuilder.append(n3).append("h ");
        }
        if (n4 > 0) {
            stringBuilder.append(n4).append("m ");
        }
        if (n5 > 0) {
            stringBuilder.append(n5).append("s ");
        }
        return stringBuilder.toString();
    }

    public static long parseSize(String string) {
        Matcher matcher = reFileSize.matcher(string);
        if (!matcher.find()) {
            return -1L;
        }
        String string2 = matcher.group(1).replace(',', '.');
        String string3 = matcher.group(2).toLowerCase().replace("i", "");
        double d = Double.parseDouble(string2);
        if (!string3.equals("b")) {
            d = string3.equals("kb") ? (d *= 1024.0) : (string3.equals("mb") ? (d *= 1048576.0) : (string3.equals("gb") ? (d *= 1.073741824E9) : (string3.equals("tb") ? (d *= 1.099511627776E12) : (string3.equals("pb") ? (d *= 1.125899906842624E15) : -1.0))));
        }
        return (long)d;
    }

    public static Pattern getFileSizePattern() {
        return reFileSize;
    }

    public static Map<String, String> parseQueryString(String string) {
        try {
            String[] stringArray;
            HashMap<String, String> hashMap = new HashMap<String, String>();
            for (String string2 : stringArray = string.split("&")) {
                String[] stringArray2 = string2.split("=", 2);
                if (stringArray2.length != 2) continue;
                String string3 = URLDecoder.decode(stringArray2[0], "UTF-8");
                String string4 = URLDecoder.decode(stringArray2[1], "UTF-8");
                hashMap.put(string3, string4);
            }
            return hashMap;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }
}

