/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.tools.anttasks;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.StringTokenizer;
import org.apache.commons.io.IOUtils;
import org.apache.tools.ant.BuildException;

public class FileCompare {
    private String referenceDirectory;
    private String testDirectory;
    private String[] filenameList;

    public void setTestDirectory(String testDirectory) {
        if (!testDirectory.endsWith("/") && !testDirectory.endsWith("\\")) {
            testDirectory = testDirectory + File.separator;
        }
        this.testDirectory = testDirectory;
    }

    public void setReferenceDirectory(String referenceDirectory) {
        if (!referenceDirectory.endsWith("/") && !referenceDirectory.endsWith("\\")) {
            referenceDirectory = referenceDirectory + File.separator;
        }
        this.referenceDirectory = referenceDirectory;
    }

    public void setFilenames(String filenames) {
        StringTokenizer tokens = new StringTokenizer(filenames, ",");
        ArrayList<String> filenameListTmp = new ArrayList<String>(20);
        while (tokens.hasMoreTokens()) {
            filenameListTmp.add(tokens.nextToken());
        }
        this.filenameList = new String[filenameListTmp.size()];
        this.filenameList = filenameListTmp.toArray(new String[filenameListTmp.size()]);
    }

    public static boolean compareFiles(File f1, File f2) throws IOException {
        return FileCompare.compareFileSize(f1, f2) && FileCompare.compareBytes(f1, f2);
    }

    private static boolean compareBytes(File file1, File file2) throws IOException {
        boolean same = true;
        BufferedInputStream file1Input = new BufferedInputStream(new FileInputStream(file1));
        BufferedInputStream file2Input = new BufferedInputStream(new FileInputStream(file2));
        int charact1 = 0;
        int charact2 = 0;
        while (charact1 != -1) {
            if (charact1 == charact2) {
                charact1 = file1Input.read();
                charact2 = file2Input.read();
                continue;
            }
            same = false;
            break;
        }
        IOUtils.closeQuietly((InputStream)file1Input);
        IOUtils.closeQuietly((InputStream)file2Input);
        return same;
    }

    private static boolean compareFileSize(File oldFile, File newFile) {
        return oldFile.length() == newFile.length();
    }

    private boolean filesExist(File oldFile, File newFile) {
        if (!oldFile.exists()) {
            System.err.println("Task Compare - ERROR: File " + this.referenceDirectory + oldFile.getName() + " doesn't exist!");
            return false;
        }
        if (!newFile.exists()) {
            System.err.println("Task Compare - ERROR: File " + this.testDirectory + newFile.getName() + " doesn't exist!");
            return false;
        }
        return true;
    }

    private void writeHeader(PrintWriter results) {
        String dateTime = DateFormat.getDateTimeInstance(2, 2).format(new Date());
        results.println("<html><head><title>Test Results</title></head><body>\n");
        results.println("<h2>Compare Results<br>");
        results.println("<font size='1'>created " + dateTime + "</font></h2>");
        results.println("<table cellpadding='10' border='2'><thead><th align='center'>reference file</th><th align='center'>test file</th><th align='center'>identical?</th></thead>");
    }

    public void execute() throws BuildException {
        boolean identical = false;
        try {
            PrintWriter results = new PrintWriter((Writer)new FileWriter("results.html"), true);
            this.writeHeader(results);
            for (int i = 0; i < this.filenameList.length; ++i) {
                File newFile;
                File oldFile = new File(this.referenceDirectory + this.filenameList[i]);
                if (!this.filesExist(oldFile, newFile = new File(this.testDirectory + this.filenameList[i]))) continue;
                identical = FileCompare.compareFileSize(oldFile, newFile);
                if (identical) {
                    identical = FileCompare.compareBytes(oldFile, newFile);
                }
                if (!identical) {
                    System.out.println("Task Compare: \nFiles " + this.referenceDirectory + oldFile.getName() + " - " + this.testDirectory + newFile.getName() + " are *not* identical.");
                    results.println("<tr><td><a href='" + this.referenceDirectory + oldFile.getName() + "'>" + oldFile.getName() + "</a> </td><td> <a href='" + this.testDirectory + newFile.getName() + "'>" + newFile.getName() + "</a>" + " </td><td><font color='red'>No</font></td></tr>");
                    continue;
                }
                results.println("<tr><td><a href='" + this.referenceDirectory + oldFile.getName() + "'>" + oldFile.getName() + "</a> </td><td> <a href='" + this.testDirectory + newFile.getName() + "'>" + newFile.getName() + "</a>" + " </td><td>Yes</td></tr>");
            }
            results.println("</table></html>");
        }
        catch (IOException ioe) {
            System.err.println("ERROR: " + ioe);
        }
    }
}

