/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.play.internal.spec;

import java.io.File;
import javax.inject.Inject;
import org.gradle.api.reporting.components.internal.AbstractBinaryRenderer;
import org.gradle.api.tasks.diagnostics.internal.text.TextReportBuilder;
import org.gradle.model.internal.manage.schema.ModelSchemaStore;
import org.gradle.play.PlayApplicationBinarySpec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlayApplicationBinaryRenderer
extends AbstractBinaryRenderer<PlayApplicationBinarySpec> {
    @Inject
    public PlayApplicationBinaryRenderer(ModelSchemaStore schemaStore) {
        super(schemaStore);
    }

    protected void renderDetails(PlayApplicationBinarySpec binary, TextReportBuilder builder) {
        builder.item("toolchain", binary.getToolChain().getDisplayName());
    }

    protected void renderOutputs(PlayApplicationBinarySpec binary, TextReportBuilder builder) {
        builder.item("classes dir", binary.getClasses().getClassesDir());
        for (File dir : binary.getClasses().getResourceDirs()) {
            builder.item("resources dir", dir);
        }
        builder.item("JAR file", binary.getJarFile());
    }

    public Class<PlayApplicationBinarySpec> getTargetType() {
        return PlayApplicationBinarySpec.class;
    }
}

